/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mod_compat.IrisShadowPassDetection;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.parts.EMFModelPartCustom;
import traben.entity_model_features.models.parts.EMFModelPartRoot;
import traben.entity_model_features.models.parts.EMFModelPartVanilla;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.ETFVertexConsumer;

public abstract class EMFModelPart
extends ModelPart {
    public ResourceLocation textureOverride;
    protected long lastTextureOverride = -1L;
    public boolean isSetByAnimation = false;

    public EMFModelPart(List<ModelPart.Cube> cuboids, Map<String, ModelPart> children) {
        super(cuboids, children);
        this.cubes = new ObjectArrayList(cuboids);
        this.children = new Object2ObjectOpenHashMap(children);
    }

    public void render(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int k) {
        try {
            EMFConfig.RenderModeChoice choice = ((EMFConfig)EMF.config().getConfig()).getRenderModeFor(EMFAnimationEntityContext.getEMFEntity());
            if (choice == EMFConfig.RenderModeChoice.NORMAL) {
                this.renderWithTextureOverride(matrices, vertices, light, overlay, k);
                return;
            }
            if (((EMFConfig)EMF.config().getConfig()).onlyDebugRenderOnHover && !EMFAnimationEntityContext.isClientHovered()) {
                this.renderWithTextureOverride(matrices, vertices, light, overlay, k);
                return;
            }
            switch (choice) {
                case GREEN: {
                    this.renderDebugTinted(matrices, vertices, light, overlay, k);
                    break;
                }
                case LINES: {
                    this.renderBoxes(matrices, Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines()));
                    break;
                }
                case LINES_AND_TEXTURE: {
                    this.renderWithTextureOverride(matrices, vertices, light, overlay, k);
                    this.renderBoxesNoChildren(matrices, Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines()), 1.0f);
                    break;
                }
                case LINES_AND_TEXTURE_FLASH: {
                    this.renderWithTextureOverride(matrices, vertices, light, overlay, k);
                    float flash = (Mth.sin((float)((float)System.currentTimeMillis() / 1000.0f)) + 1.0f) / 2.0f;
                    this.renderBoxesNoChildren(matrices, Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines()), flash);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderDebugTinted(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int k) {
        float flash = Math.abs(Mth.sin((float)((float)System.currentTimeMillis() / 1000.0f)));
        int col = ARGB.color((int)((int)(255.0f * flash)), (int)ARGB.green((int)k), (int)((int)(255.0f * flash)), (int)ARGB.alpha((int)k));
        this.renderWithTextureOverride(matrices, vertices, light, overlay, col);
    }

    void renderWithTextureOverride(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int k) {
        if (this.textureOverride == null || this.lastTextureOverride == EMFManager.getInstance().entityRenderCount) {
            this.renderLikeETF(matrices, vertices, light, overlay, k);
        } else if (light != 0xF000F1 && !ETFRenderContext.isIsInSpecialRenderOverlayPhase()) {
            if (EMFAnimationEntityContext.getEMFEntity() != null && EMFAnimationEntityContext.getEMFEntity().etf$isBlockEntity() && ETF.IRIS_DETECTED && IrisShadowPassDetection.getInstance().inShadowPass()) {
                this.renderLikeETF(matrices, vertices, light, overlay, k);
                return;
            }
            if (vertices instanceof ETFVertexConsumer) {
                ETFVertexConsumer etfVertexConsumer = (ETFVertexConsumer)vertices;
                ETFTexture etfTextureTest = etfVertexConsumer.etf$getETFTexture();
                if (etfTextureTest != null && etfTextureTest.thisIdentifier.equals((Object)this.textureOverride)) {
                    this.renderLikeETF(matrices, vertices, light, overlay, k);
                    return;
                }
                RenderType originalLayer = etfVertexConsumer.etf$getRenderLayer();
                if (originalLayer == null) {
                    return;
                }
                MultiBufferSource provider = etfVertexConsumer.etf$getProvider();
                if (provider == null) {
                    return;
                }
                this.renderTextureOverrideWithoutReset(provider, matrices, light, overlay, k);
                provider.getBuffer(originalLayer);
            } else {
                MultiBufferSource.BufferSource provider = Minecraft.getInstance().renderBuffers().bufferSource();
                this.renderTextureOverrideWithoutReset((MultiBufferSource)provider, matrices, light, overlay, k);
            }
        }
    }

    private void renderTextureOverrideWithoutReset(MultiBufferSource provider, PoseStack matrices, int light, int overlay, int k) {
        this.lastTextureOverride = EMFManager.getInstance().entityRenderCount;
        RenderType layerModified = EMFAnimationEntityContext.getLayerFromRecentFactoryOrETFOverrideOrTranslucent(this.textureOverride);
        VertexConsumer newConsumer = provider.getBuffer(layerModified);
        this.renderLikeVanilla(matrices, newConsumer, light, overlay, k);
        if (newConsumer instanceof ETFVertexConsumer) {
            ETFVertexConsumer newETFConsumer = (ETFVertexConsumer)newConsumer;
            ETFTexture etfTexture = newETFConsumer.etf$getETFTexture();
            if (etfTexture == null) {
                return;
            }
            ETFUtils2.RenderMethodForOverlay renderMethodForOverlay = (prov, ligh) -> this.renderLikeVanilla(matrices, prov, ligh, overlay, k);
            ETFUtils2.renderEmissive((ETFTexture)etfTexture, (MultiBufferSource)provider, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay);
            ETFUtils2.renderEnchanted((ETFTexture)etfTexture, (MultiBufferSource)provider, (int)light, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay);
        }
    }

    void renderLikeVanilla(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int k) {
        if (!(!this.visible || this.cubes.isEmpty() && this.children.isEmpty())) {
            matrices.pushPose();
            this.translateAndRotate(matrices);
            if (!this.skipDraw) {
                this.compile(matrices.last(), vertices, light, overlay, k);
            }
            for (ModelPart modelPart : this.children.values()) {
                modelPart.render(matrices, vertices, light, overlay, k);
            }
            matrices.popPose();
        }
    }

    /*
     * Unable to fully structure code
     */
    private VertexConsumer testForBuildingException(VertexConsumer vertices) {
        block7: {
            block8: {
                block6: {
                    if (!(vertices instanceof BufferBuilder)) break block6;
                    testBuilding = (BufferBuilder)vertices;
                    break block7;
                }
                if (!(vertices instanceof SpriteCoordinateExpander)) break block8;
                sprite = (SpriteCoordinateExpander)vertices;
                if (!(sprite.delegate instanceof BufferBuilder)) break block8;
                testBuilding = (BufferBuilder)sprite.delegate;
                break block7;
            }
            if (!(vertices instanceof VertexMultiConsumer.Double)) ** GOTO lbl-1000
            dub = (VertexMultiConsumer.Double)vertices;
            if (dub.second instanceof BufferBuilder) {
                testBuilding = (BufferBuilder)dub.second;
            } else lbl-1000:
            // 2 sources

            {
                return vertices;
            }
        }
        if (testBuilding != null && !testBuilding.building) {
            if (testBuilding instanceof ETFVertexConsumer && (etf = (ETFVertexConsumer)testBuilding).etf$getRenderLayer() != null && etf.etf$getProvider() != null) {
                allowed = ETFRenderContext.isAllowedToRenderLayerTextureModify();
                ETFRenderContext.preventRenderLayerTextureModify();
                vertices = etf.etf$getProvider().getBuffer(etf.etf$getRenderLayer());
                if (allowed) {
                    ETFRenderContext.allowRenderLayerTextureModify();
                }
            } else {
                return null;
            }
        }
        return vertices;
    }

    void renderLikeETF(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int k) {
        if ((vertices = this.testForBuildingException(vertices)) == null) {
            return;
        }
        ETFRenderContext.incrementCurrentModelPartDepth();
        this.renderLikeVanilla(matrices, vertices, light, overlay, k);
        if (ETFRenderContext.getCurrentModelPartDepth() != 1) {
            ETFRenderContext.decrementCurrentModelPartDepth();
        } else {
            ETFVertexConsumer etfVertexConsumer;
            ETFTexture texture;
            if (ETFRenderContext.isCurrentlyRenderingEntity() && vertices instanceof ETFVertexConsumer && (texture = (etfVertexConsumer = (ETFVertexConsumer)vertices).etf$getETFTexture()) != null && (texture.isEmissive() || texture.isEnchanted())) {
                ETFUtils2.RenderMethodForOverlay renderMethodForOverlay;
                MultiBufferSource provider = etfVertexConsumer.etf$getProvider();
                RenderType layer = etfVertexConsumer.etf$getRenderLayer();
                if (provider != null && layer != null && ETFUtils2.renderEmissive((ETFTexture)texture, (MultiBufferSource)provider, (ETFUtils2.RenderMethodForOverlay)(renderMethodForOverlay = (prov, ligh) -> this.renderLikeVanilla(matrices, prov, ligh, overlay, k))) | ETFUtils2.renderEnchanted((ETFTexture)texture, (MultiBufferSource)provider, (int)light, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay)) {
                    provider.getBuffer(layer);
                }
            }
            ETFRenderContext.resetCurrentModelPartDepth();
        }
    }

    public void renderBoxes(PoseStack matrices, VertexConsumer vertices) {
        if (!(!this.visible || this.cubes.isEmpty() && this.children.isEmpty())) {
            matrices.pushPose();
            this.translateAndRotate(matrices);
            if (!this.skipDraw) {
                for (ModelPart.Cube cuboid : this.cubes) {
                    AABB box = new AABB((double)(cuboid.minX / 16.0f), (double)(cuboid.minY / 16.0f), (double)(cuboid.minZ / 16.0f), (double)(cuboid.maxX / 16.0f), (double)(cuboid.maxY / 16.0f), (double)(cuboid.maxZ / 16.0f));
                    float[] col = this.debugBoxColor();
                    ShapeRenderer.renderLineBox((PoseStack.Pose)matrices.last(), (VertexConsumer)vertices, (AABB)box.inflate(1.0E-4), (float)col[0], (float)col[1], (float)col[2], (float)1.0f);
                }
            }
            for (ModelPart modelPart : this.children.values()) {
                if (!(modelPart instanceof EMFModelPart)) continue;
                EMFModelPart emf = (EMFModelPart)modelPart;
                emf.renderBoxes(matrices, vertices);
            }
            matrices.popPose();
        }
    }

    protected abstract float[] debugBoxColor();

    public void renderBoxesNoChildren(PoseStack matrices, VertexConsumer vertices, float alpha) {
        if (!(!this.visible || this.cubes.isEmpty() && this.children.isEmpty())) {
            matrices.pushPose();
            this.translateAndRotate(matrices);
            if (!this.skipDraw) {
                for (ModelPart.Cube cuboid : this.cubes) {
                    AABB box = new AABB((double)(cuboid.minX / 16.0f), (double)(cuboid.minY / 16.0f), (double)(cuboid.minZ / 16.0f), (double)(cuboid.maxX / 16.0f), (double)(cuboid.maxY / 16.0f), (double)(cuboid.maxZ / 16.0f));
                    float[] col = this.debugBoxColor();
                    ShapeRenderer.renderLineBox((PoseStack.Pose)matrices.last(), (VertexConsumer)vertices, (AABB)box.inflate(1.0E-4), (float)col[0], (float)col[1], (float)col[2], (float)alpha);
                }
            }
            matrices.popPose();
        }
    }

    public void compile(PoseStack.Pose pose, VertexConsumer vertexConsumer, int i, int j, int k) {
        try {
            for (ModelPart.Cube cuboid : this.cubes) {
                cuboid.compile(pose, vertexConsumer, i, j, k);
            }
        }
        catch (IllegalStateException e) {
            EMFUtils.logWarn("IllegalStateException caught in EMF model part");
        }
    }

    public String simplePrintChildren(int depth) {
        StringBuilder mapper = new StringBuilder();
        mapper.append("\n  | ");
        mapper.append("- ".repeat(Math.max(0, depth)));
        mapper.append(this.toStringShort());
        for (ModelPart child : this.children.values()) {
            if (!(child instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)child;
            mapper.append(emf.simplePrintChildren(depth + 1));
        }
        return mapper.toString();
    }

    public String toStringShort() {
        return this.toString();
    }

    public String toString() {
        return "generic emf part";
    }

    public ModelPart getVanillaModelPartsOfCurrentState() {
        HashMap<String, ModelPart> children = new HashMap<String, ModelPart>();
        for (Map.Entry child : this.children.entrySet()) {
            Object v = child.getValue();
            if (!(v instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)((Object)v);
            children.put((String)child.getKey(), emf.getVanillaModelPartsOfCurrentState());
        }
        List<ModelPart.Cube> finalCubes = this.cubes.isEmpty() ? List.of(new ModelPart.Cube(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f, Set.of())) : this.cubes;
        ModelPart part = new ModelPart((List)finalCubes, children);
        part.setInitialPose(this.getInitialPose());
        part.xRot = this.xRot;
        part.zRot = this.zRot;
        part.yRot = this.yRot;
        part.z = this.z;
        part.y = this.y;
        part.x = this.x;
        part.xScale = this.xScale;
        part.yScale = this.yScale;
        part.zScale = this.zScale;
        return part;
    }

    public Object2ReferenceOpenHashMap<String, EMFModelPart> getAllChildPartsAsAnimationMap(String prefixableParents, int variantNum, Map<String, String> optifinePartNameMap) {
        Object object = this;
        if (object instanceof EMFModelPartRoot) {
            EMFModelPartRoot root = (EMFModelPartRoot)((Object)object);
            root.setVariantStateTo(variantNum);
        }
        Object2ReferenceOpenHashMap mapOfAll = new Object2ReferenceOpenHashMap();
        for (ModelPart part : this.children.values()) {
            if (!(part instanceof EMFModelPart)) continue;
            EMFModelPart emfPart = (EMFModelPart)part;
            String thisKey = "NULL_KEY_NAME";
            boolean addThis = false;
            if (part instanceof EMFModelPartCustom) {
                EMFModelPartCustom partCustom = (EMFModelPartCustom)part;
                thisKey = partCustom.id;
                addThis = true;
            } else if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla partVanilla = (EMFModelPartVanilla)part;
                thisKey = partVanilla.name;
                addThis = partVanilla.isOptiFinePartSpecified;
            }
            for (Map.Entry<String, String> entry : optifinePartNameMap.entrySet()) {
                if (!entry.getValue().equals(thisKey)) continue;
                thisKey = entry.getKey();
                break;
            }
            if (addThis) {
                mapOfAll.putIfAbsent((Object)thisKey, (Object)emfPart);
                if (prefixableParents.isBlank()) {
                    mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(thisKey, variantNum, optifinePartNameMap));
                    continue;
                }
                mapOfAll.putIfAbsent((Object)(prefixableParents + ":" + thisKey), (Object)emfPart);
                mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(prefixableParents + ":" + thisKey, variantNum, optifinePartNameMap));
                continue;
            }
            mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(prefixableParents, variantNum, optifinePartNameMap));
        }
        return mapOfAll;
    }

    public static class Animator
    implements Runnable {
        private Runnable animation = null;

        Animator() {
        }

        public boolean hasAnimation() {
            return this.animation != null;
        }

        public Runnable getAnimation() {
            return this.animation;
        }

        public void setAnimation(Runnable animation) {
            this.animation = animation;
        }

        @Override
        public void run() {
            if (this.animation != null) {
                this.animation.run();
            }
        }
    }
}

