/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.mixins.accessor.CuboidAccessor;
import traben.entity_model_features.models.jem_objects.EMFBoxData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.models.parts.EMFModelPart;
import traben.entity_model_features.utils.EMFUtils;

public class EMFModelPartCustom
extends EMFModelPart {
    public final String partToBeAttached;
    public final String id;
    public final boolean attach;
    private final float defaultScale;
    @Nullable
    private final List<Consumer<PoseStack>> attachments;

    public EMFModelPartCustom(EMFPartData emfPartData, int variant, @Nullable String part, String id) {
        super(EMFModelPartCustom.getCuboidsFromData(emfPartData), EMFModelPartCustom.getChildrenFromData(emfPartData, variant));
        this.attach = emfPartData.attach;
        this.partToBeAttached = part;
        this.id = id;
        this.textureOverride = emfPartData.getCustomTexture();
        List<Consumer<PoseStack>> attachments = emfPartData.getAttachments();
        this.attachments = attachments.isEmpty() ? null : attachments;
        this.xScale = this.defaultScale = emfPartData.scale;
        this.yScale = this.defaultScale;
        this.zScale = this.defaultScale;
        this.x = emfPartData.translate[0];
        this.y = emfPartData.translate[1];
        this.z = emfPartData.translate[2];
        this.xRot = emfPartData.rotate[0];
        this.yRot = emfPartData.rotate[1];
        this.zRot = emfPartData.rotate[2];
        this.setInitialPose(this.storePose());
        if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
            EMFUtils.log(" > > EMF custom part made: " + emfPartData.id);
        }
    }

    public void resetPose() {
        super.resetPose();
        this.xScale = this.defaultScale;
        this.yScale = this.defaultScale;
        this.zScale = this.defaultScale;
    }

    private static List<ModelPart.Cube> getCuboidsFromData(EMFPartData emfPartData) {
        return EMFModelPartCustom.createCuboidsFromBoxDataV3(emfPartData);
    }

    private static Map<String, ModelPart> getChildrenFromData(EMFPartData emfPartData, int variant) {
        HashMap<String, ModelPart> emfChildren = new HashMap<String, ModelPart>();
        for (EMFPartData sub : emfPartData.submodels) {
            String idUnique = EMFUtils.getIdUnique(emfChildren.keySet(), sub.id);
            emfChildren.put(idUnique, new EMFModelPartCustom(sub, variant, null, idUnique));
        }
        return emfChildren;
    }

    private static List<ModelPart.Cube> createCuboidsFromBoxDataV3(EMFPartData emfPartData) {
        LinkedList<ModelPart.Cube> emfCuboids = new LinkedList<ModelPart.Cube>();
        if (emfPartData.boxes.length > 0) {
            try {
                for (EMFBoxData box : emfPartData.boxes) {
                    EMFCube cube = box.textureOffset.length == 2 ? new EMFCube(emfPartData, box.textureOffset[0], box.textureOffset[1], box.coordinates[0], box.coordinates[1], box.coordinates[2], box.coordinates[3], box.coordinates[4], box.coordinates[5], box.sizeAddX, box.sizeAddY, box.sizeAddZ, emfPartData.textureSize[0], emfPartData.textureSize[1], emfPartData.mirrorTexture.contains("u"), emfPartData.mirrorTexture.contains("v")) : new EMFCube(emfPartData, box.uvDown, box.uvUp, box.uvNorth, box.uvSouth, box.uvWest, box.uvEast, box.coordinates[0], box.coordinates[1], box.coordinates[2], box.coordinates[3], box.coordinates[4], box.coordinates[5], box.sizeAddX, box.sizeAddY, box.sizeAddZ, emfPartData.textureSize[0], emfPartData.textureSize[1], false, false);
                    emfCuboids.add(cube);
                }
            }
            catch (Exception e) {
                EMFUtils.log("cuboid construction broke: " + String.valueOf(e), false);
            }
        }
        return emfCuboids;
    }

    @Override
    public String toString() {
        return "[custom part " + this.id + "], cubes =" + this.cubes.size() + ", children = " + this.children.size();
    }

    @Override
    public String toStringShort() {
        return "[custom part " + this.id.replaceFirst("EMF_", "") + "]";
    }

    @Override
    public void render(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int k) {
        if (this.attachments != null) {
            for (Consumer<PoseStack> attachment : this.attachments) {
                matrices.pushPose();
                this.translateAndRotate(matrices);
                attachment.accept(matrices);
                matrices.popPose();
            }
        }
        super.render(matrices, vertices, light, overlay, k);
    }

    @Override
    protected float[] debugBoxColor() {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    @Override
    void renderWithTextureOverride(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int k) {
        if (this.textureOverride != null && this.lastTextureOverride == EMFManager.getInstance().entityRenderCount) {
            return;
        }
        super.renderWithTextureOverride(matrices, vertices, light, overlay, k);
    }

    static class EMFCube
    extends ModelPart.Cube {
        EMFCube(EMFPartData selfModelData, float textureU, float textureV, float cubeX, float cubeY, float cubeZ, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, float textureWidth, float textureHeight, boolean mirrorU, boolean mirrorV) throws Exception {
            super((int)textureU, (int)textureV, cubeX, cubeY, cubeZ, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, false, textureWidth, textureHeight, (Set)new HashSet<Direction>(){
                {
                    this.addAll(List.of(Direction.values()));
                }
            });
            CuboidAccessor accessor = (CuboidAccessor)((Object)this);
            accessor.setMinX(cubeX);
            accessor.setMinY(cubeY);
            accessor.setMinZ(cubeZ);
            accessor.setMaxX(cubeX + sizeX);
            accessor.setMaxY(cubeY + sizeY);
            accessor.setMaxZ(cubeZ + sizeZ);
            float cubeX2 = cubeX + sizeX;
            float cubeY2 = cubeY + sizeY;
            float cubeZ2 = cubeZ + sizeZ;
            ModelPart.Vertex vertex = new ModelPart.Vertex(cubeX -= extraX, cubeY -= extraY, cubeZ -= extraZ, 0.0f, 0.0f);
            ModelPart.Vertex vertex2 = new ModelPart.Vertex(cubeX2 += extraX, cubeY, cubeZ, 0.0f, 8.0f);
            ModelPart.Vertex vertex3 = new ModelPart.Vertex(cubeX2, cubeY2 += extraY, cubeZ, 8.0f, 8.0f);
            ModelPart.Vertex vertex4 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ, 8.0f, 0.0f);
            ModelPart.Vertex vertex5 = new ModelPart.Vertex(cubeX, cubeY, cubeZ2 += extraZ, 0.0f, 0.0f);
            ModelPart.Vertex vertex6 = new ModelPart.Vertex(cubeX2, cubeY, cubeZ2, 0.0f, 8.0f);
            ModelPart.Vertex vertex7 = new ModelPart.Vertex(cubeX2, cubeY2, cubeZ2, 8.0f, 8.0f);
            ModelPart.Vertex vertex8 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ2, 8.0f, 0.0f);
            ArrayList<ModelPart.Polygon> sides = new ArrayList<ModelPart.Polygon>();
            float j = textureU;
            float k = textureU + sizeZ;
            float l = textureU + sizeZ + sizeX;
            float m = textureU + sizeZ + sizeX + sizeX;
            float n = textureU + sizeZ + sizeX + sizeZ;
            float o = textureU + sizeZ + sizeX + sizeZ + sizeX;
            float p = textureV;
            float q = textureV + sizeZ;
            float r = textureV + sizeZ + sizeY;
            boolean printing = ((EMFConfig)EMF.config().getConfig()).logModelCreationData;
            try {
                ModelPart.Vertex[] vertexArray;
                if (mirrorV) {
                    ModelPart.Vertex[] vertexArray2 = new ModelPart.Vertex[4];
                    vertexArray2[0] = vertex3;
                    vertexArray2[1] = vertex4;
                    vertexArray2[2] = vertex8;
                    vertexArray = vertexArray2;
                    vertexArray2[3] = vertex7;
                } else {
                    ModelPart.Vertex[] vertexArray3 = new ModelPart.Vertex[4];
                    vertexArray3[0] = vertex6;
                    vertexArray3[1] = vertex5;
                    vertexArray3[2] = vertex;
                    vertexArray = vertexArray3;
                    vertexArray3[3] = vertex2;
                }
                sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? l : k, mirrorV ? q : p, mirrorU ? k : l, mirrorV ? p : q, textureWidth, textureHeight, false, mirrorV ? Direction.UP : Direction.DOWN));
            }
            catch (Exception e) {
                if (printing) {
                    EMFUtils.log("uv-dwn failed for " + selfModelData.id);
                }
                throw new Exception("uv-dwn failed for " + selfModelData.id);
            }
            try {
                ModelPart.Vertex[] vertexArray;
                if (mirrorV) {
                    ModelPart.Vertex[] vertexArray4 = new ModelPart.Vertex[4];
                    vertexArray4[0] = vertex6;
                    vertexArray4[1] = vertex5;
                    vertexArray4[2] = vertex;
                    vertexArray = vertexArray4;
                    vertexArray4[3] = vertex2;
                } else {
                    ModelPart.Vertex[] vertexArray5 = new ModelPart.Vertex[4];
                    vertexArray5[0] = vertex3;
                    vertexArray5[1] = vertex4;
                    vertexArray5[2] = vertex8;
                    vertexArray = vertexArray5;
                    vertexArray5[3] = vertex7;
                }
                sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? m : l, mirrorV ? p : q, mirrorU ? l : m, mirrorV ? q : p, textureWidth, textureHeight, false, mirrorV ? Direction.DOWN : Direction.UP));
            }
            catch (Exception e) {
                if (printing) {
                    EMFUtils.log("uv-up failed for " + selfModelData.id);
                }
                throw new Exception("uv-up failed for " + selfModelData.id);
            }
            try {
                ModelPart.Vertex[] vertexArray;
                if (mirrorU) {
                    ModelPart.Vertex[] vertexArray6 = new ModelPart.Vertex[4];
                    vertexArray6[0] = vertex6;
                    vertexArray6[1] = vertex2;
                    vertexArray6[2] = vertex3;
                    vertexArray = vertexArray6;
                    vertexArray6[3] = vertex7;
                } else {
                    ModelPart.Vertex[] vertexArray7 = new ModelPart.Vertex[4];
                    vertexArray7[0] = vertex;
                    vertexArray7[1] = vertex5;
                    vertexArray7[2] = vertex8;
                    vertexArray = vertexArray7;
                    vertexArray7[3] = vertex4;
                }
                sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? k : j, mirrorV ? r : q, mirrorU ? j : k, mirrorV ? q : r, textureWidth, textureHeight, false, mirrorU ? Direction.EAST : Direction.WEST));
            }
            catch (Exception e) {
                if (printing) {
                    EMFUtils.log("uv-west failed for " + selfModelData.id);
                }
                throw new Exception("uv-west failed for " + selfModelData.id);
            }
            try {
                sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex2, vertex, vertex4, vertex3}, mirrorU ? l : k, mirrorV ? r : q, mirrorU ? k : l, mirrorV ? q : r, textureWidth, textureHeight, false, Direction.NORTH));
            }
            catch (Exception e) {
                if (printing) {
                    EMFUtils.log("uv-nrth failed for " + selfModelData.id);
                }
                throw new Exception("uv-nrth failed for " + selfModelData.id);
            }
            try {
                ModelPart.Vertex[] vertexArray;
                if (mirrorU) {
                    ModelPart.Vertex[] vertexArray8 = new ModelPart.Vertex[4];
                    vertexArray8[0] = vertex;
                    vertexArray8[1] = vertex5;
                    vertexArray8[2] = vertex8;
                    vertexArray = vertexArray8;
                    vertexArray8[3] = vertex4;
                } else {
                    ModelPart.Vertex[] vertexArray9 = new ModelPart.Vertex[4];
                    vertexArray9[0] = vertex6;
                    vertexArray9[1] = vertex2;
                    vertexArray9[2] = vertex3;
                    vertexArray = vertexArray9;
                    vertexArray9[3] = vertex7;
                }
                sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? n : l, mirrorV ? r : q, mirrorU ? l : n, mirrorV ? q : r, textureWidth, textureHeight, false, mirrorU ? Direction.WEST : Direction.EAST));
            }
            catch (Exception e) {
                if (printing) {
                    EMFUtils.log("uv-east failed for " + selfModelData.id);
                }
                throw new Exception("uv-east failed for " + selfModelData.id);
            }
            try {
                sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex5, vertex6, vertex7, vertex8}, mirrorU ? o : n, mirrorV ? r : q, mirrorU ? n : o, mirrorV ? q : r, textureWidth, textureHeight, false, Direction.SOUTH));
            }
            catch (Exception e) {
                if (printing) {
                    EMFUtils.log("uv-sth failed for " + selfModelData.id);
                }
                throw new Exception("uv-sth failed for " + selfModelData.id);
            }
            accessor.setPolygons(sides.toArray(new ModelPart.Polygon[0]));
        }

        EMFCube(EMFPartData selfModelData, float[] uvDown, float[] uvUp, float[] uvNorth, float[] uvSouth, float[] uvWest, float[] uvEast, float cubeX, float cubeY, float cubeZ, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, float textureWidth, float textureHeight, boolean mirrorU, boolean mirrorV) {
            ArrayList<ModelPart.Polygon> sides;
            CuboidAccessor accessor;
            block25: {
                boolean printing;
                ModelPart.Vertex vertex8;
                ModelPart.Vertex vertex7;
                ModelPart.Vertex vertex6;
                ModelPart.Vertex vertex5;
                block24: {
                    ModelPart.Vertex vertex4;
                    ModelPart.Vertex vertex3;
                    ModelPart.Vertex vertex2;
                    ModelPart.Vertex vertex;
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    super(0, 0, cubeX, cubeY, cubeZ, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, false, textureWidth, textureHeight, (Set)new HashSet<Direction>(){
                                        {
                                            this.addAll(List.of(Direction.values()));
                                        }
                                    });
                                    accessor = (CuboidAccessor)((Object)this);
                                    accessor.setMinX(cubeX);
                                    accessor.setMinY(cubeY);
                                    accessor.setMinZ(cubeZ);
                                    accessor.setMaxX(cubeX + sizeX);
                                    accessor.setMaxY(cubeY + sizeY);
                                    accessor.setMaxZ(cubeZ + sizeZ);
                                    float cubeX2 = cubeX + sizeX;
                                    float cubeY2 = cubeY + sizeY;
                                    float cubeZ2 = cubeZ + sizeZ;
                                    vertex = new ModelPart.Vertex(cubeX -= extraX, cubeY -= extraY, cubeZ -= extraZ, 0.0f, 0.0f);
                                    vertex2 = new ModelPart.Vertex(cubeX2 += extraX, cubeY, cubeZ, 0.0f, 8.0f);
                                    vertex3 = new ModelPart.Vertex(cubeX2, cubeY2 += extraY, cubeZ, 8.0f, 8.0f);
                                    vertex4 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ, 8.0f, 0.0f);
                                    vertex5 = new ModelPart.Vertex(cubeX, cubeY, cubeZ2 += extraZ, 0.0f, 0.0f);
                                    vertex6 = new ModelPart.Vertex(cubeX2, cubeY, cubeZ2, 0.0f, 8.0f);
                                    vertex7 = new ModelPart.Vertex(cubeX2, cubeY2, cubeZ2, 8.0f, 8.0f);
                                    vertex8 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ2, 8.0f, 0.0f);
                                    sides = new ArrayList<ModelPart.Polygon>();
                                    printing = ((EMFConfig)EMF.config().getConfig()).logModelCreationData;
                                    try {
                                        ModelPart.Vertex[] vertexArray;
                                        if (mirrorV) {
                                            ModelPart.Vertex[] vertexArray2 = new ModelPart.Vertex[4];
                                            vertexArray2[0] = vertex8;
                                            vertexArray2[1] = vertex7;
                                            vertexArray2[2] = vertex3;
                                            vertexArray = vertexArray2;
                                            vertexArray2[3] = vertex4;
                                        } else {
                                            ModelPart.Vertex[] vertexArray3 = new ModelPart.Vertex[4];
                                            vertexArray3[0] = vertex;
                                            vertexArray3[1] = vertex2;
                                            vertexArray3[2] = vertex6;
                                            vertexArray = vertexArray3;
                                            vertexArray3[3] = vertex5;
                                        }
                                        sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvUp[2] : uvUp[0], mirrorV ? uvUp[3] : uvUp[1], mirrorU ? uvUp[0] : uvUp[2], mirrorV ? uvUp[1] : uvUp[3], textureWidth, textureHeight, false, mirrorV ? Direction.UP : Direction.DOWN));
                                    }
                                    catch (Exception e) {
                                        if (!printing) break block20;
                                        EMFUtils.log("uv-up failed for " + selfModelData.id);
                                    }
                                }
                                try {
                                    ModelPart.Vertex[] vertexArray;
                                    if (mirrorV) {
                                        ModelPart.Vertex[] vertexArray4 = new ModelPart.Vertex[4];
                                        vertexArray4[0] = vertex;
                                        vertexArray4[1] = vertex2;
                                        vertexArray4[2] = vertex6;
                                        vertexArray = vertexArray4;
                                        vertexArray4[3] = vertex5;
                                    } else {
                                        ModelPart.Vertex[] vertexArray5 = new ModelPart.Vertex[4];
                                        vertexArray5[0] = vertex8;
                                        vertexArray5[1] = vertex7;
                                        vertexArray5[2] = vertex3;
                                        vertexArray = vertexArray5;
                                        vertexArray5[3] = vertex4;
                                    }
                                    sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvDown[2] : uvDown[0], mirrorV ? uvDown[3] : uvDown[1], mirrorU ? uvDown[0] : uvDown[2], mirrorV ? uvDown[1] : uvDown[3], textureWidth, textureHeight, false, mirrorV ? Direction.DOWN : Direction.UP));
                                }
                                catch (Exception e) {
                                    if (!printing) break block21;
                                    EMFUtils.log("uv-down failed for " + selfModelData.id);
                                }
                            }
                            try {
                                ModelPart.Vertex[] vertexArray;
                                if (mirrorU) {
                                    ModelPart.Vertex[] vertexArray6 = new ModelPart.Vertex[4];
                                    vertexArray6[0] = vertex;
                                    vertexArray6[1] = vertex5;
                                    vertexArray6[2] = vertex8;
                                    vertexArray = vertexArray6;
                                    vertexArray6[3] = vertex4;
                                } else {
                                    ModelPart.Vertex[] vertexArray7 = new ModelPart.Vertex[4];
                                    vertexArray7[0] = vertex6;
                                    vertexArray7[1] = vertex2;
                                    vertexArray7[2] = vertex3;
                                    vertexArray = vertexArray7;
                                    vertexArray7[3] = vertex7;
                                }
                                sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvWest[2] : uvWest[0], mirrorV ? uvWest[3] : uvWest[1], mirrorU ? uvWest[0] : uvWest[2], mirrorV ? uvWest[1] : uvWest[3], textureWidth, textureHeight, false, mirrorU ? Direction.WEST : Direction.EAST));
                            }
                            catch (Exception e) {
                                if (!printing) break block22;
                                EMFUtils.log("uv-west failed for " + selfModelData.id);
                            }
                        }
                        try {
                            sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex2, vertex, vertex4, vertex3}, mirrorU ? uvNorth[2] : uvNorth[0], mirrorV ? uvNorth[3] : uvNorth[1], mirrorU ? uvNorth[0] : uvNorth[2], mirrorV ? uvNorth[1] : uvNorth[3], textureWidth, textureHeight, false, Direction.NORTH));
                        }
                        catch (Exception e) {
                            if (!printing) break block23;
                            EMFUtils.log("uv-north failed for " + selfModelData.id);
                        }
                    }
                    try {
                        ModelPart.Vertex[] vertexArray;
                        if (mirrorU) {
                            ModelPart.Vertex[] vertexArray8 = new ModelPart.Vertex[4];
                            vertexArray8[0] = vertex6;
                            vertexArray8[1] = vertex2;
                            vertexArray8[2] = vertex3;
                            vertexArray = vertexArray8;
                            vertexArray8[3] = vertex7;
                        } else {
                            ModelPart.Vertex[] vertexArray9 = new ModelPart.Vertex[4];
                            vertexArray9[0] = vertex;
                            vertexArray9[1] = vertex5;
                            vertexArray9[2] = vertex8;
                            vertexArray = vertexArray9;
                            vertexArray9[3] = vertex4;
                        }
                        sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvEast[2] : uvEast[0], mirrorV ? uvEast[3] : uvEast[1], mirrorU ? uvEast[0] : uvEast[2], mirrorV ? uvEast[1] : uvEast[3], textureWidth, textureHeight, false, mirrorU ? Direction.EAST : Direction.WEST));
                    }
                    catch (Exception e) {
                        if (!printing) break block24;
                        EMFUtils.log("uv-east failed for " + selfModelData.id);
                    }
                }
                try {
                    sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex5, vertex6, vertex7, vertex8}, mirrorU ? uvSouth[2] : uvSouth[0], mirrorV ? uvSouth[3] : uvSouth[1], mirrorU ? uvSouth[0] : uvSouth[2], mirrorV ? uvSouth[1] : uvSouth[3], textureWidth, textureHeight, false, Direction.SOUTH));
                }
                catch (Exception e) {
                    if (!printing) break block25;
                    EMFUtils.log("uv-south failed for " + selfModelData.id);
                }
            }
            accessor.setPolygons(sides.toArray(new ModelPart.Polygon[0]));
        }

        public void compile(PoseStack.Pose pose, VertexConsumer vertexConsumer, int i, int j, int k) {
            Matrix4f matrix4f = pose.pose();
            Vector3f vector3f = new Vector3f();
            for (ModelPart.Polygon polygon : this.polygons) {
                ModelPart.Vertex[] var16;
                Vector3f vector3f2 = pose.transformNormal(polygon.normal(), vector3f);
                float f = vector3f2.x();
                float g = vector3f2.y();
                float h = vector3f2.z();
                for (ModelPart.Vertex vertex : var16 = polygon.vertices()) {
                    float l = vertex.pos().x() / 16.0f;
                    float m = vertex.pos().y() / 16.0f;
                    float n = vertex.pos().z() / 16.0f;
                    Vector3f vector3f3 = matrix4f.transformPosition(l, m, n, vector3f);
                    vertexConsumer.addVertex(vector3f3.x(), vector3f3.y(), vector3f3.z(), k, vertex.u(), vertex.v(), j, i, f, g, h);
                }
            }
        }
    }
}

