/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.mixin.mixins.rendering.feature;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WolfCollarLayer;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.mixin.mixins.accessor.AgeableMobRendererAccessor;
import traben.entity_model_features.models.IEMFModel;
import traben.entity_model_features.models.parts.EMFModelPart;
import traben.entity_model_features.models.parts.EMFModelPartRoot;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.IEMFWolfCollarHolder;

@Mixin(value={WolfCollarLayer.class})
public abstract class MixinWolfCollarFeatureRenderer
extends RenderLayer<WolfRenderState, WolfModel> {
    @Unique
    private static final ModelLayerLocation emf$collar_layer = new ModelLayerLocation(EMFUtils.res("minecraft", "wolf"), "collar");
    @Unique
    private static final ModelLayerLocation emf$collar_layer_baby = new ModelLayerLocation(EMFUtils.res("minecraft", "wolf_baby"), "collar");

    public MixinWolfCollarFeatureRenderer() {
        super(null);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/RenderLayerParent;)V"}, at={@At(value="TAIL")})
    private void setEmf$Model(RenderLayerParent<?, ?> featureRendererContext, CallbackInfo ci) {
        ModelPart collarModelBaby;
        if (EMF.testForForgeLoadingError()) {
            return;
        }
        ModelPart collarModel = EMFManager.getInstance().injectIntoModelRootGetter(emf$collar_layer, WolfModel.createMeshDefinition((CubeDeformation)CubeDeformation.NONE).getRoot().bake(64, 32));
        if (collarModel instanceof EMFModelPartRoot || ((IEMFModel)featureRendererContext.getModel()).emf$isEMFModel()) {
            try {
                EntityModel entityModel = featureRendererContext.getModel();
                if (entityModel instanceof IEMFWolfCollarHolder) {
                    IEMFWolfCollarHolder holder = (IEMFWolfCollarHolder)entityModel;
                    holder.emf$setCollarModel(new WolfModel(collarModel));
                }
            }
            catch (Exception holder) {
                // empty catch block
            }
        }
        if ((collarModelBaby = EMFManager.getInstance().injectIntoModelRootGetter(emf$collar_layer_baby, LayerDefinition.create((MeshDefinition)WolfModel.createMeshDefinition((CubeDeformation)CubeDeformation.NONE), (int)64, (int)32).apply(WolfModel.BABY_TRANSFORMER).bakeRoot())) instanceof EMFModelPartRoot || EMFManager.getInstance().injectIntoModelRootGetter(new ModelLayerLocation(EMFUtils.res("minecraft", "wolf_baby"), "main"), LayerDefinition.create((MeshDefinition)WolfModel.createMeshDefinition((CubeDeformation)CubeDeformation.NONE), (int)64, (int)32).bakeRoot()) instanceof EMFModelPart) {
            try {
                AgeableMobRendererAccessor ageModelsAccessor;
                Object m;
                if (featureRendererContext instanceof AgeableMobRendererAccessor && (m = (ageModelsAccessor = (AgeableMobRendererAccessor)featureRendererContext).getBabyModel()) instanceof IEMFWolfCollarHolder) {
                    IEMFWolfCollarHolder holder = (IEMFWolfCollarHolder)m;
                    holder.emf$setCollarModel(new WolfModel(collarModelBaby));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @NotNull
    public WolfModel getParentModel() {
        IEMFWolfCollarHolder holder;
        WolfModel base = (WolfModel)super.getParentModel();
        if (base instanceof IEMFWolfCollarHolder && (holder = (IEMFWolfCollarHolder)base).emf$hasCollarModel()) {
            WolfModel model = holder.emf$getCollarModel();
            return model;
        }
        return base;
    }
}

