/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.mixins.accessor.MinecraftClientAccessor;
import traben.entity_model_features.mod_compat.IrisShadowPassDetection;
import traben.entity_model_features.models.EMFModelMappings;
import traben.entity_model_features.models.EMFModel_ID;
import traben.entity_model_features.models.animation.EMFAttachments;
import traben.entity_model_features.models.animation.state.EMFEntityRenderState;
import traben.entity_model_features.models.parts.EMFModelPartRoot;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.ETFConfig;

@Deprecated
public final class EMFAnimationEntityContext {
    private static final Object2IntOpenHashMap<UUID> knownHighestAngerTimeByUUID = new Object2IntOpenHashMap<UUID>(){
        {
            this.defaultReturnValue(0);
        }
    };
    private static final Object2IntOpenHashMap<UUID> lodEntityTimers = new Object2IntOpenHashMap();
    public static boolean setInHand = false;
    public static boolean isFirstPersonHand = false;
    public static boolean setInItemFrame = false;
    public static boolean setIsOnHead = false;
    public static boolean setIsInGui = false;
    public static double lastFOV = 70.0;
    public static boolean is_in_ground_override = false;
    public static ObjectSet<UUID> entitiesToForceVanillaModel = new ObjectOpenHashSet();
    private static float shadowSize = Float.NaN;
    private static float shadowOpacity = Float.NaN;
    private static float leashX = Float.NaN;
    private static float leashY = Float.NaN;
    private static float leashZ = Float.NaN;
    private static float shadowX = Float.NaN;
    private static float shadowZ = Float.NaN;
    private static float limbAngle = Float.NaN;
    private static float limbDistance = Float.NaN;
    private static float headYaw = Float.NaN;
    private static float headPitch = Float.NaN;
    private static boolean onShoulder = false;
    private static Function<ResourceLocation, RenderType> layerFactory = null;
    private static Boolean lodFrameSkipping = null;
    private static boolean announceModels = false;
    private static float frameCounter = 0.0f;
    public static Object2ObjectOpenHashMap<UUID, ModelPart[]> entitiesPausedParts = new Object2ObjectOpenHashMap();
    public static ObjectSet<UUID> entitiesPaused = new ObjectOpenHashSet();
    private static EMFEntityRenderState emfState = null;

    public static boolean isEntityAnimPaused() {
        if (emfState == null) {
            return false;
        }
        return entitiesPaused.contains((Object)emfState.uuid());
    }

    @Nullable
    public static ModelPart[] getEntityPartsAnimPaused() {
        if (emfState == null) {
            return null;
        }
        ModelPart[] parts = (ModelPart[])entitiesPausedParts.get((Object)emfState.uuid());
        return parts == null || parts.length == 0 ? null : parts;
    }

    private EMFAnimationEntityContext() {
    }

    public static void incFrameCount() {
        if (IrisShadowPassDetection.getInstance().inShadowPass()) {
            return;
        }
        float inc = frameCounter + 1.0f;
        frameCounter = inc > 27719.0f ? 0.0f : inc;
    }

    public static float getFrameCounter() {
        return frameCounter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isJumping() {
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (!(eMFEntity instanceof LivingEntity)) return false;
        LivingEntity alive = (LivingEntity)eMFEntity;
        if (!alive.jumping) return false;
        return true;
    }

    public static void setEntityVariable(String variable, float value) {
        if (emfState != null) {
            emfState.variableMap().put((Object)variable, value);
        }
    }

    public static float getEntityVariable(String variable, float defaultValue) {
        if (emfState == null) {
            return defaultValue;
        }
        return emfState.variableMap().getOrDefault((Object)variable, defaultValue);
    }

    public static void setLayerFactory(Function<ResourceLocation, RenderType> layerFactory) {
        if (EMFAnimationEntityContext.emfEntity() instanceof Arrow) {
            return;
        }
        EMFEntityRenderState state = EMFAnimationEntityContext.getEmfState();
        if (state != null && state.layerFactory() == null) {
            state.setLayerFactory(layerFactory);
        }
        EMFAnimationEntityContext.layerFactory = layerFactory;
    }

    private static int distanceOfEntityFrom(BlockPos pos) {
        if (emfState == null) {
            return 0;
        }
        BlockPos blockPos = emfState.blockPos();
        float f = blockPos.getX() - pos.getX();
        float g = blockPos.getY() - pos.getY();
        float h = blockPos.getZ() - pos.getZ();
        return (int)Mth.sqrt((float)(f * f + g * g + h * h));
    }

    private static int getLODFactorOfEntity() {
        Entity entity;
        float entitySize;
        EMFEntity eMFEntity;
        int lodFactor;
        if (((EMFConfig)EMF.config().getConfig()).animationLODDistance == 0) {
            return 0;
        }
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().player.isScoping()) {
            return 0;
        }
        int distance = EMFAnimationEntityContext.distanceOfEntityFrom(Minecraft.getInstance().player.blockPosition());
        if (distance < 1) {
            return 0;
        }
        int factor = distance / ((EMFConfig)EMF.config().getConfig()).animationLODDistance;
        int factorByFOV = (int)((double)factor * lastFOV / 70.0);
        if (((EMFConfig)EMF.config().getConfig()).retainDetailOnLowFps && Minecraft.getInstance().getFps() < 59) {
            float fpsPercentageOf60 = (float)Minecraft.getInstance().getFps() / 60.0f;
            lodFactor = (int)((float)factorByFOV * fpsPercentageOf60);
        } else {
            lodFactor = factorByFOV;
        }
        if (((EMFConfig)EMF.config().getConfig()).retainDetailOnLargerMobs && (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof Entity && (entitySize = Math.max((entity = (Entity)eMFEntity).getBbWidth(), entity.getBbHeight())) > 2.0f) {
            lodFactor = (int)((float)lodFactor / (entitySize / 2.0f));
        }
        return lodFactor;
    }

    public static boolean isLODSkippingThisFrame() {
        Player player;
        EMFEntity eMFEntity;
        if (lodFrameSkipping != null) {
            return lodFrameSkipping;
        }
        if (ETF.IRIS_DETECTED && IrisShadowPassDetection.getInstance().inShadowPass() && ((EMFConfig)EMF.config().getConfig()).animationFrameSkipDuringIrisShadowPass && (!((eMFEntity = EMFAnimationEntityContext.getEMFEntity()) instanceof Player) || !(player = (Player)eMFEntity).isLocalPlayer() || !Minecraft.getInstance().options.getCameraType().isFirstPerson())) {
            return true;
        }
        if (((EMFConfig)EMF.config().getConfig()).animationLODDistance == 0 || emfState == null) {
            return false;
        }
        int lodTimer = lodEntityTimers.getInt((Object)emfState.uuid());
        int lodResult = lodTimer < 1 ? EMFAnimationEntityContext.getLODFactorOfEntity() : lodTimer - 1;
        lodEntityTimers.put((Object)emfState.uuid(), lodResult);
        lodFrameSkipping = lodResult > 0;
        return lodFrameSkipping;
    }

    public static EMFEntityRenderState getEmfState() {
        return emfState;
    }

    @Deprecated
    private static EMFEntity emfEntity() {
        return emfState == null ? null : emfState.emfEntity();
    }

    public static EntityRenderState getEntityRenderState() {
        return emfState == null ? null : emfState.vanillaState();
    }

    public static void setCurrentEntityIteration(@Nullable EMFEntityRenderState state) {
        EMFAttachments.closeBoth();
        isFirstPersonHand = false;
        ++EMFManager.getInstance().entityRenderCount;
        layerFactory = null;
        shadowSize = Float.NaN;
        shadowOpacity = Float.NaN;
        leashX = 0.0f;
        leashY = 0.0f;
        leashZ = 0.0f;
        shadowX = 0.0f;
        shadowZ = 0.0f;
        EMFAnimationEntityContext.newEntity(state);
        if (state != null) {
            Set roots = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForVariation.get((Object)state.typeString());
            if (roots != null) {
                if (EMFAnimationEntityContext.isEntityForcedToVanillaModel()) {
                    roots.forEach(root -> root.setVariantStateTo(0));
                } else {
                    roots.forEach(EMFModelPartRoot::doVariantCheck);
                }
                EMFEntity eMFEntity = state.emfEntity();
                if (eMFEntity instanceof Player) {
                    Player player = (Player)eMFEntity;
                    if (((EMFConfig)EMF.config().getConfig()).resetPlayerModelEachRender_v2) {
                        roots.forEach(EMFModelPartRoot::resetVanillaPartsToDefaults);
                    }
                }
            }
            if (((EMFConfig)EMF.config().getConfig()).debugOnRightClick && state.uuid().equals(EMFManager.getInstance().entityForDebugPrint)) {
                announceModels = true;
                EMFManager.getInstance().entityForDebugPrint = null;
            }
        }
        lodFrameSkipping = null;
    }

    public static void anounceModels(EMFEntityRenderState assertEntity) {
        StringBuilder model;
        int count;
        String type = assertEntity.typeString();
        Set debugRoots = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForDebug.get((Object)type);
        EMFUtils.chat("\u00a7e-----------EMF Debug Printout-------------\u00a7r");
        if (debugRoots == null) {
            EMFUtils.chat("\n\u00a7c\u00a7oThe EMF debug printout did not find any custom models registered to the following entity:\n \u00a73\u00a7l\u00a7u" + type);
        } else {
            String message = "\n\u00a72\u00a7oThe EMF debug printout found the following custom models for the entity:\n \u00a73\u00a7l\u00a7u" + type + "\u00a7r\n\u00a72\u00a7oThis first model is usually the primary model for the entity.";
            EMFUtils.chat(message);
            count = 1;
            for (EMFModelPartRoot debugRoot : debugRoots) {
                model = new StringBuilder();
                model.append("\u00a7eModel #").append(count).append("\u00a7r").append(EMFAnimationEntityContext.entryAndValue("name", debugRoot.modelName.getfileName() + ".jem"));
                if (debugRoot.modelName.hasFallbackModels()) {
                    model.append("\n\u00a7eFallback Models:\u00a7r");
                    debugRoot.modelName.forEachFallback(modelId -> model.append("\n\u00a76 - \u00a7r").append(modelId.getfileName()));
                }
                if (debugRoot.directoryContext != null) {
                    model.append(EMFAnimationEntityContext.entryAndValue("directory", debugRoot.directoryContext.getRelativeDirectoryLocationNoValidation(debugRoot.modelName.getfileName())));
                }
                if (debugRoot.textureOverride != null) {
                    model.append(EMFAnimationEntityContext.entryAndValue("texture_override", debugRoot.textureOverride.toString()));
                }
                if (debugRoot.variantTester != null) {
                    IntArraySet set = new IntArraySet(debugRoot.allKnownStateVariants.keySet());
                    set.remove(0);
                    model.append(EMFAnimationEntityContext.entryAndValue("model_variants", set.toString())).append(EMFAnimationEntityContext.entryAndValue("current_variant", String.valueOf(debugRoot.currentModelVariant)));
                }
                EMFUtils.chat(String.valueOf(model) + "\n\u00a76 - parts:\u00a7r printed in game log only.");
                EMFUtils.log("\n - parts: " + debugRoot.simplePrintChildren(0));
                ++count;
            }
        }
        EMFUtils.chat("\n\u00a7e----------------------------------------\u00a7r");
        if (!EMFManager.getInstance().modelsAnnounced.isEmpty()) {
            String vanillaMessage = "\n\u00a72\u00a7oThe EMF debug printout found the following non-custom models for the entity:\n \u00a73\u00a7l\u00a7u" + type + "\u00a7r\n\u00a72\u00a7oThis first model is usually the primary model for the entity.";
            EMFUtils.chat(vanillaMessage);
            count = 1;
            for (EMFModel_ID data : EMFManager.getInstance().modelsAnnounced) {
                Map<String, String> map;
                model = new StringBuilder();
                model.append("\n\u00a7eNon-Custom Model #").append(count).append("\u00a7r").append(EMFAnimationEntityContext.entryAndValue("possible .jem name", data.getDisplayFileName()));
                if (data.hasFallbackModels()) {
                    model.append("\u00a7eFallback Models:\u00a7r");
                    data.forEachFallback(modelId -> model.append("\n\u00a76 - \u00a7r").append(modelId.getfileName()));
                }
                if (!(map = EMFModelMappings.getMapOf(data, null)).isEmpty()) {
                    EMFUtils.chat(String.valueOf(model) + "\n\u00a76 - part names:\u00a7r printed in game log only.");
                    StringBuilder parts = new StringBuilder();
                    parts.append("\n - part names: ");
                    map.forEach((k, v) -> parts.append("\n   | - [").append((String)k).append(']'));
                    EMFUtils.log(parts.toString());
                    continue;
                }
                EMFUtils.chat(model.toString());
                EMFUtils.log(" - part names: could not be found. use the 'printout unknown models' setting instead.");
            }
            EMFUtils.chat("\n\u00a7e----------------------------------------\u00a7r");
            EMFManager.getInstance().modelsAnnounced.clear();
        }
        announceModels = false;
    }

    public static boolean doAnnounceModels() {
        return announceModels;
    }

    private static String entryAndValue(String entry, String value) {
        return "\n\u00a76 - " + entry + ":\u00a7r " + value;
    }

    private static void newEntity(@Nullable EMFEntityRenderState state) {
        emfState = state;
        EntityRenderState entityRenderState = EMFAnimationEntityContext.getEntityRenderState();
        if (entityRenderState instanceof LivingEntityRenderState) {
            LivingEntityRenderState livingEntityRenderState = (LivingEntityRenderState)entityRenderState;
            limbAngle = livingEntityRenderState.walkAnimationPos;
            limbDistance = livingEntityRenderState.walkAnimationSpeed;
            headYaw = livingEntityRenderState.yRot;
            if (headYaw >= 180.0f || headYaw < -180.0f) {
                headYaw = Mth.wrapDegrees((float)headYaw);
            }
            headPitch = livingEntityRenderState.xRot;
        } else {
            limbAngle = Float.NaN;
            limbDistance = Float.NaN;
            headYaw = Float.NaN;
            headPitch = Float.NaN;
        }
        if (state != null) {
            if (state.entity() instanceof Arrow) {
                layerFactory = RenderType::entityCutout;
            } else if (state.isBlockEntity()) {
                layerFactory = RenderType::entitySolid;
            }
            if (state.layerFactory() == null) {
                state.setLayerFactory(layerFactory);
            }
        }
        onShoulder = false;
    }

    public static void globalReset() {
        EMFAnimationEntityContext.reset();
        frameCounter = 0.0f;
    }

    public static void reset() {
        isFirstPersonHand = false;
        layerFactory = null;
        emfState = null;
        limbAngle = Float.NaN;
        limbDistance = Float.NaN;
        headYaw = Float.NaN;
        headPitch = Float.NaN;
        onShoulder = false;
        shadowSize = Float.NaN;
        shadowOpacity = Float.NaN;
        leashX = 0.0f;
        leashY = 0.0f;
        leashZ = 0.0f;
        shadowX = 0.0f;
        shadowZ = 0.0f;
        lodFrameSkipping = null;
    }

    public static RenderType getLayerFromRecentFactoryOrETFOverrideOrTranslucent(ResourceLocation identifier) {
        if (layerFactory == null) {
            ETFConfig.RenderLayerOverride layer = ((ETFConfig)ETF.config().getConfig()).getRenderLayerOverride();
            if (layer == null) {
                return RenderType.entityTranslucent((ResourceLocation)identifier);
            }
            return switch (layer) {
                default -> throw new MatchException(null, null);
                case ETFConfig.RenderLayerOverride.TRANSLUCENT -> RenderType.entityTranslucent((ResourceLocation)identifier);
                case ETFConfig.RenderLayerOverride.TRANSLUCENT_CULL -> RenderType.entityTranslucent((ResourceLocation)identifier);
                case ETFConfig.RenderLayerOverride.END -> RenderType.endGateway();
                case ETFConfig.RenderLayerOverride.OUTLINE -> RenderType.outline((ResourceLocation)identifier);
            };
        }
        return layerFactory.apply(identifier);
    }

    public static float getRuleIndex() {
        if (emfState == null) {
            return 0.0f;
        }
        return EMFManager.getInstance().lastModelRuleOfEntity.getInt((Object)emfState.uuid());
    }

    public static boolean isEntityForcedToVanillaModel() {
        Player player;
        EMFEntity eMFEntity;
        if (emfState == null) {
            return false;
        }
        if (entitiesToForceVanillaModel.contains((Object)emfState.uuid())) {
            return true;
        }
        return ((EMFConfig)EMF.config().getConfig()).onlyClientPlayerModel && (eMFEntity = EMFAnimationEntityContext.getEMFEntity()) instanceof Player && !(player = (Player)eMFEntity).isLocalPlayer();
    }

    @Deprecated
    @Nullable
    public static EMFEntity getEMFEntity() {
        return EMFAnimationEntityContext.emfEntity();
    }

    public static float getDimension() {
        if (emfState == null || emfState.world() == null) {
            return 0.0f;
        }
        Optional optional = emfState.world().dimensionTypeRegistration().unwrapKey();
        if (optional.isEmpty()) {
            return 0.0f;
        }
        ResourceLocation id = ((ResourceKey)optional.get()).location();
        if (id.equals((Object)BuiltinDimensionTypes.NETHER_EFFECTS)) {
            return -1.0f;
        }
        if (id.equals((Object)BuiltinDimensionTypes.END_EFFECTS)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static float getPlayerX() {
        return Minecraft.getInstance().player == null ? 0.0f : (float)Mth.lerp((double)EMFAnimationEntityContext.getTickDelta(), (double)Minecraft.getInstance().player.xo, (double)Minecraft.getInstance().player.getX());
    }

    public static float getPlayerY() {
        return Minecraft.getInstance().player == null ? 0.0f : (float)Mth.lerp((double)EMFAnimationEntityContext.getTickDelta(), (double)Minecraft.getInstance().player.yo, (double)Minecraft.getInstance().player.getY());
    }

    public static float getPlayerZ() {
        return Minecraft.getInstance().player == null ? 0.0f : (float)Mth.lerp((double)EMFAnimationEntityContext.getTickDelta(), (double)Minecraft.getInstance().player.zo, (double)Minecraft.getInstance().player.getZ());
    }

    public static float getPlayerRX() {
        return Minecraft.getInstance().player == null ? 0.0f : (float)Math.toRadians(Mth.rotLerp((float)EMFAnimationEntityContext.getTickDelta(), (float)Minecraft.getInstance().player.xRotO, (float)Minecraft.getInstance().player.getXRot()));
    }

    public static float getPlayerRY() {
        return Minecraft.getInstance().player == null ? 0.0f : (float)Math.toRadians(Mth.rotLerp((float)EMFAnimationEntityContext.getTickDelta(), (float)Minecraft.getInstance().player.yRotO, (float)Minecraft.getInstance().player.getYRot()));
    }

    public static float getEntityX() {
        return emfState == null ? 0.0f : (float)Mth.lerp((double)EMFAnimationEntityContext.getTickDelta(), (double)emfState.prevX(), (double)emfState.x());
    }

    public static float getEntityY() {
        return emfState == null ? 0.0f : (float)Mth.lerp((double)EMFAnimationEntityContext.getTickDelta(), (double)emfState.prevY(), (double)emfState.y());
    }

    public static float getEntityZ() {
        return emfState == null ? 0.0f : (float)Mth.lerp((double)EMFAnimationEntityContext.getTickDelta(), (double)emfState.prevZ(), (double)emfState.z());
    }

    public static float getEntityRX() {
        return emfState == null ? 0.0f : (float)Math.toRadians(Mth.rotLerp((float)EMFAnimationEntityContext.getTickDelta(), (float)emfState.prevPitch(), (float)emfState.pitch()));
    }

    public static float getEntityRY() {
        float f;
        if (emfState == null) {
            return 0.0f;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = (float)Math.toRadians(Mth.rotLerp((float)EMFAnimationEntityContext.getTickDelta(), (float)alive.yBodyRotO, (float)alive.yBodyRot));
        } else {
            eMFEntity = EMFAnimationEntityContext.emfEntity();
            if (eMFEntity instanceof Entity) {
                Entity entity = (Entity)eMFEntity;
                f = (float)Math.toRadians(Mth.rotLerp((float)EMFAnimationEntityContext.getTickDelta(), (float)entity.yRotO, (float)entity.yRot));
            } else {
                f = 0.0f;
            }
        }
        return f;
    }

    public static float getTime() {
        if (emfState == null || emfState.world() == null) {
            return 0.0f + EMFAnimationEntityContext.getTickDelta();
        }
        long upTimeInTicks = emfState.world().getGameTime();
        return EMFAnimationEntityContext.constrainedFloat(upTimeInTicks, 27720) + EMFAnimationEntityContext.getTickDelta();
    }

    public static float getDayTime() {
        if (emfState == null || emfState.world() == null) {
            return 0.0f + EMFAnimationEntityContext.getTickDelta();
        }
        return EMFAnimationEntityContext.constrainedFloat(emfState.world().getDayTime(), 31415) + EMFAnimationEntityContext.getTickDelta();
    }

    public static float getDayCount() {
        if (emfState == null || emfState.world() == null) {
            return 0.0f + EMFAnimationEntityContext.getTickDelta();
        }
        return emfState.world().getDayTime() / 27720L;
    }

    public static float getHealth() {
        float f;
        if (emfState == null) {
            return 0.0f;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = alive.getHealth();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public static float getDeathTime() {
        float f;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = alive.deathTime > 0 ? (float)alive.deathTime + EMFAnimationEntityContext.getTickDelta() : 0.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static float getAngerTime() {
        if (!(EMFAnimationEntityContext.emfEntity() instanceof NeutralMob)) {
            return 0.0f;
        }
        float currentKnownHighest = knownHighestAngerTimeByUUID.getInt((Object)emfState.uuid());
        int angerTime = ((NeutralMob)EMFAnimationEntityContext.emfEntity()).getRemainingPersistentAngerTime();
        if (angerTime <= 0) {
            knownHighestAngerTimeByUUID.put((Object)emfState.uuid(), 0);
            return 0.0f;
        }
        if ((float)angerTime > currentKnownHighest) {
            knownHighestAngerTimeByUUID.put((Object)emfState.uuid(), angerTime);
        }
        return (float)angerTime - EMFAnimationEntityContext.getTickDelta();
    }

    public static float getAngerTimeStart() {
        return EMFAnimationEntityContext.emfEntity() instanceof NeutralMob ? (float)knownHighestAngerTimeByUUID.getInt((Object)emfState.uuid()) : 0.0f;
    }

    public static float getMaxHealth() {
        float f;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = alive.getMaxHealth();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public static float getId() {
        return emfState == null ? 0.0f : (float)(Math.abs(emfState.optifineId()) % 27720);
    }

    public static float getHurtTime() {
        float f;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = alive.hurtTime > 0 ? (float)alive.hurtTime - EMFAnimationEntityContext.getTickDelta() : 0.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static float getHeightAboveGround() {
        if (!(EMFAnimationEntityContext.emfEntity() instanceof Entity)) {
            return 0.0f;
        }
        float y = EMFAnimationEntityContext.getEntityY();
        BlockPos pos = emfState.blockPos();
        int worldBottom = emfState.world().getMinY();
        while (!emfState.world().getBlockState(pos).entityCanStandOn((BlockGetter)emfState.world(), pos, (Entity)EMFAnimationEntityContext.emfEntity()) && pos.getY() > worldBottom) {
            pos = pos.below();
        }
        return y - (float)pos.getY();
    }

    public static float getFluidDepthDown() {
        if (emfState == null || emfState.world().getFluidState(emfState.blockPos()).isEmpty()) {
            return 0.0f;
        }
        BlockPos pos = emfState.blockPos();
        int worldBottom = emfState.world().getMinY();
        while (!emfState.world().getFluidState(pos).isEmpty() && pos.getY() > worldBottom) {
            pos = pos.below();
        }
        return emfState.blockPos().getY() - pos.getY();
    }

    public static float getFluidDepthUp() {
        if (emfState == null || emfState.world().getFluidState(emfState.blockPos()).isEmpty()) {
            return 0.0f;
        }
        BlockPos pos = emfState.blockPos();
        int worldTop = emfState.world().getMaxY();
        while (!emfState.world().getFluidState(pos).isEmpty() && pos.getY() < worldTop) {
            pos = pos.above();
        }
        return pos.getY() - emfState.blockPos().getY();
    }

    public static float getFluidDepth() {
        if (emfState == null || emfState.world().getFluidState(emfState.blockPos()).isEmpty()) {
            return 0.0f;
        }
        return EMFAnimationEntityContext.getFluidDepthDown() + EMFAnimationEntityContext.getFluidDepthUp() - 1.0f;
    }

    public static boolean isInWater() {
        return emfState != null && emfState.isTouchingWater();
    }

    public static boolean isBurning() {
        return emfState != null && emfState.isOnFire();
    }

    public static boolean isRiding() {
        return emfState != null && emfState.hasVehicle();
    }

    public static boolean isChild() {
        LivingEntity alive;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        return eMFEntity instanceof LivingEntity && (alive = (LivingEntity)eMFEntity).isBaby();
    }

    public static boolean isOnGround() {
        return emfState != null && emfState.isOnGround();
    }

    public static boolean isClimbing() {
        LivingEntity alive;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        return eMFEntity instanceof LivingEntity && (alive = (LivingEntity)eMFEntity).onClimbable();
    }

    public static boolean isAlive() {
        if (emfState == null) {
            return false;
        }
        return emfState.isAlive();
    }

    public static boolean isUsingItem() {
        if (emfState == null) {
            return false;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)eMFEntity;
            return entity.isUsingItem();
        }
        return false;
    }

    public static boolean isSwingingArm(boolean right) {
        if (emfState == null) {
            return false;
        }
        if (EMFAnimationEntityContext.getSwingProgress() == 0.0f && !EMFAnimationEntityContext.isUsingItem()) {
            return false;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof LivingEntity) {
            boolean usingMainHand;
            LivingEntity entity = (LivingEntity)eMFEntity;
            boolean isRightHanded = entity.getMainArm() == HumanoidArm.RIGHT;
            boolean bl = usingMainHand = entity.getUsedItemHand() == InteractionHand.MAIN_HAND;
            if (right) {
                return isRightHanded == usingMainHand;
            }
            return isRightHanded != usingMainHand;
        }
        return false;
    }

    public static boolean isHoldingItem(boolean right) {
        if (emfState == null) {
            return false;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof LivingEntity) {
            boolean isRightHanded;
            LivingEntity entity = (LivingEntity)eMFEntity;
            boolean bl = isRightHanded = entity.getMainArm() == HumanoidArm.RIGHT;
            InteractionHand arm = right ? (isRightHanded ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND) : (isRightHanded ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
            return !entity.getItemInHand(arm).isEmpty();
        }
        return false;
    }

    public static boolean isAggressive() {
        Mob mob;
        Targeting targets;
        NeutralMob angry;
        if (emfState == null) {
            return false;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof EnderMan) {
            EnderMan enderman = (EnderMan)eMFEntity;
            return enderman.isCreepy();
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof Blaze) {
            Blaze blaze = (Blaze)eMFEntity;
            return blaze.isOnFire();
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof Guardian) {
            Guardian guardian = (Guardian)eMFEntity;
            return guardian.getActiveAttackTarget() != null;
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof Vindicator) {
            Vindicator vindicator = (Vindicator)eMFEntity;
            return vindicator.isAggressive();
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof SpellcasterIllager) {
            SpellcasterIllager caster = (SpellcasterIllager)eMFEntity;
            return caster.isCastingSpell();
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof Vex) {
            Vex vex = (Vex)eMFEntity;
            return vex.isCharging();
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof NeutralMob && (angry = (NeutralMob)eMFEntity).isAngry()) {
            return true;
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof Targeting && (targets = (Targeting)eMFEntity).getTarget() != null) {
            return true;
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        return eMFEntity instanceof Mob && (mob = (Mob)eMFEntity).isAggressive();
    }

    public static boolean isGlowing() {
        return emfState != null && emfState.isGlowing();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHurt() {
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (!(eMFEntity instanceof LivingEntity)) return false;
        LivingEntity alive = (LivingEntity)eMFEntity;
        if (alive.hurtTime <= 0) return false;
        return true;
    }

    public static boolean isInHand() {
        return setInHand;
    }

    public static boolean isInItemFrame() {
        return setInItemFrame;
    }

    public static boolean isInGround() {
        Projectile proj;
        EMFEntity eMFEntity;
        return is_in_ground_override || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof Projectile && (proj = (Projectile)eMFEntity).isInWall();
    }

    public static boolean isInGui() {
        return setIsInGui;
    }

    public static boolean isClientHovered() {
        if (emfState == null) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (emfState.isBlockEntity()) {
            HitResult block;
            Entity entity;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && (double)emfState.distanceTo((Entity)player) <= player.blockInteractionRange() + 1.0 && (entity = mc.getCameraEntity()) != null && (block = entity.pick(20.0, 0.0f, false)).getType() == HitResult.Type.BLOCK) {
                return ((BlockHitResult)block).getBlockPos().equals((Object)emfState.blockPos());
            }
            return false;
        }
        return mc.crosshairPickEntity != null && mc.crosshairPickEntity.equals((Object)EMFAnimationEntityContext.emfEntity());
    }

    public static boolean isInLava() {
        return emfState != null && emfState.isInLava();
    }

    public static boolean isInvisible() {
        return emfState != null && emfState.isInvisible();
    }

    public static boolean isOnHead() {
        return setIsOnHead;
    }

    public static boolean isOnShoulder() {
        return onShoulder;
    }

    public static void setCurrentEntityOnShoulder(boolean onShoulder) {
        EMFAnimationEntityContext.onShoulder = onShoulder;
    }

    public static boolean isRidden() {
        return emfState != null && emfState.hasPassengers();
    }

    public static boolean isSitting() {
        Camel camel;
        Wolf wolf;
        Cat cat;
        Parrot parrot;
        Fox fox;
        TamableAnimal tame;
        if (emfState == null) {
            return false;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        return eMFEntity instanceof TamableAnimal && (tame = (TamableAnimal)eMFEntity).isInSittingPose() || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof Fox && (fox = (Fox)eMFEntity).isSitting() || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof Parrot && (parrot = (Parrot)eMFEntity).isInSittingPose() || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof Cat && (cat = (Cat)eMFEntity).isInSittingPose() || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof Wolf && (wolf = (Wolf)eMFEntity).isInSittingPose() || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof Camel && (camel = (Camel)eMFEntity).isCamelSitting();
    }

    public static boolean isSneaking() {
        return emfState != null && emfState.isSneaking();
    }

    public static boolean isSprinting() {
        return emfState != null && emfState.isSprinting();
    }

    public static boolean isTamed() {
        TamableAnimal tame;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        return eMFEntity instanceof TamableAnimal && (tame = (TamableAnimal)eMFEntity).isTame();
    }

    public static boolean isWet() {
        return emfState != null && emfState.isWet();
    }

    public static float getSwingProgress() {
        float f;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = alive.getAttackAnim(EMFAnimationEntityContext.getTickDelta());
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static float getAge() {
        if (emfState == null) {
            return 0.0f + EMFAnimationEntityContext.getTickDelta();
        }
        return EMFAnimationEntityContext.constrainedFloat(emfState.age(), 27720) + EMFAnimationEntityContext.getTickDelta();
    }

    private static float constrainedFloat(float value, int constraint) {
        return value >= (float)constraint ? value % (float)constraint : value;
    }

    private static float constrainedFloat(float value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 27720);
    }

    private static float constrainedFloat(long value, int constraint) {
        return value >= (long)constraint ? value % (long)constraint : value;
    }

    private static float constrainedFloat(long value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 27720);
    }

    private static float constrainedFloat(int value, int constraint) {
        return value >= constraint ? value % constraint : value;
    }

    private static float constrainedFloat(int value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 27720);
    }

    public static float getFrameTime() {
        if (Minecraft.getInstance().isPaused()) {
            return 0.0f;
        }
        if (Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().isFrozen()) {
            return 0.0f;
        }
        return ((MinecraftClientAccessor)Minecraft.getInstance()).getDeltaTracker().getGameTimeDeltaTicks() / 20.0f;
    }

    public static float getLimbAngle() {
        if (emfState == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbAngle)) {
            EMFAnimationEntityContext.doLimbValues();
        }
        return limbAngle;
    }

    public static void setLimbAngle(float limbAngle) {
        EMFAnimationEntityContext.limbAngle = limbAngle;
    }

    public static float getLimbDistance() {
        if (emfState == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbDistance)) {
            EMFAnimationEntityContext.doLimbValues();
        }
        return limbDistance == Float.MIN_VALUE ? 0.0f : limbDistance;
    }

    public static void setLimbDistance(float limbDistance) {
        EMFAnimationEntityContext.limbDistance = limbDistance;
    }

    private static void doLimbValues() {
        EMFEntity eMFEntity;
        float o = 0.0f;
        float n = 0.0f;
        assert (emfState != null);
        if (!emfState.hasVehicle() && (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            o = alive.walkAnimation.position(EMFAnimationEntityContext.getTickDelta());
            n = alive.walkAnimation.speed(EMFAnimationEntityContext.getTickDelta());
            if (alive.isBaby()) {
                o *= 3.0f;
            }
            if (n > 1.0f) {
                n = 1.0f;
            }
        } else if (EMFAnimationEntityContext.emfEntity() instanceof AbstractMinecart) {
            n = 1.0f;
            o = -(EMFAnimationEntityContext.getEntityX() + EMFAnimationEntityContext.getEntityZ());
        } else {
            eMFEntity = EMFAnimationEntityContext.emfEntity();
            if (eMFEntity instanceof AbstractBoat) {
                AbstractBoat boat = (AbstractBoat)eMFEntity;
                n = 1.0f;
                o = Math.max(boat.getRowingTime(1, EMFAnimationEntityContext.getTickDelta()), boat.getRowingTime(0, EMFAnimationEntityContext.getTickDelta()));
            }
        }
        limbDistance = n;
        limbAngle = o;
    }

    public static float getHeadYaw() {
        if (emfState == null) {
            return 0.0f;
        }
        if (Float.isNaN(headYaw)) {
            EMFAnimationEntityContext.doHeadValues();
        }
        return headYaw;
    }

    public static void setHeadYaw(float headYaw) {
        EMFAnimationEntityContext.headYaw = headYaw;
    }

    public static float getHeadPitch() {
        if (emfState == null) {
            return 0.0f;
        }
        if (Float.isNaN(headPitch)) {
            EMFAnimationEntityContext.doHeadValues();
        }
        return headPitch;
    }

    public static void setHeadPitch(float headPitch) {
        EMFAnimationEntityContext.headPitch = headPitch;
    }

    private static void doHeadValues() {
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof LivingEntity) {
            Entity entity;
            LivingEntity livingEntity = (LivingEntity)eMFEntity;
            float h = Mth.rotLerp((float)EMFAnimationEntityContext.getTickDelta(), (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
            float j = Mth.rotLerp((float)EMFAnimationEntityContext.getTickDelta(), (float)livingEntity.yHeadRotO, (float)livingEntity.yHeadRot);
            float k = j - h;
            if (livingEntity.isPassenger() && (entity = livingEntity.getVehicle()) instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                h = Mth.rotLerp((float)EMFAnimationEntityContext.getTickDelta(), (float)livingEntity2.yBodyRotO, (float)livingEntity2.yBodyRot);
                k = j - h;
                float l = Mth.wrapDegrees((float)k);
                if (l < -85.0f) {
                    l = -85.0f;
                }
                if (l >= 85.0f) {
                    l = 85.0f;
                }
                h = j - l;
                if (l * l > 2500.0f) {
                    h += l * 0.2f;
                }
                k = j - h;
            }
            float m = Mth.lerp((float)EMFAnimationEntityContext.getTickDelta(), (float)livingEntity.xRotO, (float)livingEntity.getXRot());
            if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)livingEntity)) {
                m *= -1.0f;
                k *= -1.0f;
            }
            headPitch = m;
            headYaw = k >= 180.0f || k < -180.0f ? Mth.wrapDegrees((float)k) : k;
        } else {
            headPitch = 0.0f;
            headYaw = 0.0f;
        }
    }

    public static float getTickDelta() {
        return ((MinecraftClientAccessor)Minecraft.getInstance()).getDeltaTracker().getGameTimeDeltaPartialTick(true);
    }

    public static float getMoveForward() {
        if (emfState == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfState.yaw());
        Vec3 velocity = emfState.emfVelocity();
        double x = velocity.x;
        double y = velocity.z;
        double newX = x * Math.cos(lookDir) - y * Math.sin(lookDir);
        return EMFAnimationEntityContext.processMove(newX, x, y);
    }

    public static float getMoveStrafe() {
        if (emfState == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfState.yaw());
        Vec3 velocity = emfState.emfVelocity();
        double x = velocity.x;
        double y = velocity.z;
        double newY = x * Math.sin(lookDir) + y * Math.cos(lookDir);
        return EMFAnimationEntityContext.processMove(newY, x, y);
    }

    private static float processMove(double value, double x, double y) {
        double totalMovementVector = Math.sqrt(x * x + y * y);
        if (totalMovementVector == 0.0) {
            return 0.0f;
        }
        return (float)(-(value / totalMovementVector));
    }

    public static float getShadowSize() {
        return shadowSize;
    }

    public static void setShadowSize(float shadowSize) {
        EMFAnimationEntityContext.shadowSize = shadowSize;
    }

    public static float getShadowOpacity() {
        return shadowOpacity;
    }

    public static void setShadowOpacity(float shadowOpacity) {
        EMFAnimationEntityContext.shadowOpacity = shadowOpacity;
    }

    public static float getLeashX() {
        return leashX;
    }

    public static void setLeashX(float leashX) {
        EMFAnimationEntityContext.leashX = leashX;
    }

    public static float getLeashY() {
        return leashY;
    }

    public static void setLeashY(float leashY) {
        EMFAnimationEntityContext.leashY = leashY;
    }

    public static float getLeashZ() {
        return leashZ;
    }

    public static void setLeashZ(float leashZ) {
        EMFAnimationEntityContext.leashZ = leashZ;
    }

    public static float getShadowX() {
        return shadowX;
    }

    public static void setShadowX(float shadowX) {
        EMFAnimationEntityContext.shadowX = shadowX;
    }

    public static float getShadowZ() {
        return shadowZ;
    }

    public static void setShadowZ(float shadowZ) {
        EMFAnimationEntityContext.shadowZ = shadowZ;
    }

    public static IterationContext getIterationContext() {
        return new IterationContext(EMFManager.getInstance().entityRenderCount, emfState, layerFactory, lodFrameSkipping, shadowSize, shadowOpacity, leashX, leashY, leashZ, shadowX, shadowZ);
    }

    public static void setIterationContext(IterationContext context) {
        EMFManager.getInstance().entityRenderCount = context.entityRenderCount;
        emfState = context.emfState;
        layerFactory = context.layerFactory;
        lodFrameSkipping = context.lodFrameSkipping;
        shadowSize = context.shadowSize;
        shadowOpacity = context.shadowOpacity;
        leashX = context.leashX;
        leashY = context.leashY;
        leashZ = context.leashZ;
        shadowX = context.shadowX;
        shadowZ = context.shadowZ;
    }

    public record IterationContext(long entityRenderCount, @Nullable EMFEntityRenderState emfState, Function<ResourceLocation, RenderType> layerFactory, Boolean lodFrameSkipping, float shadowSize, float shadowOpacity, float leashX, float leashY, float leashZ, float shadowX, float shadowZ) {
    }
}

