/*
 * Decompiled with CFR 0.152.
 */
package vflalec.erasable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vflalec.erasable.network.EraseAreaPayload;
import vflalec.erasable.network.UndoErasePayload;

public class ErasableMod
implements ModInitializer {
    public static final String MOD_ID = "erasable";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"erasable");
    private static final Map<UUID, List<BlockSnapshot>> LAST_ERASE = new ConcurrentHashMap<UUID, List<BlockSnapshot>>();

    public void onInitialize() {
        PayloadTypeRegistry.playC2S().register(EraseAreaPayload.ID, EraseAreaPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(UndoErasePayload.ID, UndoErasePayload.CODEC);
        LOGGER.info("Erasable mod initialized!");
        ServerPlayNetworking.registerGlobalReceiver(EraseAreaPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> {
                try {
                    if (payload == null || payload.pos1() == null || payload.pos2() == null) {
                        LOGGER.warn("Payload EraseArea non valido da {}: posizioni mancanti", (Object)player.method_5477().getString());
                        return;
                    }
                    this.eraseArea(player, payload.pos1(), payload.pos2());
                }
                catch (Exception e) {
                    LOGGER.error("Errore durante eraseArea per {}: {}", new Object[]{player.method_5477().getString(), e.getMessage(), e});
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(UndoErasePayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> {
                UUID pid = player.method_5667();
                List<BlockSnapshot> snapshots = LAST_ERASE.remove(pid);
                if (snapshots == null || snapshots.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7eNessuna operazione da annullare."), false);
                    return;
                }
                class_1937 world = player.method_37908();
                int restored = 0;
                for (BlockSnapshot snap : snapshots) {
                    world.method_8501(snap.pos, snap.state);
                    ++restored;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aUltima modifica annullata (" + restored + " blocchi ripristinati).")), false);
                LOGGER.info("Undo eseguito per {}: ripristinati {} blocchi.", (Object)player.method_5477().getString(), (Object)restored);
            });
        });
    }

    private void eraseArea(class_3222 player, class_2338 pos1, class_2338 pos2) {
        class_1937 world = player.method_37908();
        int minX = Math.min(pos1.method_10263(), pos2.method_10263());
        int maxX = Math.max(pos1.method_10263(), pos2.method_10263());
        int minY = Math.min(pos1.method_10264(), pos2.method_10264());
        int maxY = Math.max(pos1.method_10264(), pos2.method_10264());
        int minZ = Math.min(pos1.method_10260(), pos2.method_10260());
        int maxZ = Math.max(pos1.method_10260(), pos2.method_10260());
        int totalBlocks = (maxX - minX + 1) * (maxY - minY + 1) * (maxZ - minZ + 1);
        if (totalBlocks > 50000) {
            LOGGER.warn("Area troppo grande: {} blocchi. Operazione annullata.", (Object)totalBlocks);
            return;
        }
        ArrayList<BlockSnapshot> history = new ArrayList<BlockSnapshot>(Math.min(totalBlocks, 8192));
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 p = new class_2338(x, y, z);
                    class_2680 prev = world.method_8320(p);
                    if (!prev.method_26215()) {
                        history.add(new BlockSnapshot(p, prev));
                    }
                    world.method_8501(p, class_2246.field_10124.method_9564());
                }
            }
        }
        LAST_ERASE.put(player.method_5667(), history);
        LOGGER.info("Area cancellata da ({},{},{}) a ({},{},{}) - {} blocchi non-aria salvati per undo", new Object[]{minX, minY, minZ, maxX, maxY, maxZ, history.size()});
    }

    private static final class BlockSnapshot {
        final class_2338 pos;
        final class_2680 state;

        BlockSnapshot(class_2338 pos, class_2680 state) {
            this.pos = pos;
            this.state = state;
        }
    }
}

