/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.network;

import dev.mayaqq.cynosure.network.ClientNetworkContext;
import dev.mayaqq.cynosure.network.Network;
import dev.mayaqq.cynosure.network.ServerNetworkContext;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002!\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J?\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\u001d\u0010\u0011\u001a\u0019\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\f0\u0012\u00a2\u0006\u0002\b\u0014H\u0016J?\u0010\u0015\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\u001d\u0010\u0011\u001a\u0019\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\f0\u0012\u00a2\u0006\u0002\b\u0014H\u0016J5\u0010\u0017\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\u0006\u0010\u001a\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u001bJ-\u0010\u001c\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\u0006\u0010\u001a\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/mayaqq/cynosure/network/ForgeNetwork;", "Ldev/mayaqq/cynosure/network/Network;", "name", "Lnet/minecraft/resources/ResourceLocation;", "protocolVersion", "", "<init>", "(Lnet/minecraft/resources/ResourceLocation;I)V", "channel", "Lnet/minecraftforge/network/simple/SimpleChannel;", "packets", "registerClientboundReceiver", "", "T", "", "info", "Ldev/mayaqq/cynosure/network/Network$PacketInfo;", "handler", "Lkotlin/Function2;", "Ldev/mayaqq/cynosure/network/ClientNetworkContext;", "Lkotlin/ExtensionFunctionType;", "registerServerboundReceiver", "Ldev/mayaqq/cynosure/network/ServerNetworkContext;", "sendToClient", "client", "Lnet/minecraft/server/level/ServerPlayer;", "packet", "(Lnet/minecraft/server/level/ServerPlayer;Ldev/mayaqq/cynosure/network/Network$PacketInfo;Ljava/lang/Object;)V", "sendToServer", "(Ldev/mayaqq/cynosure/network/Network$PacketInfo;Ljava/lang/Object;)V", "canSendToPlayer", "", "player", "ClientContext", "ServerContext", "cynosure-forge"})
public final class ForgeNetwork
implements Network {
    @NotNull
    private final SimpleChannel channel;
    private int packets;

    public ForgeNetwork(@NotNull ResourceLocation name, int protocolVersion) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        SimpleChannel simpleChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)name, () -> ForgeNetwork.channel$lambda$0(protocolVersion), arg_0 -> ForgeNetwork.channel$lambda$1(protocolVersion, arg_0), arg_0 -> ForgeNetwork.channel$lambda$2(protocolVersion, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)simpleChannel, (String)"newSimpleChannel(...)");
        this.channel = simpleChannel;
    }

    @Override
    public <T> void registerClientboundReceiver(@NotNull Network.PacketInfo<T> info, @NotNull Function2<? super ClientNetworkContext, ? super T, Unit> handler) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        int n = this.packets;
        this.packets = n + 1;
        this.channel.registerMessage(n, info.getClazz(), (arg_0, arg_1) -> info.getCodec().encode(arg_0, arg_1), arg_0 -> info.getCodec().decode(arg_0), (arg_0, arg_1) -> ForgeNetwork.registerClientboundReceiver$lambda$3(handler, arg_0, arg_1));
    }

    @Override
    public <T> void registerServerboundReceiver(@NotNull Network.PacketInfo<T> info, @NotNull Function2<? super ServerNetworkContext, ? super T, Unit> handler) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        int n = this.packets;
        this.packets = n + 1;
        this.channel.registerMessage(n, info.getClazz(), (arg_0, arg_1) -> info.getCodec().encode(arg_0, arg_1), arg_0 -> info.getCodec().decode(arg_0), (arg_0, arg_1) -> ForgeNetwork.registerServerboundReceiver$lambda$4(handler, arg_0, arg_1));
    }

    @Override
    public <T> void sendToClient(@NotNull ServerPlayer client, @NotNull Network.PacketInfo<T> info, @NotNull T packet) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        this.channel.send(PacketDistributor.PLAYER.with(() -> ForgeNetwork.sendToClient$lambda$5(client)), packet);
    }

    @Override
    public <T> void sendToServer(@NotNull Network.PacketInfo<T> info, @NotNull T packet) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        this.channel.sendToServer(packet);
    }

    @Override
    public boolean canSendToPlayer(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    private static final String channel$lambda$0(int $protocolVersion) {
        return String.valueOf($protocolVersion);
    }

    private static final boolean channel$lambda$1(int $protocolVersion, String it) {
        return Intrinsics.areEqual((Object)it, (Object)String.valueOf($protocolVersion));
    }

    private static final boolean channel$lambda$2(int $protocolVersion, String it) {
        return Intrinsics.areEqual((Object)it, (Object)String.valueOf($protocolVersion));
    }

    private static final void registerClientboundReceiver$lambda$3(Function2 $handler, Object packet, Supplier contextSupplier) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        NetworkEvent.Context ctx = (NetworkEvent.Context)contextSupplier.get();
        Intrinsics.checkNotNull((Object)ctx);
        ClientContext clientContext = new ClientContext(ctx);
        Intrinsics.checkNotNull((Object)packet);
        $handler.invoke((Object)clientContext, packet);
        ctx.setPacketHandled(true);
    }

    private static final void registerServerboundReceiver$lambda$4(Function2 $handler, Object packet, Supplier contextSupplier) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        NetworkEvent.Context ctx = (NetworkEvent.Context)contextSupplier.get();
        Intrinsics.checkNotNull((Object)ctx);
        ServerContext serverContext = new ServerContext(ctx);
        Intrinsics.checkNotNull((Object)packet);
        $handler.invoke((Object)serverContext, packet);
        ctx.setPacketHandled(true);
    }

    private static final ServerPlayer sendToClient$lambda$5(ServerPlayer $client) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        return $client;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Ldev/mayaqq/cynosure/network/ForgeNetwork$ClientContext;", "Ldev/mayaqq/cynosure/network/ClientNetworkContext;", "ctx", "Lnet/minecraftforge/network/NetworkEvent$Context;", "<init>", "(Lnet/minecraftforge/network/NetworkEvent$Context;)V", "getCtx", "()Lnet/minecraftforge/network/NetworkEvent$Context;", "execute", "", "action", "Lkotlin/Function0;", "cynosure-forge"})
    private static final class ClientContext
    extends ClientNetworkContext {
        @NotNull
        private final NetworkEvent.Context ctx;

        public ClientContext(@NotNull NetworkEvent.Context ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.ctx = ctx;
        }

        @NotNull
        public final NetworkEvent.Context getCtx() {
            return this.ctx;
        }

        @Override
        public void execute(@NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.ctx.enqueueWork(() -> ClientContext.execute$lambda$0(action));
        }

        private static final void execute$lambda$0(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Ldev/mayaqq/cynosure/network/ForgeNetwork$ServerContext;", "Ldev/mayaqq/cynosure/network/ServerNetworkContext;", "ctx", "Lnet/minecraftforge/network/NetworkEvent$Context;", "<init>", "(Lnet/minecraftforge/network/NetworkEvent$Context;)V", "getCtx", "()Lnet/minecraftforge/network/NetworkEvent$Context;", "execute", "", "action", "Lkotlin/Function0;", "cynosure-forge"})
    private static final class ServerContext
    extends ServerNetworkContext {
        @NotNull
        private final NetworkEvent.Context ctx;

        public ServerContext(@NotNull NetworkEvent.Context ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            ServerPlayer serverPlayer = ctx.getSender();
            Intrinsics.checkNotNull((Object)serverPlayer);
            MinecraftServer minecraftServer = serverPlayer.server;
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
            ServerPlayer serverPlayer2 = ctx.getSender();
            Intrinsics.checkNotNull((Object)serverPlayer2);
            super(minecraftServer, serverPlayer2);
            this.ctx = ctx;
        }

        @NotNull
        public final NetworkEvent.Context getCtx() {
            return this.ctx;
        }

        @Override
        public void execute(@NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.ctx.enqueueWork(() -> ServerContext.execute$lambda$0(action));
        }

        private static final void execute$lambda$0(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke();
        }
    }
}

