/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.network;

import dev.mayaqq.cynosure.network.ClientNetworkContext;
import dev.mayaqq.cynosure.network.Network;
import dev.mayaqq.cynosure.network.ServerNetworkContext;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0002%&B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007JF\u0010\u0011\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u001d\u0010\u0010\u001a\u0019\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012JF\u0010\u0014\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u001d\u0010\u0010\u001a\u0019\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0012J7\u0010\u0018\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00152\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001a\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Ldev/mayaqq/cynosure/network/ForgeNetwork;", "Ldev/mayaqq/cynosure/network/Network;", "Lnet/minecraft/resources/ResourceLocation;", "name", "", "protocolVersion", "<init>", "(Lnet/minecraft/resources/ResourceLocation;I)V", "", "T", "Ldev/mayaqq/cynosure/network/Network$PacketInfo;", "info", "Lkotlin/Function2;", "Ldev/mayaqq/cynosure/network/ClientNetworkContext;", "", "Lkotlin/ExtensionFunctionType;", "handler", "registerClientboundReceiver", "(Ldev/mayaqq/cynosure/network/Network$PacketInfo;Lkotlin/jvm/functions/Function2;)V", "Ldev/mayaqq/cynosure/network/ServerNetworkContext;", "registerServerboundReceiver", "Lnet/minecraft/server/level/ServerPlayer;", "client", "packet", "sendToClient", "(Lnet/minecraft/server/level/ServerPlayer;Ldev/mayaqq/cynosure/network/Network$PacketInfo;Ljava/lang/Object;)V", "sendToServer", "(Ldev/mayaqq/cynosure/network/Network$PacketInfo;Ljava/lang/Object;)V", "player", "", "canSendToPlayer", "(Lnet/minecraft/server/level/ServerPlayer;)Z", "Lnet/minecraftforge/network/simple/SimpleChannel;", "channel", "Lnet/minecraftforge/network/simple/SimpleChannel;", "packets", "I", "ClientContext", "ServerContext", "cynosure_forge"})
public final class ForgeNetwork
implements Network {
    @NotNull
    private final SimpleChannel channel;
    private int packets;

    public ForgeNetwork(@NotNull ResourceLocation name, int protocolVersion) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        SimpleChannel simpleChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)name, () -> ForgeNetwork.channel$lambda$0(protocolVersion), arg_0 -> ForgeNetwork.channel$lambda$1(protocolVersion, arg_0), arg_0 -> ForgeNetwork.channel$lambda$2(protocolVersion, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)simpleChannel, (String)"newSimpleChannel(...)");
        this.channel = simpleChannel;
    }

    @Override
    public <T> void registerClientboundReceiver(@NotNull Network.PacketInfo<T> info, @NotNull Function2<? super ClientNetworkContext, ? super T, Unit> handler) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        int n = this.packets;
        this.packets = n + 1;
        this.channel.registerMessage(n, info.getClazz(), (arg_0, arg_1) -> info.getCodec().encode(arg_0, arg_1), arg_0 -> info.getCodec().decode(arg_0), (arg_0, arg_1) -> ForgeNetwork.registerClientboundReceiver$lambda$3(handler, arg_0, arg_1));
    }

    @Override
    public <T> void registerServerboundReceiver(@NotNull Network.PacketInfo<T> info, @NotNull Function2<? super ServerNetworkContext, ? super T, Unit> handler) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        int n = this.packets;
        this.packets = n + 1;
        this.channel.registerMessage(n, info.getClazz(), (arg_0, arg_1) -> info.getCodec().encode(arg_0, arg_1), arg_0 -> info.getCodec().decode(arg_0), (arg_0, arg_1) -> ForgeNetwork.registerServerboundReceiver$lambda$4(handler, arg_0, arg_1));
    }

    @Override
    public <T> void sendToClient(@NotNull ServerPlayer client, @NotNull Network.PacketInfo<T> info, @NotNull T packet) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        this.channel.send(PacketDistributor.PLAYER.with(() -> ForgeNetwork.sendToClient$lambda$5(client)), packet);
    }

    @Override
    public <T> void sendToServer(@NotNull Network.PacketInfo<T> info, @NotNull T packet) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        this.channel.sendToServer(packet);
    }

    @Override
    public boolean canSendToPlayer(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    private static final String channel$lambda$0(int $protocolVersion) {
        return String.valueOf($protocolVersion);
    }

    private static final boolean channel$lambda$1(int $protocolVersion, String it) {
        return Intrinsics.areEqual((Object)it, (Object)String.valueOf($protocolVersion));
    }

    private static final boolean channel$lambda$2(int $protocolVersion, String it) {
        return Intrinsics.areEqual((Object)it, (Object)String.valueOf($protocolVersion));
    }

    private static final void registerClientboundReceiver$lambda$3(Function2 $handler, Object packet, Supplier contextSupplier) {
        NetworkEvent.Context ctx = (NetworkEvent.Context)contextSupplier.get();
        Intrinsics.checkNotNull((Object)ctx);
        ClientContext clientContext = new ClientContext(ctx);
        Intrinsics.checkNotNull((Object)packet);
        $handler.invoke((Object)clientContext, packet);
        ctx.setPacketHandled(true);
    }

    private static final void registerServerboundReceiver$lambda$4(Function2 $handler, Object packet, Supplier contextSupplier) {
        NetworkEvent.Context ctx = (NetworkEvent.Context)contextSupplier.get();
        Intrinsics.checkNotNull((Object)ctx);
        ServerContext serverContext = new ServerContext(ctx);
        Intrinsics.checkNotNull((Object)packet);
        $handler.invoke((Object)serverContext, packet);
        ctx.setPacketHandled(true);
    }

    private static final ServerPlayer sendToClient$lambda$5(ServerPlayer $client) {
        return $client;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/mayaqq/cynosure/network/ForgeNetwork$ClientContext;", "Ldev/mayaqq/cynosure/network/ClientNetworkContext;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "ctx", "<init>", "(Lnet/minecraftforge/network/NetworkEvent$Context;)V", "Lkotlin/Function0;", "", "action", "execute", "(Lkotlin/jvm/functions/Function0;)V", "Lnet/minecraftforge/network/NetworkEvent$Context;", "getCtx", "()Lnet/minecraftforge/network/NetworkEvent$Context;", "cynosure_forge"})
    private static final class ClientContext
    extends ClientNetworkContext {
        @NotNull
        private final NetworkEvent.Context ctx;

        public ClientContext(@NotNull NetworkEvent.Context ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.ctx = ctx;
        }

        @NotNull
        public final NetworkEvent.Context getCtx() {
            return this.ctx;
        }

        @Override
        public void execute(@NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.ctx.enqueueWork(() -> ClientContext.execute$lambda$0(action));
        }

        private static final void execute$lambda$0(Function0 $tmp0) {
            $tmp0.invoke();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/mayaqq/cynosure/network/ForgeNetwork$ServerContext;", "Ldev/mayaqq/cynosure/network/ServerNetworkContext;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "ctx", "<init>", "(Lnet/minecraftforge/network/NetworkEvent$Context;)V", "Lkotlin/Function0;", "", "action", "execute", "(Lkotlin/jvm/functions/Function0;)V", "Lnet/minecraftforge/network/NetworkEvent$Context;", "getCtx", "()Lnet/minecraftforge/network/NetworkEvent$Context;", "cynosure_forge"})
    private static final class ServerContext
    extends ServerNetworkContext {
        @NotNull
        private final NetworkEvent.Context ctx;

        public ServerContext(@NotNull NetworkEvent.Context ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            ServerPlayer serverPlayer = ctx.getSender();
            Intrinsics.checkNotNull((Object)serverPlayer);
            MinecraftServer minecraftServer = serverPlayer.f_8924_;
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
            ServerPlayer serverPlayer2 = ctx.getSender();
            Intrinsics.checkNotNull((Object)serverPlayer2);
            super(minecraftServer, serverPlayer2);
            this.ctx = ctx;
        }

        @NotNull
        public final NetworkEvent.Context getCtx() {
            return this.ctx;
        }

        @Override
        public void execute(@NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.ctx.enqueueWork(() -> ServerContext.execute$lambda$0(action));
        }

        private static final void execute$lambda$0(Function0 $tmp0) {
            $tmp0.invoke();
        }
    }
}

