/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.core;

import dev.mayaqq.cynosure.core.Environment;
import dev.mayaqq.cynosure.core.Loader;
import dev.mayaqq.cynosure.core.PlatformHooks;
import dev.mayaqq.cynosure.core.mod.Mod;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Ldev/mayaqq/cynosure/core/PlatformHooksImpl;", "Ldev/mayaqq/cynosure/core/PlatformHooks;", "<init>", "()V", "environment", "Ldev/mayaqq/cynosure/core/Environment;", "getEnvironment", "()Ldev/mayaqq/cynosure/core/Environment;", "devEnvironment", "", "getDevEnvironment", "()Z", "isModLoaded", "modid", "", "getMod", "Ldev/mayaqq/cynosure/core/mod/Mod;", "currentLoader", "Ldev/mayaqq/cynosure/core/Loader;", "cynosure-forge"})
public final class PlatformHooksImpl
implements PlatformHooks {
    @NotNull
    private final Environment environment;

    public PlatformHooksImpl() {
        Dist dist = FMLEnvironment.dist;
        Intrinsics.checkNotNull((Object)dist);
        this.environment = switch (WhenMappings.$EnumSwitchMapping$0[dist.ordinal()]) {
            case 1 -> Environment.CLIENT;
            case 2 -> Environment.SERVER;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public boolean getDevEnvironment() {
        return !FMLEnvironment.production;
    }

    @Override
    public boolean isModLoaded(@NotNull String modid) {
        Intrinsics.checkNotNullParameter((Object)modid, (String)"modid");
        return ModList.get().isLoaded(modid);
    }

    @Override
    @Nullable
    public Mod getMod(@NotNull String modid) {
        Mod mod;
        Intrinsics.checkNotNullParameter((Object)modid, (String)"modid");
        Optional optional = ModList.get().getModContainerById(modid);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getModContainerById(...)");
        ModContainer modContainer = (ModContainer)OptionalsKt.getOrNull((Optional)optional);
        if (modContainer != null) {
            ModContainer it = modContainer;
            boolean bl = false;
            String string = it.getModInfo().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            String string2 = it.getModInfo().getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
            String string3 = it.getModInfo().getVersion().toString();
            Optional optional2 = it.getModInfo().getLogoFile();
            Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getLogoFile(...)");
            mod = new Mod(modid, string, string2, string3, (String)OptionalsKt.getOrNull((Optional)optional2));
        } else {
            mod = null;
        }
        return mod;
    }

    @Override
    @NotNull
    public Loader currentLoader() {
        return Loader.FORGE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Dist.values().length];
            try {
                nArray[Dist.CLIENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dist.DEDICATED_SERVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

