/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.core.registry;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.mayaqq.cynosure.utils.serialization.defaults.ResourceLocationSerializer;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001a*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002\u001a\u001bB\u0019\u0012\u0010\b\u0002\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u0019J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fR\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/mayaqq/cynosure/core/registry/NamedRegistry;", "T", "", "defaultValue", "Lkotlin/Function0;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "idMap", "Lcom/google/common/collect/HashBiMap;", "Lnet/minecraft/resources/ResourceLocation;", "getIdMap", "()Lcom/google/common/collect/HashBiMap;", "codec", "Lcom/mojang/serialization/Codec;", "serializer", "Lkotlinx/serialization/KSerializer;", "register", "key", "value", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Object;)Ljava/lang/Object;", "get", "(Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/Object;", "getKey", "(Ljava/lang/Object;)Lnet/minecraft/resources/ResourceLocation;", "getAll", "", "Companion", "Serializer", "cynosure-forge"})
@SourceDebugExtension(value={"SMAP\nNamedRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedRegistry.kt\ndev/mayaqq/cynosure/core/registry/NamedRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public class NamedRegistry<T> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final Function0<T> defaultValue;
    @NotNull
    private final HashBiMap<ResourceLocation, T> idMap;
    @Nullable
    private Codec<T> codec;
    @Nullable
    private KSerializer<T> serializer;

    public NamedRegistry(@Nullable Function0<? extends T> defaultValue) {
        this.defaultValue = defaultValue;
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(...)");
        this.idMap = hashBiMap;
    }

    public /* synthetic */ NamedRegistry(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        this(function0);
    }

    @NotNull
    protected final HashBiMap<ResourceLocation, T> getIdMap() {
        return this.idMap;
    }

    @NotNull
    public T register(@NotNull ResourceLocation key, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Objects.requireNonNull(key, "Key cannot be null");
        Objects.requireNonNull(value, "Value cannot be null");
        if (!(!this.idMap.containsKey((Object)key))) {
            boolean bl = false;
            String string = "Key already present: " + key;
            throw new IllegalStateException(string.toString());
        }
        ((Map)this.idMap).put(key, value);
        return value;
    }

    @Nullable
    public T get(@NotNull ResourceLocation key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.idMap.get((Object)key);
        if (object == null) {
            Function0<T> function0 = this.defaultValue;
            object = function0 != null ? function0.invoke() : null;
        }
        return (T)object;
    }

    @Nullable
    public ResourceLocation getKey(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return (ResourceLocation)this.idMap.inverse().get(value);
    }

    @NotNull
    public final Map<ResourceLocation, T> getAll() {
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)((Map)this.idMap));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
        return (Map)immutableMap;
    }

    @NotNull
    public final Codec<T> codec() {
        Codec codec2 = this.codec;
        if (codec2 == null) {
            Codec codec3;
            Codec it = codec3 = ResourceLocation.CODEC.flatXmap(arg_0 -> NamedRegistry.codec$lambda$3(arg_0 -> NamedRegistry.codec$lambda$2(this, arg_0), arg_0), arg_0 -> NamedRegistry.codec$lambda$6(arg_0 -> NamedRegistry.codec$lambda$5(this, arg_0), arg_0));
            boolean bl = false;
            this.codec = it;
            Codec codec4 = codec3;
            Intrinsics.checkNotNullExpressionValue((Object)codec4, (String)"also(...)");
            codec2 = codec4;
        }
        return codec2;
    }

    @NotNull
    public final KSerializer<T> serializer() {
        KSerializer kSerializer = this.serializer;
        if (kSerializer == null) {
            Serializer serializer2;
            Serializer it = serializer2 = new Serializer();
            boolean bl = false;
            this.serializer = it;
            kSerializer = serializer2;
        }
        return kSerializer;
    }

    private static final String codec$lambda$2$lambda$1(ResourceLocation $rl) {
        return "Entry not present: " + $rl;
    }

    private static final <T> DataResult<? extends T> codec$lambda$2(NamedRegistry<T> this$0, ResourceLocation rl) {
        Intrinsics.checkNotNull((Object)rl);
        return NamedRegistry.Companion.failIfNull(this$0.get(rl), () -> NamedRegistry.codec$lambda$2$lambda$1(rl));
    }

    private static final DataResult codec$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DataResult)$tmp0.invoke(p0);
    }

    private static final String codec$lambda$5$lambda$4(Object $value) {
        return "Item not found in registry: " + $value;
    }

    private static final <T> DataResult<? extends ResourceLocation> codec$lambda$5(NamedRegistry<T> this$0, T value) {
        Intrinsics.checkNotNull(value);
        return NamedRegistry.Companion.failIfNull(this$0.getKey(value), () -> NamedRegistry.codec$lambda$5$lambda$4(value));
    }

    private static final DataResult codec$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DataResult)$tmp0.invoke(p0);
    }

    public NamedRegistry() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\b\u0010\u0007\u001a\u0004\u0018\u0001H\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/mayaqq/cynosure/core/registry/NamedRegistry$Companion;", "", "<init>", "()V", "failIfNull", "Lcom/mojang/serialization/DataResult;", "R", "item", "errorMessage", "Ljava/util/function/Supplier;", "", "(Ljava/lang/Object;Ljava/util/function/Supplier;)Lcom/mojang/serialization/DataResult;", "cynosure-forge"})
    private static final class Companion {
        private Companion() {
        }

        private final <R> DataResult<R> failIfNull(R item, Supplier<String> errorMessage) {
            DataResult dataResult;
            R r = item;
            if (r != null) {
                DataResult dataResult2 = DataResult.success(r);
                dataResult = dataResult2;
                Intrinsics.checkNotNullExpressionValue((Object)dataResult2, (String)"success(...)");
            } else {
                DataResult dataResult3 = DataResult.error(errorMessage);
                dataResult = dataResult3;
                Intrinsics.checkNotNullExpressionValue((Object)dataResult3, (String)"error(...)");
            }
            return dataResult;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ldev/mayaqq/cynosure/core/registry/NamedRegistry$Serializer;", "Lkotlinx/serialization/KSerializer;", "<init>", "(Ldev/mayaqq/cynosure/core/registry/NamedRegistry;)V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "cynosure-forge"})
    private final class Serializer
    implements KSerializer<T> {
        @NotNull
        private final SerialDescriptor descriptor;

        public Serializer() {
            this.descriptor = SerialDescriptorsKt.SerialDescriptor((String)("dev.mayaqq.cynosure.core.registry.NamedRegistry[" + NamedRegistry.this + "]"), (SerialDescriptor)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE).getDescriptor());
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return this.descriptor;
        }

        @NotNull
        public T deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            Object t = NamedRegistry.this.get(ResourceLocationSerializer.INSTANCE.deserialize(decoder));
            Intrinsics.checkNotNull(t);
            return t;
        }

        public void serialize(@NotNull Encoder encoder, @NotNull T value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            ResourceLocation resourceLocation = NamedRegistry.this.getKey(value);
            if (resourceLocation == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            ResourceLocationSerializer.INSTANCE.serialize(encoder, resourceLocation);
        }
    }
}

