/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.tooltips;

import dev.mayaqq.cynosure.helpers.McFontKt;
import dev.mayaqq.cynosure.injection.client.IMinecraftKt;
import dev.mayaqq.cynosure.items.extensions.CustomTooltip;
import dev.mayaqq.cynosure.utils.CoupleKt;
import dev.mayaqq.cynosure.utils.colors.Color;
import dev.mayaqq.cynosure.utils.colors.ColorKt;
import dev.mayaqq.cynosure.utils.colors.NamedColors;
import dev.mayaqq.cynosure.utils.language.KreakInteratorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001e*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0018\u0010\u0010\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006!"}, d2={"Ldev/mayaqq/cynosure/tooltips/DescriptionTooltip;", "Ldev/mayaqq/cynosure/items/extensions/CustomTooltip;", "theme", "Ldev/mayaqq/cynosure/tooltips/DescriptionTooltip$Theme;", "<init>", "(Ldev/mayaqq/cynosure/tooltips/DescriptionTooltip$Theme;)V", "lines", "", "Lnet/minecraft/network/chat/Component;", "hiddenLines", "cachedLanguage", "", "pressShiftComponentOff", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "Lnet/minecraft/network/chat/MutableComponent;", "pressShiftComponentOn", "modifyTooltip", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "flags", "Lnet/minecraft/world/item/TooltipFlag;", "rebuild", "Lnet/minecraft/world/item/Item;", "checkLanguage", "", "format", "", "Theme", "Companion", "cynosure-forge"})
@SourceDebugExtension(value={"SMAP\nDescriptionTooltip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DescriptionTooltip.kt\ndev/mayaqq/cynosure/tooltips/DescriptionTooltip\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,132:1\n1863#2,2:133\n739#2,9:135\n37#3:144\n36#3,3:145\n*S KotlinDebug\n*F\n+ 1 DescriptionTooltip.kt\ndev/mayaqq/cynosure/tooltips/DescriptionTooltip\n*L\n88#1:133,2\n116#1:135,9\n116#1:144\n116#1:145,3\n*E\n"})
public final class DescriptionTooltip
implements CustomTooltip {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Theme theme;
    @NotNull
    private final List<Component> lines;
    @NotNull
    private final List<Component> hiddenLines;
    @Nullable
    private String cachedLanguage;
    private final MutableComponent pressShiftComponentOff;
    private final MutableComponent pressShiftComponentOn;
    public static final int MAX_LINE_WIDTH = 200;

    public DescriptionTooltip(@NotNull Theme theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.theme = theme;
        this.lines = new ArrayList();
        this.hiddenLines = new ArrayList();
        this.pressShiftComponentOff = Component.translatable((String)"tooltip.generic.cynosure.hold_shift.off");
        this.pressShiftComponentOn = Component.translatable((String)"tooltip.generic.cynosure.hold_shift.on");
    }

    @Override
    public void modifyTooltip(@NotNull List<Component> $this$modifyTooltip, @NotNull ItemStack stack, @Nullable Player player, @NotNull TooltipFlag flags) {
        Intrinsics.checkNotNullParameter($this$modifyTooltip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        if (this.checkLanguage()) {
            Item item = stack.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
            this.rebuild(item);
        }
        if (Screen.hasShiftDown()) {
            $this$modifyTooltip.addAll(1, (Collection<Component>)this.lines);
            MutableComponent mutableComponent = this.pressShiftComponentOn;
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"pressShiftComponentOn");
            $this$modifyTooltip.add(1, (Component)mutableComponent);
        } else {
            MutableComponent mutableComponent = this.pressShiftComponentOff;
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"pressShiftComponentOff");
            $this$modifyTooltip.add(1, (Component)mutableComponent);
        }
    }

    private final void rebuild(Item stack) {
        this.lines.clear();
        String key = stack.getDescriptionId() + ".tooltip";
        MutableComponent mutableComponent = Component.empty();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"empty(...)");
        this.lines.add((Component)mutableComponent);
        MutableComponent mutableComponent2 = Component.translatable((String)key);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
        this.lines.addAll((Collection<Component>)this.format((Component)mutableComponent2, this.theme));
    }

    private final boolean checkLanguage() {
        String selected = Minecraft.getInstance().getLanguageManager().getSelected();
        if (!Intrinsics.areEqual((Object)selected, (Object)this.cachedLanguage)) {
            this.cachedLanguage = selected;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Component> format(Component $this$format, Theme theme) {
        List list;
        List $this$format_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int totalWidth = 0;
        Object currentLine = null;
        currentLine = "";
        String string = $this$format.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        Minecraft minecraft = Minecraft.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getInstance(...)");
        Iterable $this$forEach$iv = KreakInteratorKt.words(string, IMinecraftKt.getJavaLocale(minecraft));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String word = (String)element$iv;
            boolean bl2 = false;
            int width = McFontKt.getMcFont().width(StringsKt.replace$default((String)word, (String)"_", (String)"", (boolean)false, (int)4, null));
            if (totalWidth + width > 200) {
                if (totalWidth > 0) {
                    $this$format_u24lambda_u241.add(currentLine);
                    currentLine = "";
                    totalWidth = 0;
                } else {
                    $this$format_u24lambda_u241.add(word);
                    continue;
                }
            }
            totalWidth += width;
            currentLine = currentLine + word;
        }
        if (totalWidth > 0) {
            $this$format_u24lambda_u241.add(currentLine);
        }
        List lines = CollectionsKt.build((List)list);
        MutableComponent lineStart = Component.literal((String)StringsKt.repeat((CharSequence)" ", (int)theme.getIndent()));
        lineStart.withStyle(arg_0 -> DescriptionTooltip.format$lambda$2(theme, arg_0));
        List formattedLines = new ArrayList();
        Pair styles = TuplesKt.to((Object)Color.box-impl(theme.getPrimaryColor-cBNlwC8()), (Object)Color.box-impl(theme.getHighlightColor-cBNlwC8()));
        Ref.BooleanRef currentlyHighlighted = new Ref.BooleanRef();
        for (String string2 : lines) {
            void $this$toTypedArray$iv;
            List list2;
            Collection $this$dropLastWhile$iv;
            MutableComponent currentComponent = lineStart.plainCopy();
            Object element$iv = string2;
            Regex word = new Regex("_");
            int bl2 = 0;
            element$iv = word.split((CharSequence)element$iv, bl2);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl3 = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            for (String part : thisCollection$iv.toArray(new String[0])) {
                currentComponent.append((Component)Component.literal((String)part).withStyle(arg_0 -> DescriptionTooltip.format$lambda$4(styles, currentlyHighlighted, arg_0)));
                currentlyHighlighted.element = !currentlyHighlighted.element;
            }
            Intrinsics.checkNotNull((Object)currentComponent);
            formattedLines.add(currentComponent);
            currentlyHighlighted.element = !currentlyHighlighted.element;
        }
        return formattedLines;
    }

    private static final Style format$lambda$2(Theme $theme, Style it) {
        Intrinsics.checkNotNullParameter((Object)$theme, (String)"$theme");
        return it.withColor(Color.toInt-impl($theme.getPrimaryColor-cBNlwC8()));
    }

    private static final Style format$lambda$4(Pair $styles, Ref.BooleanRef $currentlyHighlighted, Style it) {
        Intrinsics.checkNotNullParameter((Object)$styles, (String)"$styles");
        Intrinsics.checkNotNullParameter((Object)$currentlyHighlighted, (String)"$currentlyHighlighted");
        return it.withColor(Color.toInt-impl(((Color)CoupleKt.get($styles, $currentlyHighlighted.element)).unbox-impl()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/mayaqq/cynosure/tooltips/DescriptionTooltip$Companion;", "", "<init>", "()V", "MAX_LINE_WIDTH", "", "cynosure-forge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ5\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u000bJ\u0010\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u000bJ\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J8\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u0013J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006$"}, d2={"Ldev/mayaqq/cynosure/tooltips/DescriptionTooltip$Theme;", "", "primaryColor", "Ldev/mayaqq/cynosure/utils/colors/Color;", "secodaryColor", "highlightColor", "indent", "", "<init>", "(IIIILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getPrimaryColor-cBNlwC8", "()I", "I", "getSecodaryColor-cBNlwC8", "getHighlightColor-cBNlwC8", "getIndent", "with", "secondaryColor", "with-7jVaRB4", "(IIII)Ldev/mayaqq/cynosure/tooltips/DescriptionTooltip$Theme;", "component1", "component1-cBNlwC8", "component2", "component2-cBNlwC8", "component3", "component3-cBNlwC8", "component4", "copy", "copy-7jVaRB4", "equals", "", "other", "hashCode", "toString", "", "Companion", "cynosure-forge"})
    public static final class Theme {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int primaryColor;
        private final int secodaryColor;
        private final int highlightColor;
        private final int indent;
        @NotNull
        private static final Theme Default = new Theme(NamedColors.getDarkGray(), NamedColors.getLightGray(), ColorKt.Color-qim9Vi0$default(8673662, null, 2, null), 0, null);

        private Theme(int primaryColor, int secodaryColor, int highlightColor, int indent) {
            this.primaryColor = primaryColor;
            this.secodaryColor = secodaryColor;
            this.highlightColor = highlightColor;
            this.indent = indent;
        }

        public final int getPrimaryColor-cBNlwC8() {
            return this.primaryColor;
        }

        public final int getSecodaryColor-cBNlwC8() {
            return this.secodaryColor;
        }

        public final int getHighlightColor-cBNlwC8() {
            return this.highlightColor;
        }

        public final int getIndent() {
            return this.indent;
        }

        @NotNull
        public final Theme with-7jVaRB4(int primaryColor, int secondaryColor, int highlightColor, int indent) {
            return new Theme(primaryColor, secondaryColor, highlightColor, indent, null);
        }

        public static /* synthetic */ Theme with-7jVaRB4$default(Theme theme, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = theme.primaryColor;
            }
            if ((n5 & 2) != 0) {
                n2 = theme.secodaryColor;
            }
            if ((n5 & 4) != 0) {
                n3 = theme.highlightColor;
            }
            if ((n5 & 8) != 0) {
                n4 = theme.indent;
            }
            return theme.with-7jVaRB4(n, n2, n3, n4);
        }

        public final int component1-cBNlwC8() {
            return this.primaryColor;
        }

        public final int component2-cBNlwC8() {
            return this.secodaryColor;
        }

        public final int component3-cBNlwC8() {
            return this.highlightColor;
        }

        public final int component4() {
            return this.indent;
        }

        @NotNull
        public final Theme copy-7jVaRB4(int primaryColor, int secodaryColor, int highlightColor, int indent) {
            return new Theme(primaryColor, secodaryColor, highlightColor, indent, null);
        }

        public static /* synthetic */ Theme copy-7jVaRB4$default(Theme theme, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = theme.primaryColor;
            }
            if ((n5 & 2) != 0) {
                n2 = theme.secodaryColor;
            }
            if ((n5 & 4) != 0) {
                n3 = theme.highlightColor;
            }
            if ((n5 & 8) != 0) {
                n4 = theme.indent;
            }
            return theme.copy-7jVaRB4(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Theme(primaryColor=" + Color.toString-impl(this.primaryColor) + ", secodaryColor=" + Color.toString-impl(this.secodaryColor) + ", highlightColor=" + Color.toString-impl(this.highlightColor) + ", indent=" + this.indent + ")";
        }

        public int hashCode() {
            int result = Color.hashCode-impl(this.primaryColor);
            result = result * 31 + Color.hashCode-impl(this.secodaryColor);
            result = result * 31 + Color.hashCode-impl(this.highlightColor);
            result = result * 31 + Integer.hashCode(this.indent);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Theme)) {
                return false;
            }
            Theme theme = (Theme)other;
            if (!Color.equals-impl0(this.primaryColor, theme.primaryColor)) {
                return false;
            }
            if (!Color.equals-impl0(this.secodaryColor, theme.secodaryColor)) {
                return false;
            }
            if (!Color.equals-impl0(this.highlightColor, theme.highlightColor)) {
                return false;
            }
            return this.indent == theme.indent;
        }

        public /* synthetic */ Theme(int primaryColor, int secodaryColor, int highlightColor, int indent, DefaultConstructorMarker $constructor_marker) {
            this(primaryColor, secodaryColor, highlightColor, indent);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/mayaqq/cynosure/tooltips/DescriptionTooltip$Theme$Companion;", "", "<init>", "()V", "Default", "Ldev/mayaqq/cynosure/tooltips/DescriptionTooltip$Theme;", "getDefault", "()Ldev/mayaqq/cynosure/tooltips/DescriptionTooltip$Theme;", "cynosure-forge"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Theme getDefault() {
                return Default;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

