/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.utils;

import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\u001a \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u001a \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0006\u001a \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0006\u001a\u0012\u0010\b\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u000b\u001a\u00020\n*\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0012\u0010\u000f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a8\u0006\u0016"}, d2={"allAxis", "", "Lnet/minecraft/core/Direction$Axis;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "initial", "allDirections", "Lnet/minecraft/core/Direction;", "allHorizontalDirections", "rotatedCopy", "rotation", "Lnet/minecraft/world/phys/Vec3;", "rotated", "deg", "", "axis", "length", "shiftToUp", "initialDirection", "shiftHorizontalToSouth", "getDirectionRotationVec", "direction", "getHorizontalDirectionRotationVec", "cynosure-forge"})
public final class ShapeUtilsKt {
    @NotNull
    public static final Map<Direction.Axis, VoxelShape> allAxis(@NotNull VoxelShape $this$allAxis, @NotNull Direction.Axis initial) {
        Intrinsics.checkNotNullParameter((Object)$this$allAxis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        Map map2 = new EnumMap(Direction.Axis.class);
        Direction initialDir = Direction.fromAxisAndDirection((Direction.Axis)initial, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        for (Direction.Axis axis : EntriesMappings.entries$0) {
            Direction direction = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"fromAxisAndDirection(...)");
            Intrinsics.checkNotNull((Object)initialDir);
            Vec3 dir = ShapeUtilsKt.getDirectionRotationVec(ShapeUtilsKt.shiftToUp(direction, initialDir));
            map2.put(axis, ShapeUtilsKt.rotatedCopy($this$allAxis, dir));
        }
        return map2;
    }

    public static /* synthetic */ Map allAxis$default(VoxelShape voxelShape, Direction.Axis axis, int n, Object object) {
        if ((n & 1) != 0) {
            axis = Direction.Axis.Y;
        }
        return ShapeUtilsKt.allAxis(voxelShape, axis);
    }

    @NotNull
    public static final Map<Direction, VoxelShape> allDirections(@NotNull VoxelShape $this$allDirections, @NotNull Direction initial) {
        Intrinsics.checkNotNullParameter((Object)$this$allDirections, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        Map map2 = new EnumMap(Direction.class);
        for (Direction dir : EntriesMappings.entries$1) {
            map2.put(dir, ShapeUtilsKt.rotatedCopy($this$allDirections, ShapeUtilsKt.getDirectionRotationVec(ShapeUtilsKt.shiftToUp(dir, initial))));
        }
        return map2;
    }

    public static /* synthetic */ Map allDirections$default(VoxelShape voxelShape, Direction direction, int n, Object object) {
        if ((n & 1) != 0) {
            direction = Direction.UP;
        }
        return ShapeUtilsKt.allDirections(voxelShape, direction);
    }

    @NotNull
    public static final Map<Direction, VoxelShape> allHorizontalDirections(@NotNull VoxelShape $this$allHorizontalDirections, @NotNull Direction initial) {
        Intrinsics.checkNotNullParameter((Object)$this$allHorizontalDirections, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        Map map2 = new EnumMap(Direction.class);
        for (Direction dir : EntriesMappings.entries$1) {
            map2.put(dir, ShapeUtilsKt.rotatedCopy($this$allHorizontalDirections, ShapeUtilsKt.getHorizontalDirectionRotationVec(ShapeUtilsKt.shiftHorizontalToSouth(dir, initial))));
        }
        return map2;
    }

    public static /* synthetic */ Map allHorizontalDirections$default(VoxelShape voxelShape, Direction direction, int n, Object object) {
        if ((n & 1) != 0) {
            direction = Direction.SOUTH;
        }
        return ShapeUtilsKt.allHorizontalDirections(voxelShape, direction);
    }

    @NotNull
    public static final VoxelShape rotatedCopy(@NotNull VoxelShape $this$rotatedCopy, @NotNull Vec3 rotation) {
        Intrinsics.checkNotNullParameter((Object)$this$rotatedCopy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        if (Intrinsics.areEqual((Object)rotation, (Object)Vec3.ZERO)) {
            return $this$rotatedCopy;
        }
        MutableObject result = new MutableObject((Object)Shapes.empty());
        Vec3 center = new Vec3(8.0, 8.0, 8.0);
        $this$rotatedCopy.forAllBoxes((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ShapeUtilsKt.rotatedCopy$lambda$0(center, rotation, result, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
        Object object = result.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (VoxelShape)object;
    }

    @NotNull
    public static final Vec3 rotated(@NotNull Vec3 $this$rotated, double deg, @NotNull Direction.Axis axis) {
        Intrinsics.checkNotNullParameter((Object)$this$rotated, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        if (deg == 0.0) {
            return $this$rotated;
        }
        if ($this$rotated == Vec3.ZERO) {
            return $this$rotated;
        }
        float angle = (float)(deg / (double)180.0f * Math.PI);
        double sin = Mth.sin((float)angle);
        double cos = Mth.cos((float)angle);
        double x = $this$rotated.x;
        double y = $this$rotated.y;
        double z = $this$rotated.z;
        return switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
            case 1 -> new Vec3(x, y * cos - z * sin, z * cos + y * sin);
            case 2 -> new Vec3(x * cos + z * sin, y, z * cos - x * sin);
            case 3 -> new Vec3(x * cos - y * sin, y * cos + x * sin, z);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final double length(@NotNull VoxelShape $this$length, @NotNull Direction.Axis axis) {
        Intrinsics.checkNotNullParameter((Object)$this$length, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return $this$length.isEmpty() ? 0.0 : $this$length.max(axis) - $this$length.min(axis);
    }

    private static final Direction shiftToUp(Direction $this$shiftToUp, Direction initialDirection) {
        Direction direction;
        switch (WhenMappings.$EnumSwitchMapping$1[initialDirection.ordinal()]) {
            case 1: {
                direction = $this$shiftToUp;
                break;
            }
            case 2: {
                Direction direction2 = $this$shiftToUp.getOpposite();
                direction = direction2;
                Intrinsics.checkNotNullExpressionValue((Object)direction2, (String)"getOpposite(...)");
                break;
            }
            default: {
                Direction.Axis rotateAxis = initialDirection.getAxis() == Direction.Axis.Z ? Direction.Axis.X : Direction.Axis.Z;
                Direction direction3 = $this$shiftToUp.getAxisDirection() == Direction.AxisDirection.POSITIVE ? $this$shiftToUp.getClockWise(rotateAxis) : $this$shiftToUp.getCounterClockWise(rotateAxis);
                Intrinsics.checkNotNull((Object)direction3);
                direction = direction3;
            }
        }
        return direction;
    }

    private static final Direction shiftHorizontalToSouth(Direction $this$shiftHorizontalToSouth, Direction initial) {
        Direction direction;
        switch (WhenMappings.$EnumSwitchMapping$1[initial.ordinal()]) {
            case 3: {
                direction = $this$shiftHorizontalToSouth;
                break;
            }
            case 4: {
                Direction direction2 = $this$shiftHorizontalToSouth.getOpposite();
                direction = direction2;
                Intrinsics.checkNotNullExpressionValue((Object)direction2, (String)"getOpposite(...)");
                break;
            }
            case 5: {
                Direction direction3 = $this$shiftHorizontalToSouth.getClockWise();
                direction = direction3;
                Intrinsics.checkNotNullExpressionValue((Object)direction3, (String)"getClockWise(...)");
                break;
            }
            case 6: {
                Direction direction4 = $this$shiftHorizontalToSouth.getCounterClockWise();
                direction = direction4;
                Intrinsics.checkNotNullExpressionValue((Object)direction4, (String)"getCounterClockWise(...)");
                break;
            }
            default: {
                throw new IllegalStateException("Not a horizontal direction".toString());
            }
        }
        return direction;
    }

    private static final Vec3 getDirectionRotationVec(Direction direction) {
        Vec3 vec3;
        if (direction == Direction.UP) {
            Vec3 vec32 = Vec3.ZERO;
            vec3 = vec32;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
        } else {
            vec3 = new Vec3((double)(Direction.Plane.VERTICAL.test(direction) ? 180 : 90), -((double)((float)((int)Math.max((double)direction.get2DDataValue(), 0.0) & 3) * 90.0f)), 0.0);
        }
        return vec3;
    }

    private static final Vec3 getHorizontalDirectionRotationVec(Direction direction) {
        Vec3 vec3;
        if (direction == Direction.SOUTH) {
            Vec3 vec32 = Vec3.ZERO;
            vec3 = vec32;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
        } else {
            vec3 = new Vec3(0.0, -((double)((float)((int)Math.max((double)direction.get2DDataValue(), 0.0) & 3) * 90.0f)), 0.0);
        }
        return vec3;
    }

    private static final void rotatedCopy$lambda$0(Vec3 $center, Vec3 $rotation, MutableObject $result, double x1, double y1, double z1, double x2, double y2, double z2) {
        Intrinsics.checkNotNullParameter((Object)$center, (String)"$center");
        Intrinsics.checkNotNullParameter((Object)$rotation, (String)"$rotation");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Vec3 v1 = new Vec3(x1, y1, z1).scale(16.0).subtract($center);
        Vec3 v2 = new Vec3(x2, y2, z2).scale(16.0).subtract($center);
        Vec3 vec3 = v1;
        Intrinsics.checkNotNull((Object)vec3);
        v1 = ShapeUtilsKt.rotated(vec3, (float)$rotation.x, Direction.Axis.X);
        v1 = ShapeUtilsKt.rotated(v1, (float)$rotation.y, Direction.Axis.Y);
        v1 = ShapeUtilsKt.rotated(v1, (float)$rotation.z, Direction.Axis.Z).add($center);
        vec3 = v2;
        Intrinsics.checkNotNull((Object)vec3);
        v2 = ShapeUtilsKt.rotated(vec3, (float)$rotation.x, Direction.Axis.X);
        v2 = ShapeUtilsKt.rotated(v2, (float)$rotation.y, Direction.Axis.Y);
        v2 = ShapeUtilsKt.rotated(v2, (float)$rotation.z, Direction.Axis.Z).add($center);
        VoxelShape rotated = Block.box((double)Math.min(v1.x, v2.x), (double)Math.min(v1.y, v2.y), (double)Math.min(v1.z, v2.z), (double)Math.max(v1.x, v2.x), (double)Math.max(v1.y, v2.y), (double)Math.max(v1.z, v2.z));
        $result.setValue((Object)Shapes.or((VoxelShape)((VoxelShape)$result.getValue()), (VoxelShape)rotated));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction.Axis> entries$0;
        public static final /* synthetic */ EnumEntries<Direction> entries$1;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.Axis.values()));
            entries$1 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Direction.Axis.values().length];
            try {
                nArray[Direction.Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Direction.values().length];
            try {
                nArray[Direction.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

