/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.core.bytecodecs;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import dev.mayaqq.cynosure.utils.result.DataResultKt;
import dev.mayaqq.cynosure.utils.result.ExtensionsKt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J;\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0001\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f2\u0006\u0010\u0010\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u0011J?\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000b0\u00130\n\"\b\b\u0001\u0010\u000b*\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f2\u0006\u0010\r\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Ldev/mayaqq/cynosure/core/bytecodecs/ByteCodecCodec;", "A", "Lcom/mojang/serialization/Codec;", "byteCodec", "Lcom/teamresourceful/bytecodecs/base/ByteCodec;", "<init>", "(Lcom/teamresourceful/bytecodecs/base/ByteCodec;)V", "getByteCodec", "()Lcom/teamresourceful/bytecodecs/base/ByteCodec;", "encode", "Lcom/mojang/serialization/DataResult;", "T", "", "input", "ops", "Lcom/mojang/serialization/DynamicOps;", "prefix", "(Ljava/lang/Object;Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "decode", "Lcom/mojang/datafixers/util/Pair;", "(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "cynosure-forge"})
public final class ByteCodecCodec<A>
implements Codec<A> {
    @NotNull
    private final ByteCodec<A> byteCodec;

    public ByteCodecCodec(@NotNull ByteCodec<A> byteCodec) {
        Intrinsics.checkNotNullParameter(byteCodec, (String)"byteCodec");
        this.byteCodec = byteCodec;
    }

    @NotNull
    public final ByteCodec<A> getByteCodec() {
        return this.byteCodec;
    }

    @NotNull
    public <T> DataResult<T> encode(A input, @NotNull DynamicOps<T> ops, @NotNull T prefix) {
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        Intrinsics.checkNotNullParameter(prefix, (String)"prefix");
        ByteBuf buf = Unpooled.buffer();
        this.byteCodec.encode(input, buf);
        ByteBuffer buffer = ByteBuffer.allocate(buf.capacity());
        buf.readBytes(buffer);
        return DataResultKt.toDataResult(ExtensionsKt.success(ops.createByteList(buffer)));
    }

    @NotNull
    public <T> DataResult<Pair<A, T>> decode(@NotNull DynamicOps<T> ops, @NotNull T input) {
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        DataResult dataResult = ops.getByteBuffer(input).setLifecycle(Lifecycle.stable()).map(arg_0 -> ByteCodecCodec.decode$lambda$1(arg_0 -> ByteCodecCodec.decode$lambda$0(this, ops, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"map(...)");
        return dataResult;
    }

    private static final Pair decode$lambda$0(ByteCodecCodec this$0, DynamicOps $ops, ByteBuffer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ops, (String)"$ops");
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(it);
        return Pair.of((Object)this$0.byteCodec.decode(buf), (Object)$ops.empty());
    }

    private static final Pair decode$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }
}

