/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.entities;

import dev.mayaqq.cynosure.entities.PlayerLookupKt;
import dev.mayaqq.cynosure.mixin.accessor.TrackedEntityAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000eJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Ldev/mayaqq/cynosure/entities/PlayerLookup;", "", "<init>", "()V", "all", "", "Lnet/minecraft/server/level/ServerPlayer;", "server", "Lnet/minecraft/server/MinecraftServer;", "tracking", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/world/level/ChunkPos;", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "entity", "Lnet/minecraft/world/entity/Entity;", "cynosure-forge"})
@SourceDebugExtension(value={"SMAP\nPlayerLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerLookup.kt\ndev/mayaqq/cynosure/entities/PlayerLookup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1#2:60\n1557#3:61\n1628#3,3:62\n*S KotlinDebug\n*F\n+ 1 PlayerLookup.kt\ndev/mayaqq/cynosure/entities/PlayerLookup\n*L\n50#1:61\n50#1:62,3\n*E\n"})
public final class PlayerLookup {
    @NotNull
    public static final PlayerLookup INSTANCE = new PlayerLookup();

    private PlayerLookup() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<ServerPlayer> all(@NotNull MinecraftServer server) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Object object = server.getPlayerList();
        if (object != null) {
            PlayerList p0 = object;
            boolean bl = false;
            List list = p0.getPlayers();
            object = list;
            if (list != null) {
                collection = (Collection)object;
                return collection;
            }
        }
        collection = CollectionsKt.emptyList();
        return collection;
    }

    @NotNull
    public final Collection<ServerPlayer> tracking(@NotNull ServerLevel level, @NotNull ChunkPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List list = level.getChunkSource().chunkMap.getPlayers(pos, false);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        return list;
    }

    @NotNull
    public final Collection<ServerPlayer> tracking(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.tracking(level, new ChunkPos(pos));
    }

    @NotNull
    public final Collection<ServerPlayer> tracking(@NotNull BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        if (!blockEntity.hasLevel()) {
            return CollectionsKt.emptyList();
        }
        Level level = blockEntity.getLevel();
        if (!(level != null ? level.isClientSide : false)) {
            throw new IllegalStateException("Only supported on server worlds!".toString());
        }
        Level level2 = blockEntity.getLevel();
        Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level2;
        BlockPos blockPos = blockEntity.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return this.tracking(serverLevel, blockPos);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<ServerPlayer> tracking(@NotNull Entity entity) {
        Collection collection;
        Set<ServerPlayerConnection> set;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ChunkSource manager = entity.level().getChunkSource();
        if (!(manager instanceof ServerChunkCache)) throw new IllegalStateException("Only supported on server worlds!".toString());
        ChunkMap storage = ((ServerChunkCache)manager).chunkMap;
        Intrinsics.checkNotNull((Object)storage);
        TrackedEntityAccessor tracker = (TrackedEntityAccessor)PlayerLookupKt.getEntityMap(storage).get(entity.getId());
        if (tracker != null && (set = tracker.getPlayersTracking()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list = (List)((Object)set);
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                ServerPlayerConnection serverPlayerConnection = (ServerPlayerConnection)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(p0.getPlayer());
            }
            List p0 = (List)destination$iv$iv;
            boolean bl = false;
            list = Collections.unmodifiableList(p0);
            if (list != null) {
                collection = list;
                return collection;
            }
        }
        collection = CollectionsKt.emptyList();
        return collection;
    }
}

