/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.utils.file;

import dev.mayaqq.cynosure.Cynosure;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Ldev/mayaqq/cynosure/utils/file/GlobalStorage;", "", "<init>", "()V", "", "modid", "Ljava/nio/file/Path;", "getCache", "(Ljava/lang/String;)Ljava/nio/file/Path;", "getData", "README", "Ljava/lang/String;", "cache", "Ljava/nio/file/Path;", "data", "cynosure-fabric"})
@SourceDebugExtension(value={"SMAP\nGlobalStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalStorage.kt\ndev/mayaqq/cynosure/utils/file/GlobalStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class GlobalStorage {
    @NotNull
    public static final GlobalStorage INSTANCE;
    @NotNull
    private static final String README = "\n        This Directory was created by Cynosure Library Mod.\n        This directory is used to store global files of Minecraft Mods.\n    ";
    @NotNull
    private static final Path cache;
    @NotNull
    private static final Path data;

    private GlobalStorage() {
    }

    @NotNull
    public final Path getCache(@NotNull String modid) {
        Intrinsics.checkNotNullParameter((Object)modid, (String)"modid");
        Path path = cache.resolve(modid);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getData(@NotNull String modid) {
        Intrinsics.checkNotNullParameter((Object)modid, (String)"modid");
        Path path = data.resolve(modid);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    static {
        block15: {
            Object object;
            block20: {
                block19: {
                    String[] stringArray;
                    Object it;
                    Object object2;
                    block18: {
                        block17: {
                            block16: {
                                String[] stringArray2;
                                String os;
                                block14: {
                                    INSTANCE = new GlobalStorage();
                                    os = System.getProperty("os.name");
                                    Intrinsics.checkNotNull((Object)os);
                                    if (!StringsKt.startsWith$default((String)os, (String)"Windows", (boolean)false, (int)2, null)) break block14;
                                    stringArray2 = new String[]{".cynosure", "cache"};
                                    cache = Path.of(System.getenv("LOCALAPPDATA"), stringArray2);
                                    stringArray2 = new String[]{"cynosure", "data"};
                                    data = Path.of(System.getenv("LOCALAPPDATA"), stringArray2);
                                    break block15;
                                }
                                if (!StringsKt.startsWith$default((String)os, (String)"Mac OS X", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)os, (String)"Darwin", (boolean)false, (int)2, null)) break block16;
                                stringArray2 = new String[]{"Library", "Caches", "cynosure"};
                                cache = Path.of(System.getProperty("user.home"), stringArray2);
                                stringArray2 = new String[]{"Library", "Application Support", "cynosure"};
                                data = Path.of(System.getProperty("user.home"), stringArray2);
                                break block15;
                            }
                            object2 = System.getenv("XDG_CACHE_HOME");
                            if (object2 == null) break block17;
                            it = object2;
                            boolean bl = false;
                            stringArray = new String[]{"cynosure"};
                            Path path = Path.of((String)it, stringArray);
                            object2 = path;
                            if (path != null) break block18;
                        }
                        it = new String[]{".cache", "cynosure"};
                        Path path = Path.of(System.getProperty("user.home"), it);
                        object2 = path;
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                    }
                    cache = object2;
                    object = System.getenv("XDG_DATA_HOME");
                    if (object == null) break block19;
                    it = object;
                    boolean bl = false;
                    stringArray = new String[]{"cynosure"};
                    Path path = Path.of((String)it, stringArray);
                    object = path;
                    if (path != null) break block20;
                }
                String[] stringArray = new String[]{".local", "share", "cynosure"};
                Path path = Path.of(System.getProperty("user.home"), stringArray);
                object = path;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            }
            data = object;
        }
        try {
            Path readme;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(cache, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectory(cache, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectory(...)");
            }
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.notExists(data, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectory(data, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectory(...)");
            }
            Path path = readme = cache.resolve("README.txt");
            Intrinsics.checkNotNull((Object)path);
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                path = readme;
                Intrinsics.checkNotNull((Object)path);
                PathsKt.writeText$default((Path)path, (CharSequence)README, null, (OpenOption[])new OpenOption[0], (int)2, null);
            }
            path = readme = data.resolve("README.txt");
            Intrinsics.checkNotNull((Object)path);
            linkOptionArray3 = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                path = readme;
                Intrinsics.checkNotNull((Object)path);
                PathsKt.writeText$default((Path)path, (CharSequence)README, null, (OpenOption[])new OpenOption[0], (int)2, null);
            }
        }
        catch (IOException e) {
            Cynosure.INSTANCE.error("Failed to create global storage directories", e);
        }
    }
}

