/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.events;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import dev.mayaqq.cynosure.events.api.EventKt;
import dev.mayaqq.cynosure.events.block.BlockEvent;
import dev.mayaqq.cynosure.events.command.CommandExecuteEvent;
import dev.mayaqq.cynosure.events.command.CommandRegistrationEvent;
import dev.mayaqq.cynosure.events.entity.EntityCreatedEvent;
import dev.mayaqq.cynosure.events.entity.EntityTrackingEvent;
import dev.mayaqq.cynosure.events.entity.LivingEntityEvent;
import dev.mayaqq.cynosure.events.entity.MountEvent;
import dev.mayaqq.cynosure.events.entity.player.PlayerConnectionEvent;
import dev.mayaqq.cynosure.events.entity.player.PlayerTickEvent;
import dev.mayaqq.cynosure.events.entity.player.interaction.InteractionEvent;
import dev.mayaqq.cynosure.events.server.DataPackSyncEvent;
import dev.mayaqq.cynosure.events.server.ServerEvent;
import dev.mayaqq.cynosure.events.world.LevelEvent;
import dev.mayaqq.cynosure.internal.CynosureHooksImpl;
import dev.mayaqq.cynosure.items.extensions.CustomEntityItem;
import dev.mayaqq.cynosure.items.extensions.CustomFurnaceFuel;
import dev.mayaqq.cynosure.items.extensions.ItemExtension;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="cynosure")
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00ac\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H\u0007\u001a\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\tH\u0007\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u000bH\u0007\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\rH\u0007\u001a\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u000fH\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0011H\u0007\u001a\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0013H\u0007\u001a\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0015H\u0007\u001a\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0017H\u0007\u001a\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0019H\u0007\u001a\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u001bH\u0007\u001a\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u001dH\u0007\u001a\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u001fH\u0007\u001a\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020!H\u0007\u001a\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020#H\u0007\u001a\u0010\u0010$\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020#H\u0007\u001a\u0010\u0010%\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020&H\u0007\u001a\u0010\u0010'\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020(H\u0007\u001a\u0010\u0010)\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020*H\u0007\u001a\u0010\u0010+\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020,H\u0007\u001a\u0010\u0010-\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020.H\u0007\u001a\u0010\u0010/\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u000200H\u0007\u001a\u0010\u00101\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u000202H\u0007\u001a\u0010\u00103\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u000204H\u0007\u001a\u0010\u00105\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u000206H\u0007\u001a\u0010\u00107\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u000208H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"distContext", "", "onPlayerJoin", "", "event", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;", "onPlayerLeave", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedOutEvent;", "onEntityDeath", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "onBlockEvent", "Lnet/minecraftforge/event/level/BlockEvent;", "onPlayerInteract", "Lnet/minecraftforge/event/entity/player/PlayerInteractEvent;", "onAttackEntity", "Lnet/minecraftforge/event/entity/player/AttackEntityEvent;", "onEntityTick", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingTickEvent;", "onSyncDatapack", "Lnet/minecraftforge/event/OnDatapackSyncEvent;", "onEntityJoin", "Lnet/minecraftforge/event/entity/EntityJoinLevelEvent;", "onEntityMount", "Lnet/minecraftforge/event/entity/EntityMountEvent;", "onLoadWorld", "Lnet/minecraftforge/event/level/LevelEvent$Load;", "onUnloadWorld", "Lnet/minecraftforge/event/level/LevelEvent$Unload;", "onSaveWorld", "Lnet/minecraftforge/event/level/LevelEvent$Save;", "onTickWorld", "Lnet/minecraftforge/event/TickEvent$LevelTickEvent;", "onReloadListener", "Lnet/minecraftforge/event/AddReloadListenerEvent;", "furnaceFuel", "Lnet/minecraftforge/event/furnace/FurnaceFuelBurnTimeEvent;", "furnaceFuel1", "onServerStarting", "Lnet/minecraftforge/event/server/ServerAboutToStartEvent;", "onServerStarted", "Lnet/minecraftforge/event/server/ServerStartedEvent;", "onServerStopping", "Lnet/minecraftforge/event/server/ServerStoppingEvent;", "onServerStopped", "Lnet/minecraftforge/event/server/ServerStoppedEvent;", "onServerTick", "Lnet/minecraftforge/event/TickEvent$ServerTickEvent;", "onCommandRegistration", "Lnet/minecraftforge/event/RegisterCommandsEvent;", "onCommand", "Lnet/minecraftforge/event/CommandEvent;", "onPlayerTick", "Lnet/minecraftforge/event/TickEvent$PlayerTickEvent;", "onStartTracking", "Lnet/minecraftforge/event/entity/player/PlayerEvent$StartTracking;", "onStopTracking", "Lnet/minecraftforge/event/entity/player/PlayerEvent$StopTracking;", "cynosure-forge"})
@SourceDebugExtension(value={"SMAP\nForgeEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForgeEvents.kt\ndev/mayaqq/cynosure/events/ForgeEventsKt\n+ 2 ItemExtensions.kt\ndev/mayaqq/cynosure/items/extensions/ItemExtensionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,264:1\n35#2:265\n35#2:268\n216#3,2:266\n*S KotlinDebug\n*F\n+ 1 ForgeEvents.kt\ndev/mayaqq/cynosure/events/ForgeEventsKt\n*L\n134#1:265\n188#1:268\n182#1:266,2\n*E\n"})
public final class ForgeEventsKt {
    @NotNull
    private static final String distContext = FMLEnvironment.dist.isClient() ? "client" : "server";

    @SubscribeEvent
    public static final void onPlayerJoin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        EventKt.post$default(new PlayerConnectionEvent.Join((ServerPlayer)player), null, 1, null);
    }

    @SubscribeEvent
    public static final void onPlayerLeave(@NotNull PlayerEvent.PlayerLoggedOutEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        EventKt.post$default(new PlayerConnectionEvent.Leave((ServerPlayer)player), null, 1, null);
    }

    @SubscribeEvent
    public static final void onEntityDeath(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        DamageSource damageSource = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
        event.setCanceled(EventKt.post$default(new LivingEntityEvent.Death(livingEntity, damageSource), null, 1, null));
    }

    @SubscribeEvent
    public static final void onBlockEvent(@NotNull BlockEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BlockEvent blockEvent = event;
        if (blockEvent instanceof BlockEvent.BreakEvent) {
            LevelAccessor levelAccessor = ((BlockEvent.BreakEvent)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)levelAccessor, (String)"getLevel(...)");
            BlockState blockState = ((BlockEvent.BreakEvent)event).getState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getState(...)");
            BlockPos blockPos = ((BlockEvent.BreakEvent)event).getPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
            EventKt.post$default(new BlockEvent.Break(levelAccessor, blockState, blockPos, ((BlockEvent.BreakEvent)event).getPlayer()), null, (Object)event, null, 5, null);
        } else if (blockEvent instanceof BlockEvent.EntityPlaceEvent) {
            LevelAccessor levelAccessor = ((BlockEvent.EntityPlaceEvent)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)levelAccessor, (String)"getLevel(...)");
            BlockState blockState = ((BlockEvent.EntityPlaceEvent)event).getState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getState(...)");
            BlockPos blockPos = ((BlockEvent.EntityPlaceEvent)event).getPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
            EventKt.post$default(new BlockEvent.Place(levelAccessor, blockState, blockPos, ((BlockEvent.EntityPlaceEvent)event).getEntity()), null, (Object)event, null, 5, null);
        } else if (blockEvent instanceof BlockEvent.FluidPlaceBlockEvent) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static final void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        InteractionResult result;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PlayerInteractEvent playerInteractEvent = event;
        if (playerInteractEvent instanceof PlayerInteractEvent.RightClickBlock) {
            Level level = ((PlayerInteractEvent.RightClickBlock)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            Player player = ((PlayerInteractEvent.RightClickBlock)event).getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
            InteractionHand interactionHand = ((PlayerInteractEvent.RightClickBlock)event).getHand();
            Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
            BlockHitResult blockHitResult = ((PlayerInteractEvent.RightClickBlock)event).getHitVec();
            Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"getHitVec(...)");
            v4 = (InteractionResult)EventKt.post$default(new InteractionEvent.UseBlock(level, player, interactionHand, blockHitResult), null, (Object)event, null, 5, null);
        } else if (playerInteractEvent instanceof PlayerInteractEvent.LeftClickBlock) {
            Level level = ((PlayerInteractEvent.LeftClickBlock)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            Player player = ((PlayerInteractEvent.LeftClickBlock)event).getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
            InteractionHand interactionHand = ((PlayerInteractEvent.LeftClickBlock)event).getHand();
            Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
            BlockPos blockPos = ((PlayerInteractEvent.LeftClickBlock)event).getPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
            Direction direction = ((PlayerInteractEvent.LeftClickBlock)event).getFace();
            Intrinsics.checkNotNull((Object)direction);
            v4 = (InteractionResult)EventKt.post$default(new InteractionEvent.AttackBlock(level, player, interactionHand, blockPos, direction), null, (Object)event, null, 5, null);
        } else if (playerInteractEvent instanceof PlayerInteractEvent.EntityInteractSpecific) {
            Level level = ((PlayerInteractEvent.EntityInteractSpecific)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            Player player = ((PlayerInteractEvent.EntityInteractSpecific)event).getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
            InteractionHand interactionHand = ((PlayerInteractEvent.EntityInteractSpecific)event).getHand();
            Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
            Entity entity = ((PlayerInteractEvent.EntityInteractSpecific)event).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getTarget(...)");
            v4 = (InteractionResult)EventKt.post$default(new InteractionEvent.UseEntity(level, player, interactionHand, entity, ((PlayerInteractEvent.EntityInteractSpecific)event).getLocalPos(), InteractionEvent.UseEntity.Phase.SPECIFIC), null, (Object)event, null, 5, null);
        } else if (playerInteractEvent instanceof PlayerInteractEvent.EntityInteract) {
            Level level = ((PlayerInteractEvent.EntityInteract)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            Player player = ((PlayerInteractEvent.EntityInteract)event).getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
            InteractionHand interactionHand = ((PlayerInteractEvent.EntityInteract)event).getHand();
            Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
            Entity entity = ((PlayerInteractEvent.EntityInteract)event).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getTarget(...)");
            v4 = (InteractionResult)EventKt.post$default(new InteractionEvent.UseEntity(level, player, interactionHand, entity, null, InteractionEvent.UseEntity.Phase.GENERAL), null, (Object)event, null, 5, null);
        } else if (playerInteractEvent instanceof PlayerInteractEvent.RightClickItem) {
            Level level = ((PlayerInteractEvent.RightClickItem)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            Player player = ((PlayerInteractEvent.RightClickItem)event).getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
            InteractionHand interactionHand = ((PlayerInteractEvent.RightClickItem)event).getHand();
            Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
            v4 = (InteractionResult)EventKt.post$default(new InteractionEvent.UseItem(level, player, interactionHand), null, (Object)event, null, 5, null);
        } else {
            v4 = result = null;
        }
        if (result != null) {
            event.setCancellationResult(result);
            event.setCanceled(result.consumesAction());
        }
    }

    @SubscribeEvent
    public static final void onAttackEntity(@NotNull AttackEntityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Level level = event.getEntity().level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        InteractionHand interactionHand = event.getEntity().getUsedItemHand();
        Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getUsedItemHand(...)");
        Entity entity = event.getTarget();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getTarget(...)");
        InteractionResult interactionResult = (InteractionResult)EventKt.post$default(new InteractionEvent.AttackEntity(level, player, interactionHand, entity), null, (Object)event, null, 5, null);
        event.setCanceled(interactionResult != null ? interactionResult.consumesAction() : false);
    }

    @SubscribeEvent
    public static final void onEntityTick(@NotNull LivingEvent.LivingTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        event.setCanceled(EventKt.post$default(new LivingEntityEvent.Tick(livingEntity), null, (Object)event, null, 5, null));
    }

    @SubscribeEvent
    public static final void onSyncDatapack(@NotNull OnDatapackSyncEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getPlayer() != null) {
            ServerPlayer serverPlayer = event.getPlayer();
            Intrinsics.checkNotNull((Object)serverPlayer);
            EventKt.post$default(new DataPackSyncEvent((Player)serverPlayer, true), null, (Object)event, null, 5, null);
        } else {
            for (ServerPlayer player : event.getPlayerList().getPlayers()) {
                Intrinsics.checkNotNull((Object)player);
                EventKt.post$default(new DataPackSyncEvent((Player)player, false), null, (Object)event, null, 5, null);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static final void onEntityJoin(@NotNull EntityJoinLevelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        if (Intrinsics.areEqual(entity.getClass(), ItemEntity.class)) {
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.item.ItemEntity");
            ItemStack stack = ((ItemEntity)entity).getItem();
            Item item = stack.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
            Item $this$getExtension$iv = item;
            boolean $i$f$getExtension = false;
            CustomEntityItem customEntityItem = (CustomEntityItem)((ItemExtension)ItemExtension.Registry.getExtension(CustomEntityItem.class, $this$getExtension$iv));
            if (customEntityItem != null) {
                ItemEntity itemEntity = (ItemEntity)entity;
                Level level = event.getLevel();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
                Intrinsics.checkNotNull((Object)stack);
                Entity newEntity = customEntityItem.createItemEntity(itemEntity, level, stack);
                ((ItemEntity)entity).discard();
                event.setCanceled(true);
                BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(event.getLevel().isClientSide ? LogicalSide.CLIENT : LogicalSide.SERVER);
                executor.tell((Runnable)new TickTask(0, () -> ForgeEventsKt.onEntityJoin$lambda$0(event, newEntity)));
            }
        }
        Entity entity2 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"getEntity(...)");
        Level level = event.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        event.setCanceled(EventKt.post$default(new EntityCreatedEvent(entity2, level), null, 1, null));
    }

    @SubscribeEvent
    public static final void onEntityMount(@NotNull EntityMountEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntityMounting();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntityMounting(...)");
        MountEvent cynosureEvent = new MountEvent(entity, event.getEntityBeingMounted(), event.isMounting());
        EventKt.post$default(cynosureEvent, null, 1, null);
        if (cynosureEvent.isCancelled()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static final void onLoadWorld(@NotNull LevelEvent.Load event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LevelAccessor levelAccessor = event.getLevel();
        Intrinsics.checkNotNull((Object)levelAccessor, (String)"null cannot be cast to non-null type net.minecraft.world.level.Level");
        EventKt.post$default(new LevelEvent.Load((Level)levelAccessor), null, (Object)distContext, null, 5, null);
    }

    @SubscribeEvent
    public static final void onUnloadWorld(@NotNull LevelEvent.Unload event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LevelAccessor levelAccessor = event.getLevel();
        Intrinsics.checkNotNull((Object)levelAccessor, (String)"null cannot be cast to non-null type net.minecraft.world.level.Level");
        EventKt.post$default(new LevelEvent.Unload((Level)levelAccessor), null, (Object)distContext, null, 5, null);
    }

    @SubscribeEvent
    public static final void onSaveWorld(@NotNull LevelEvent.Save event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LevelAccessor levelAccessor = event.getLevel();
        Intrinsics.checkNotNull((Object)levelAccessor, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        EventKt.post$default(new LevelEvent.Save((ServerLevel)levelAccessor), null, 1, null);
    }

    @SubscribeEvent
    public static final void onTickWorld(@NotNull TickEvent.LevelTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TickEvent.Phase phase = event.phase;
        Intrinsics.checkNotNull((Object)phase);
        LevelEvent e = switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
            case 1 -> {
                Level v1 = event.level;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"level");
                yield new LevelEvent.BeginTick(v1);
            }
            case 2 -> {
                Level v3 = event.level;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"level");
                yield new LevelEvent.EndTick(v3);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        EventKt.post$default(e, null, (Object)distContext, null, 5, null);
    }

    @SubscribeEvent
    public static final void onReloadListener(@NotNull AddReloadListenerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Map<ResourceLocation, PreparableReloadListener> $this$forEach$iv = CynosureHooksImpl.INSTANCE.getSERVER_RELOAD_LISTENERS$cynosure_forge();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ResourceLocation, PreparableReloadListener>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, PreparableReloadListener> element$iv;
            Map.Entry<ResourceLocation, PreparableReloadListener> entry = element$iv = iterator.next();
            boolean bl = false;
            PreparableReloadListener listener = entry.getValue();
            event.addListener(listener);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static final void furnaceFuel(@NotNull FurnaceFuelBurnTimeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Item item = event.getItemStack().getItem();
        Intrinsics.checkNotNull((Object)item);
        Item $this$getExtension$iv = item;
        boolean $i$f$getExtension = false;
        CustomFurnaceFuel customBurnTime = (CustomFurnaceFuel)((ItemExtension)ItemExtension.Registry.getExtension(CustomFurnaceFuel.class, $this$getExtension$iv));
        if (customBurnTime != null) {
            ItemStack itemStack = event.getItemStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
            Integer n = customBurnTime.getItemBurnTime(itemStack, event.getRecipeType());
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                event.setBurnTime(it);
                event.setCanceled(true);
            }
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static final void furnaceFuel1(@NotNull FurnaceFuelBurnTimeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Item item = event.getItemStack().getItem();
        if (CynosureHooksImpl.INSTANCE.getBURN_TIME_BY_ITEM$cynosure_forge().containsKey((Object)item)) {
            event.setBurnTime(CynosureHooksImpl.INSTANCE.getBURN_TIME_BY_ITEM$cynosure_forge().getInt((Object)item));
        }
    }

    @SubscribeEvent
    public static final void onServerStarting(@NotNull ServerAboutToStartEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        EventKt.post$default(new ServerEvent.Starting(minecraftServer), null, (Object)event, null, 5, null);
    }

    @SubscribeEvent
    public static final void onServerStarted(@NotNull ServerStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        EventKt.post$default(new ServerEvent.Started(minecraftServer), null, (Object)event, null, 5, null);
    }

    @SubscribeEvent
    public static final void onServerStopping(@NotNull ServerStoppingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        EventKt.post$default(new ServerEvent.Stopping(minecraftServer), null, (Object)event, null, 5, null);
    }

    @SubscribeEvent
    public static final void onServerStopped(@NotNull ServerStoppedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        EventKt.post$default(new ServerEvent.Stopped(minecraftServer), null, (Object)event, null, 5, null);
    }

    @SubscribeEvent
    public static final void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TickEvent.Phase phase = event.phase;
        Intrinsics.checkNotNull((Object)phase);
        switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
            case 1: {
                MinecraftServer minecraftServer = event.getServer();
                Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
                boolean bl = EventKt.post$default(new ServerEvent.BeginTick(minecraftServer), null, (Object)event, null, 5, null);
                break;
            }
            case 2: {
                MinecraftServer minecraftServer = event.getServer();
                Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
                boolean bl = EventKt.post$default(new ServerEvent.EndTick(minecraftServer), null, (Object)event, null, 5, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @SubscribeEvent
    public static final void onCommandRegistration(@NotNull RegisterCommandsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommandDispatcher commandDispatcher = event.getDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)commandDispatcher, (String)"getDispatcher(...)");
        CommandBuildContext commandBuildContext = event.getBuildContext();
        Intrinsics.checkNotNullExpressionValue((Object)commandBuildContext, (String)"getBuildContext(...)");
        Commands.CommandSelection commandSelection = event.getCommandSelection();
        Intrinsics.checkNotNullExpressionValue((Object)commandSelection, (String)"getCommandSelection(...)");
        EventKt.post$default(new CommandRegistrationEvent((CommandDispatcher<CommandSourceStack>)commandDispatcher, commandBuildContext, commandSelection), null, 1, null);
    }

    @SubscribeEvent
    public static final void onCommand(@NotNull CommandEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ParseResults parseResults = event.getParseResults();
        Intrinsics.checkNotNullExpressionValue((Object)parseResults, (String)"getParseResults(...)");
        CommandExecuteEvent evt = new CommandExecuteEvent((ParseResults<CommandSourceStack>)parseResults, event.getException());
        event.setCanceled(EventKt.post$default(evt, null, 1, null));
        event.setException(evt.getException());
        event.setParseResults(evt.getParseResults());
    }

    @SubscribeEvent
    public static final void onPlayerTick(@NotNull TickEvent.PlayerTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TickEvent.Phase phase = event.phase;
        switch (phase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
            case 1: {
                Player player = event.player;
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
                boolean bl = EventKt.post$default(new PlayerTickEvent.Begin(player), null, (Object)event, null, 5, null);
                break;
            }
            case 2: {
                Player player = event.player;
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
                boolean bl = EventKt.post$default(new PlayerTickEvent.End(player), null, (Object)event, null, 5, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @SubscribeEvent
    public static final void onStartTracking(@NotNull PlayerEvent.StartTracking event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity() instanceof ServerPlayer) {
            Entity entity = event.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getTarget(...)");
            Player player = event.getEntity();
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            EventKt.post$default(new EntityTrackingEvent.Start(entity, (ServerPlayer)player), null, 1, null);
        }
    }

    @SubscribeEvent
    public static final void onStopTracking(@NotNull PlayerEvent.StopTracking event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity() instanceof ServerPlayer) {
            Entity entity = event.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getTarget(...)");
            Player player = event.getEntity();
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            EventKt.post$default(new EntityTrackingEvent.Start(entity, (ServerPlayer)player), null, 1, null);
        }
    }

    private static final void onEntityJoin$lambda$0(EntityJoinLevelEvent $event, Entity $newEntity) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)$newEntity, (String)"$newEntity");
        $event.getLevel().addFreshEntity($newEntity);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TickEvent.Phase.values().length];
            try {
                nArray[TickEvent.Phase.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TickEvent.Phase.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

