/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.forge.mixin;

import com.google.common.collect.ImmutableMap;
import dev.mayaqq.cynosure.events.api.MainBus;
import dev.mayaqq.cynosure.events.world.LoottableEvents;
import dev.mayaqq.cynosure.loot.LootilsKt;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LootDataManager.class})
public class LootDataManagerMixin {
    @Shadow
    private Map<LootDataId<?>, ?> elements;

    @Inject(method={"reload"}, at={@At(value="RETURN")}, cancellable=true)
    private void reload(PreparableReloadListener.PreparationBarrier barrier, ResourceManager manager, ProfilerFiller prepProfiler, ProfilerFiller ApplyProfiler, Executor prepExecutor, Executor ApplyExecutor, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        LootDataManager lootManager = (LootDataManager)this;
        cir.setReturnValue((Object)((CompletableFuture)cir.getReturnValue()).thenRun(() -> this.cynosure$applyCynosureLootTables(manager, lootManager)));
    }

    @Unique
    private void cynosure$applyCynosureLootTables(ResourceManager resourceManager, LootDataManager lootManager) {
        ImmutableMap.Builder newTables = ImmutableMap.builder();
        this.elements.forEach((dataKey, entry) -> {
            if (dataKey == LootDataManager.EMPTY_LOOT_TABLE_KEY) {
                newTables.put(dataKey, entry);
                return;
            }
            if (!(entry instanceof LootTable)) {
                newTables.put(dataKey, entry);
                return;
            }
            LootTable table = (LootTable)entry;
            LoottableEvents.Replace replace = new LoottableEvents.Replace(resourceManager, lootManager, dataKey.location(), table);
            MainBus.INSTANCE.post(replace);
            LootTable replacement = (LootTable)replace.getResult();
            if (replacement != null) {
                table = replacement;
            }
            LootTable.Builder builder = LootilsKt.copy(table);
            MainBus.INSTANCE.post(new LoottableEvents.Modify(resourceManager, lootManager, dataKey.location(), builder));
            newTables.put(dataKey, (Object)builder.build());
        });
        this.elements = newTables.build();
        MainBus.INSTANCE.post(new LoottableEvents.AllLoaded(resourceManager, lootManager));
    }
}

