/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.transactions.internal;

import dev.mayaqq.cynosure.transactions.DelicateTransactionApi;
import dev.mayaqq.cynosure.transactions.InnerCloseListener;
import dev.mayaqq.cynosure.transactions.OuterCloseListener;
import dev.mayaqq.cynosure.transactions.Transaction;
import dev.mayaqq.cynosure.transactions.TransactionResult;
import dev.mayaqq.cynosure.utils.result.ExtensionsKt;
import dev.mayaqq.cynosure.utils.result.OtherKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0018\u00010\u0007R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0018\u00010\u0007R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Ldev/mayaqq/cynosure/transactions/internal/TransactionManager;", "", "<init>", "()V", "thread", "Ljava/lang/Thread;", "outerTransaction", "Ldev/mayaqq/cynosure/transactions/internal/TransactionManager$LinkedTransaction;", "currentTransaction", "outerListeners", "", "Ldev/mayaqq/cynosure/transactions/OuterCloseListener;", "lifecycle", "Ldev/mayaqq/cynosure/transactions/Transaction$Lifecycle;", "getLifecycle", "()Ldev/mayaqq/cynosure/transactions/Transaction$Lifecycle;", "depth", "", "getDepth", "()I", "openOuter", "Ldev/mayaqq/cynosure/transactions/Transaction;", "validateThread", "", "getCurrent", "LinkedTransaction", "cynosure-forge"})
@SourceDebugExtension(value={"SMAP\nTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionManager.kt\ndev/mayaqq/cynosure/transactions/internal/TransactionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class TransactionManager {
    @NotNull
    private final Thread thread;
    @Nullable
    private LinkedTransaction outerTransaction;
    @Nullable
    private LinkedTransaction currentTransaction;
    @NotNull
    private final List<OuterCloseListener> outerListeners;

    public TransactionManager() {
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread(...)");
        this.thread = thread;
        this.outerListeners = new ArrayList();
    }

    @NotNull
    public final Transaction.Lifecycle getLifecycle() {
        Object object = this.currentTransaction;
        if (object == null || (object = object.getLifecycle()) == null) {
            object = Transaction.Lifecycle.CLOSED;
        }
        return object;
    }

    public final int getDepth() {
        int n;
        if (this.currentTransaction == null) {
            n = -1;
        } else {
            LinkedTransaction linkedTransaction = this.currentTransaction;
            Intrinsics.checkNotNull((Object)linkedTransaction);
            n = linkedTransaction.getDepth();
        }
        return n;
    }

    @NotNull
    public final Transaction openOuter() {
        LinkedTransaction transaction;
        if (!(this.outerTransaction == null)) {
            boolean bl = false;
            String string = "Attempted to open outer transaction inside another transaction";
            throw new IllegalStateException(string.toString());
        }
        this.outerTransaction = transaction = new LinkedTransaction(0, null);
        this.currentTransaction = transaction;
        transaction.setLifecycle(Transaction.Lifecycle.OPEN);
        return transaction;
    }

    public final void validateThread() {
        Thread current = Thread.currentThread();
        if (!Intrinsics.areEqual((Object)current, (Object)this.thread)) {
            boolean bl = false;
            String string = "Attempted to access transation from thread " + this.thread.getName() + " on " + current.getName();
            throw new IllegalStateException(string.toString());
        }
    }

    @DelicateTransactionApi
    @Nullable
    public final Transaction getCurrent() {
        LinkedTransaction linkedTransaction;
        this.validateThread();
        LinkedTransaction linkedTransaction2 = this.currentTransaction;
        if (linkedTransaction2 != null) {
            LinkedTransaction linkedTransaction3;
            LinkedTransaction it = linkedTransaction3 = linkedTransaction2;
            boolean bl = false;
            linkedTransaction = it.getLifecycle() == Transaction.Lifecycle.OPEN ? linkedTransaction3 : null;
        } else {
            linkedTransaction = null;
        }
        return linkedTransaction;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0018\u00010\u0000R\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0012H\u0014J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001bH\u0016J\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u0003H\u0096\u0002J\u0006\u0010\u001e\u001a\u00020\u0001J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\b\u0018\u00010\u0000R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Ldev/mayaqq/cynosure/transactions/internal/TransactionManager$LinkedTransaction;", "Ldev/mayaqq/cynosure/transactions/Transaction;", "nestingDepth", "", "parentTransaction", "Ldev/mayaqq/cynosure/transactions/internal/TransactionManager;", "<init>", "(Ldev/mayaqq/cynosure/transactions/internal/TransactionManager;ILdev/mayaqq/cynosure/transactions/internal/TransactionManager$LinkedTransaction;)V", "listeners", "", "Ldev/mayaqq/cynosure/transactions/InnerCloseListener;", "lifecycle", "Ldev/mayaqq/cynosure/transactions/Transaction$Lifecycle;", "getLifecycle", "()Ldev/mayaqq/cynosure/transactions/Transaction$Lifecycle;", "setLifecycle", "(Ldev/mayaqq/cynosure/transactions/Transaction$Lifecycle;)V", "value", "Ldev/mayaqq/cynosure/transactions/TransactionResult;", "result", "getResult", "()Ldev/mayaqq/cynosure/transactions/TransactionResult;", "close", "", "addCloseListener", "listener", "addOuterCloseListener", "Ldev/mayaqq/cynosure/transactions/OuterCloseListener;", "get", "depth", "openNested", "validateCurrentTransaction", "validateOpen", "cynosure-forge"})
    @SourceDebugExtension(value={"SMAP\nTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionManager.kt\ndev/mayaqq/cynosure/transactions/internal/TransactionManager$LinkedTransaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
    public final class LinkedTransaction
    extends Transaction {
        @Nullable
        private final LinkedTransaction parentTransaction;
        private List<InnerCloseListener> listeners;
        @NotNull
        private Transaction.Lifecycle lifecycle;
        @NotNull
        private TransactionResult result;

        public LinkedTransaction(@Nullable int nestingDepth, LinkedTransaction parentTransaction) {
            super(nestingDepth);
            this.parentTransaction = parentTransaction;
            this.lifecycle = Transaction.Lifecycle.CLOSED;
            this.result = TransactionResult.ABORTED;
        }

        @Override
        @NotNull
        public Transaction.Lifecycle getLifecycle() {
            return this.lifecycle;
        }

        public void setLifecycle(@NotNull Transaction.Lifecycle lifecycle) {
            Intrinsics.checkNotNullParameter((Object)((Object)lifecycle), (String)"<set-?>");
            this.lifecycle = lifecycle;
        }

        @NotNull
        public final TransactionResult getResult() {
            return this.result;
        }

        @Override
        protected void close(@NotNull TransactionResult result) {
            RuntimeException it;
            RuntimeException runtimeException;
            Object object;
            int index;
            Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"result");
            this.validateCurrentTransaction();
            this.validateOpen();
            this.setLifecycle(Transaction.Lifecycle.CLOSING);
            this.result = result;
            Object closeResult = null;
            closeResult = OtherKt.getUNIT(Result.Companion);
            if (this.listeners != null) {
                List<InnerCloseListener> list = this.listeners;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"listeners");
                    list = null;
                }
                for (index = (v28746).size(); -1 < index; --index) {
                    Object $this$close_u24lambda_u240;
                    List<InnerCloseListener> list2 = this.listeners;
                    if (list2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"listeners");
                        list2 = null;
                    }
                    object = list2.get(index);
                    try {
                        $this$close_u24lambda_u240 = object;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dev.mayaqq.cynosure.transactions.TransactionContext");
                        $this$close_u24lambda_u240.onClose(this, result);
                        $this$close_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl) {
                        $this$close_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object = $this$close_u24lambda_u240;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable == null) continue;
                    Object it2 = $this$close_u24lambda_u240 = throwable;
                    boolean bl = false;
                    Throwable throwable2 = Result.exceptionOrNull-impl((Object)closeResult);
                    if (throwable2 == null) {
                        it = runtimeException = new RuntimeException("Transaction error");
                        boolean bl2 = false;
                        closeResult = ExtensionsKt.failure(it);
                        throwable2 = runtimeException;
                    }
                    ExceptionsKt.addSuppressed((Throwable)throwable2, (Throwable)it2);
                }
                List<InnerCloseListener> list3 = this.listeners;
                if (list3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"listeners");
                    list3 = null;
                }
                list3.clear();
            }
            if (this == TransactionManager.this.outerTransaction) {
                this.setLifecycle(Transaction.Lifecycle.OUTER_CLOSING);
                for (index = TransactionManager.this.outerListeners.size(); -1 < index; --index) {
                    Object object2;
                    object = TransactionManager.this.outerListeners.get(index);
                    try {
                        OuterCloseListener $this$close_u24lambda_u243 = (OuterCloseListener)object;
                        boolean bl = false;
                        $this$close_u24lambda_u243.onOuterClose(result);
                        object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object = object2;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable == null) continue;
                    Object it3 = object2 = throwable;
                    boolean bl = false;
                    Throwable throwable3 = Result.exceptionOrNull-impl((Object)closeResult);
                    if (throwable3 == null) {
                        it = runtimeException = new RuntimeException("Transaction error");
                        boolean bl3 = false;
                        closeResult = ExtensionsKt.failure(it);
                        throwable3 = runtimeException;
                    }
                    ExceptionsKt.addSuppressed((Throwable)throwable3, (Throwable)it3);
                }
                TransactionManager.this.outerTransaction = null;
                TransactionManager.this.outerListeners.clear();
            }
            TransactionManager.this.currentTransaction = this.parentTransaction;
            this.setLifecycle(Transaction.Lifecycle.CLOSED);
            Object object3 = closeResult;
            ResultKt.throwOnFailure((Object)object3);
        }

        @Override
        public void addCloseListener(@NotNull InnerCloseListener listener) {
            List<InnerCloseListener> list;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            TransactionManager.this.validateThread();
            this.validateOpen();
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            if ((list = this.listeners) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listeners");
                list = null;
            }
            list.add(listener);
        }

        @Override
        public void addOuterCloseListener(@NotNull OuterCloseListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            TransactionManager.this.validateThread();
            TransactionManager.this.outerListeners.add(listener);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Transaction get(int depth) {
            Transaction transaction;
            TransactionManager.this.validateThread();
            int n = depth;
            if (n == this.getDepth()) {
                transaction = this;
            } else if (n == this.getDepth() - 1) {
                transaction = this.parentTransaction;
            } else {
                void var3_3;
                LinkedTransaction transaction2 = this.parentTransaction;
                while (transaction2 != null && transaction2.getDepth() != depth) {
                    transaction2 = transaction2.parentTransaction;
                }
                transaction = (Transaction)var3_3;
            }
            return transaction;
        }

        @NotNull
        public final Transaction openNested() {
            TransactionManager.this.validateThread();
            this.validateCurrentTransaction();
            LinkedTransaction transaction = new LinkedTransaction(this.getDepth() + 1, this);
            TransactionManager.this.currentTransaction = transaction;
            return transaction;
        }

        private final void validateCurrentTransaction() {
            TransactionManager.this.validateThread();
            boolean bl = this == TransactionManager.this.currentTransaction;
            TransactionManager transactionManager = TransactionManager.this;
            if (!bl) {
                boolean bl2 = false;
                LinkedTransaction linkedTransaction = transactionManager.currentTransaction;
                String string = "Attempted to call transaction function on a transaction with depth " + this.getDepth() + " but current depth is " + (linkedTransaction != null ? Integer.valueOf(linkedTransaction.getDepth()) : null);
                throw new IllegalStateException(string.toString());
            }
        }

        private final void validateOpen() {
            if (!(this.getLifecycle() == Transaction.Lifecycle.OPEN)) {
                boolean bl = false;
                String string = "Attempted to access transaction functions on a " + this.getLifecycle() + " transaction";
                throw new IllegalStateException(string.toString());
            }
        }
    }
}

