/*
 * Decompiled with CFR 0.152.
 */
package com.sugarcanepp.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sugarcanepp.SugarCanePlusPlus;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class SugarCaneCommand {
    private static final SuggestionProvider<class_2168> PRESET_SUGGESTIONS = (context, builder) -> class_2172.method_9253((String[])new String[]{"slow", "normal", "fast", "ultra"}, (SuggestionsBuilder)builder);

    private static boolean hasPermission(class_2168 source, String permission) {
        return source.method_9259(2);
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sugarcane").then(class_2170.method_9247((String)"help").executes(SugarCaneCommand::help))).then(class_2170.method_9247((String)"info").executes(SugarCaneCommand::info))).then(class_2170.method_9247((String)"getspeed").executes(SugarCaneCommand::getSpeed))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setspeed").requires(source -> SugarCaneCommand.hasPermission(source, "sugarcane.command.setspeed"))).then(class_2170.method_9244((String)"multiplier", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1, (double)100.0)).executes(SugarCaneCommand::setSpeed)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setmaxheight").requires(source -> SugarCaneCommand.hasPermission(source, "sugarcane.command.setmaxheight"))).then(class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).executes(SugarCaneCommand::setMaxHeight)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"preset").requires(source -> SugarCaneCommand.hasPermission(source, "sugarcane.command.preset"))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(PRESET_SUGGESTIONS).executes(SugarCaneCommand::preset)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"toggle").requires(source -> SugarCaneCommand.hasPermission(source, "sugarcane.command.toggle"))).executes(SugarCaneCommand::toggle))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(source -> SugarCaneCommand.hasPermission(source, "sugarcane.command.reset"))).executes(SugarCaneCommand::reset))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> SugarCaneCommand.hasPermission(source, "sugarcane.command.reload"))).executes(SugarCaneCommand::reload))).executes(SugarCaneCommand::help));
    }

    private static int help(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76\u00a7l=== SugarCane++ Commands ===\n\u00a7e/sugarcane help \u00a77- Show this help\n\u00a7e/sugarcane info \u00a77- Show current settings\n\u00a7e/sugarcane getspeed \u00a77- View growth speed\n\u00a7a/sugarcane setspeed <multiplier> \u00a77- Set speed (0.1-100.0)\n\u00a7a/sugarcane setmaxheight <height> \u00a77- Set max height (1-256)\n\u00a7a/sugarcane preset <name> \u00a77- Use preset (slow/normal/fast/ultra)\n\u00a7a/sugarcane toggle \u00a77- Enable/disable mod\n\u00a7a/sugarcane reset \u00a77- Reset to defaults\n\u00a7a/sugarcane reload \u00a77- Reload config file\n\u00a77(\u00a7a\u00a77 = requires OP permission)\n"), false);
        return 1;
    }

    private static int info(CommandContext<class_2168> context) {
        boolean enabled = SugarCanePlusPlus.getConfig().isEnabled();
        double multiplier = SugarCanePlusPlus.getConfig().getGrowthSpeedMultiplier();
        int maxHeight = SugarCanePlusPlus.getConfig().getMaxHeight();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a76\u00a7l=== SugarCane++ Info ===\n\u00a77Status: %s\n\u00a77Growth Speed: \u00a7e%.1fx\n\u00a77Max Height: \u00a7e%d blocks\n\u00a77Config: \u00a7econfig/SugarCane++/config.json\n", enabled ? "\u00a7aEnabled" : "\u00a7cDisabled", multiplier, maxHeight)), false);
        return 1;
    }

    private static int setSpeed(CommandContext<class_2168> context) {
        double multiplier = DoubleArgumentType.getDouble(context, (String)"multiplier");
        SugarCanePlusPlus.getConfig().setGrowthSpeedMultiplier(multiplier);
        SugarCanePlusPlus.getConfig().load();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7a[SugarCane++] Growth speed set to: \u00a7e" + multiplier + "x")), true);
        SugarCanePlusPlus.LOGGER.info("Growth speed changed to " + multiplier + "x by " + ((class_2168)context.getSource()).method_9214());
        return 1;
    }

    private static int setMaxHeight(CommandContext<class_2168> context) {
        int height = IntegerArgumentType.getInteger(context, (String)"height");
        SugarCanePlusPlus.getConfig().setMaxHeight(height);
        SugarCanePlusPlus.getConfig().load();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7a[SugarCane++] Max height set to: \u00a7e" + height + " blocks")), true);
        SugarCanePlusPlus.LOGGER.info("Max height changed to " + height + " by " + ((class_2168)context.getSource()).method_9214());
        return 1;
    }

    private static int preset(CommandContext<class_2168> context) {
        double multiplier;
        String presetName;
        switch (presetName = ((String)context.getArgument("name", String.class)).toLowerCase()) {
            case "slow": {
                multiplier = 1.5;
                break;
            }
            case "normal": {
                multiplier = 3.0;
                break;
            }
            case "fast": {
                multiplier = 5.0;
                break;
            }
            case "ultra": {
                multiplier = 10.0;
                break;
            }
            default: {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cUnknown preset! Use: slow, normal, fast, or ultra"));
                return 0;
            }
        }
        SugarCanePlusPlus.getConfig().setGrowthSpeedMultiplier(multiplier);
        SugarCanePlusPlus.getConfig().load();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7a[SugarCane++] Preset '\u00a7e" + presetName + "\u00a7a' applied (\u00a7e" + multiplier + "x\u00a7a)")), true);
        SugarCanePlusPlus.LOGGER.info("Preset '" + presetName + "' applied by " + ((class_2168)context.getSource()).method_9214());
        return 1;
    }

    private static int toggle(CommandContext<class_2168> context) {
        boolean currentState = SugarCanePlusPlus.getConfig().isEnabled();
        boolean newState = !currentState;
        SugarCanePlusPlus.getConfig().setEnabled(newState);
        SugarCanePlusPlus.getConfig().load();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7a[SugarCane++] Mod is now: " + (newState ? "\u00a7aEnabled" : "\u00a7cDisabled"))), true);
        SugarCanePlusPlus.LOGGER.info("Mod toggled to " + (newState ? "enabled" : "disabled") + " by " + ((class_2168)context.getSource()).method_9214());
        return 1;
    }

    private static int reset(CommandContext<class_2168> context) {
        SugarCanePlusPlus.getConfig().setEnabled(true);
        SugarCanePlusPlus.getConfig().setGrowthSpeedMultiplier(3.0);
        SugarCanePlusPlus.getConfig().setMaxHeight(3);
        SugarCanePlusPlus.getConfig().load();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7a[SugarCane++] Reset to defaults: \u00a7eEnabled, 3.0x speed, 3 blocks height"), true);
        SugarCanePlusPlus.LOGGER.info("Config reset to defaults by " + ((class_2168)context.getSource()).method_9214());
        return 1;
    }

    private static int getSpeed(CommandContext<class_2168> context) {
        double multiplier = SugarCanePlusPlus.getConfig().getGrowthSpeedMultiplier();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aCurrent sugar cane growth speed: \u00a7e" + multiplier + "x")), false);
        return 1;
    }

    private static int reload(CommandContext<class_2168> context) {
        SugarCanePlusPlus.getConfig().load();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7a[SugarCane++] Config reloaded! Multiplier: \u00a7e" + SugarCanePlusPlus.getConfig().getGrowthSpeedMultiplier() + "x\u00a7a, Max Height: \u00a7e" + SugarCanePlusPlus.getConfig().getMaxHeight())), true);
        SugarCanePlusPlus.LOGGER.info("Config manually reloaded by " + ((class_2168)context.getSource()).method_9214());
        return 1;
    }
}

