/*
 * Decompiled with CFR 0.152.
 */
package com.sugarcanepp.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sugarcanepp.SugarCanePlusPlus;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = Paths.get("config", "SugarCane++");
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("config.json");
    private boolean enabled = true;
    private double growthSpeedMultiplier = 3.0;
    private int maxHeight = 3;
    private long lastModified = 0L;
    private WatchService watchService;
    private ScheduledExecutorService executor;

    public ModConfig() {
        this.ensureConfigDirectory();
        this.startFileWatcher();
    }

    private void ensureConfigDirectory() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
                SugarCanePlusPlus.LOGGER.info("Created config directory: " + String.valueOf(CONFIG_DIR));
            }
        }
        catch (IOException e) {
            SugarCanePlusPlus.LOGGER.error("Failed to create config directory", (Throwable)e);
        }
    }

    public void load() {
        try {
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                this.save();
                SugarCanePlusPlus.LOGGER.info("Created default config file");
                return;
            }
            String content = Files.readString(CONFIG_FILE);
            JsonObject json = (JsonObject)GSON.fromJson(content, JsonObject.class);
            if (json.has("enabled")) {
                this.enabled = json.get("enabled").getAsBoolean();
            }
            if (json.has("growthSpeedMultiplier")) {
                double multiplier = json.get("growthSpeedMultiplier").getAsDouble();
                this.growthSpeedMultiplier = Math.max(0.1, Math.min(100.0, multiplier));
                if (multiplier != this.growthSpeedMultiplier) {
                    SugarCanePlusPlus.LOGGER.warn("Growth speed multiplier " + multiplier + " was out of range, clamped to " + this.growthSpeedMultiplier);
                }
            }
            if (json.has("maxHeight")) {
                int height = json.get("maxHeight").getAsInt();
                this.maxHeight = Math.max(1, Math.min(256, height));
                if (height != this.maxHeight) {
                    SugarCanePlusPlus.LOGGER.warn("Max height " + height + " was out of range, clamped to " + this.maxHeight);
                }
            }
            this.lastModified = Files.getLastModifiedTime(CONFIG_FILE, new LinkOption[0]).toMillis();
            SugarCanePlusPlus.LOGGER.info("Loaded config: enabled=" + this.enabled + ", multiplier=" + this.growthSpeedMultiplier + "x, maxHeight=" + this.maxHeight);
        }
        catch (Exception e) {
            SugarCanePlusPlus.LOGGER.error("Failed to load config, using defaults", (Throwable)e);
        }
    }

    public void save() {
        try {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("growthSpeedMultiplier", (Number)this.growthSpeedMultiplier);
            json.addProperty("maxHeight", (Number)this.maxHeight);
            json.addProperty("_comment1", "Set 'enabled' to false to disable the mod without uninstalling");
            json.addProperty("_comment2", "Growth speed multiplier: 0.1 to 100.0 (Default: 3.0 = 3x speed)");
            json.addProperty("_comment3", "Max height: 1 to 256 blocks (Vanilla: 3)");
            Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((JsonElement)json), new OpenOption[0]);
            this.lastModified = Files.getLastModifiedTime(CONFIG_FILE, new LinkOption[0]).toMillis();
            SugarCanePlusPlus.LOGGER.info("Saved config file");
        }
        catch (IOException e) {
            SugarCanePlusPlus.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    private void startFileWatcher() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(() -> {
            try {
                long currentModified;
                if (Files.exists(CONFIG_FILE, new LinkOption[0]) && (currentModified = Files.getLastModifiedTime(CONFIG_FILE, new LinkOption[0]).toMillis()) > this.lastModified) {
                    SugarCanePlusPlus.LOGGER.info("Config file changed externally, auto-reloading...");
                    this.load();
                    SugarCanePlusPlus.LOGGER.info("Config auto-reloaded! Current multiplier: " + this.growthSpeedMultiplier + "x");
                }
            }
            catch (Exception e) {
                SugarCanePlusPlus.LOGGER.error("Error checking config file", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.save();
    }

    public double getGrowthSpeedMultiplier() {
        return this.growthSpeedMultiplier;
    }

    public void setGrowthSpeedMultiplier(double multiplier) {
        this.growthSpeedMultiplier = Math.max(0.1, Math.min(100.0, multiplier));
        this.save();
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int height) {
        this.maxHeight = Math.max(1, Math.min(256, height));
        this.save();
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                SugarCanePlusPlus.LOGGER.error("Error closing watch service", (Throwable)e);
            }
        }
    }
}

