/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.components;

import com.mojang.serialization.Codec;
import de.ellpeck.actuallyadditions.mod.components.LastXY;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ActuallyComponents {
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"actuallyadditions");
    public static final Supplier<DataComponentType<Integer>> ENERGY_STORAGE = DATA_COMPONENT_TYPES.register("energy", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<ResourceLocation>> ITEM_TAG = DATA_COMPONENT_TYPES.register("item_tag", () -> DataComponentType.builder().persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Boolean>> AUTO_INSERT = DATA_COMPONENT_TYPES.register("auto_insert", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> PULSE_MODE = DATA_COMPONENT_TYPES.register("pulse_mode", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> WHITELIST = DATA_COMPONENT_TYPES.register("whitelist", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> MOD = DATA_COMPONENT_TYPES.register("mod", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> DAMAGE = DATA_COMPONENT_TYPES.register("damage", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> COMPONENTS = DATA_COMPONENT_TYPES.register("components", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> ENABLED = DATA_COMPONENT_TYPES.register("enabled", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<ItemContainerContents>> CONTENTS = DATA_COMPONENT_TYPES.register("contents", () -> DataComponentType.builder().persistent(ItemContainerContents.CODEC).networkSynchronized(ItemContainerContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<UUID>> UUID = DATA_COMPONENT_TYPES.register("uuid", () -> DataComponentType.builder().persistent(UUIDUtil.CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<String>> NAME = DATA_COMPONENT_TYPES.register("name", () -> DataComponentType.builder().persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8).build());
    public static final Supplier<DataComponentType<ResourceKey<Level>>> LEVEL = DATA_COMPONENT_TYPES.register("level", () -> DataComponentType.builder().persistent(ResourceKey.codec((ResourceKey)Registries.DIMENSION)).networkSynchronized(ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION)).build());
    public static final Supplier<DataComponentType<BlockPos>> POSITION = DATA_COMPONENT_TYPES.register("position", () -> DataComponentType.builder().persistent(BlockPos.CODEC).networkSynchronized(BlockPos.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<LastXY>> LAST_XY = DATA_COMPONENT_TYPES.register("last_xy", () -> DataComponentType.builder().persistent(LastXY.CODEC).networkSynchronized(LastXY.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Integer>> SLOT = DATA_COMPONENT_TYPES.register("slot", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<BlockState>> BLOCKSTATE = DATA_COMPONENT_TYPES.register("blockstate", () -> DataComponentType.builder().persistent(BlockState.CODEC).networkSynchronized(ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY)).build());
    public static final Supplier<DataComponentType<BlockPos>> FILLER_FIRST = DATA_COMPONENT_TYPES.register("filler_first", () -> DataComponentType.builder().persistent(BlockPos.CODEC).networkSynchronized(BlockPos.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<BlockPos>> FILLER_SECOND = DATA_COMPONENT_TYPES.register("filler_second", () -> DataComponentType.builder().persistent(BlockPos.CODEC).networkSynchronized(BlockPos.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<BlockPos>> FILLER_CURRENT = DATA_COMPONENT_TYPES.register("filler_current", () -> DataComponentType.builder().persistent(BlockPos.CODEC).networkSynchronized(BlockPos.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Integer>> MISC_INT = DATA_COMPONENT_TYPES.register("misc_int", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final Supplier<DataComponentType<FluidContents>> FLUID_A = DATA_COMPONENT_TYPES.register("fluid", () -> DataComponentType.builder().persistent(FluidContents.CODEC).networkSynchronized(FluidContents.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<FluidContents>> FLUID_B = DATA_COMPONENT_TYPES.register("fluid_b", () -> DataComponentType.builder().persistent(FluidContents.CODEC).networkSynchronized(FluidContents.STREAM_CODEC).build());

    public static void init(IEventBus evt) {
        DATA_COMPONENT_TYPES.register(evt);
    }

    public static class FluidContents {
        private final FluidStack inner;
        public static final Codec<FluidContents> CODEC = FluidStack.OPTIONAL_CODEC.xmap(FluidContents::of, FluidContents::inner);
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidContents> STREAM_CODEC = FluidStack.OPTIONAL_STREAM_CODEC.map(FluidContents::of, FluidContents::inner);
        public static final FluidContents EMPTY = FluidContents.of(FluidStack.EMPTY);

        public static FluidContents of(FluidStack stack) {
            return new FluidContents(stack);
        }

        private FluidStack inner() {
            return this.inner;
        }

        private FluidContents(FluidStack inner) {
            this.inner = inner;
        }

        public FluidStack get() {
            return this.inner.copy();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FluidStack) {
                FluidStack other = (FluidStack)obj;
                return FluidStack.matches((FluidStack)this.inner, (FluidStack)other);
            }
            return false;
        }

        public int hashCode() {
            return this.inner.hashCode();
        }
    }
}

