/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class LiquidFuelRecipe
implements Recipe<RecipeInput> {
    public static String NAME = "liquid_fuel";
    private FluidStack fuel;
    private int burnTime;
    private int totalEnergy;

    public LiquidFuelRecipe(FluidStack fuel, int totalEnergy, int burnTime) {
        this.fuel = fuel;
        this.burnTime = burnTime;
        this.totalEnergy = totalEnergy;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getTotalEnergy() {
        return this.totalEnergy;
    }

    public boolean matches(@Nonnull RecipeInput pInv, @Nonnull Level pLevel) {
        return false;
    }

    public boolean matches(FluidStack stack) {
        return FluidStack.isSameFluidSameComponents((FluidStack)this.fuel, (FluidStack)stack);
    }

    public boolean isSpecial() {
        return true;
    }

    public int getFuelAmount() {
        return this.fuel.getAmount();
    }

    public FluidStack getFuel() {
        return this.fuel;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput pInv, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.LIQUID_FUEL_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.LIQUID_FUEL.get();
    }

    public static class Serializer
    implements RecipeSerializer<LiquidFuelRecipe> {
        private static final MapCodec<LiquidFuelRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.CODEC.fieldOf("fuel").forGetter(recipe -> recipe.fuel), (App)Codec.INT.fieldOf("total_energy").forGetter(recipe -> recipe.totalEnergy), (App)Codec.INT.fieldOf("burn_time").forGetter(recipe -> recipe.burnTime)).apply((Applicative)instance, LiquidFuelRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, LiquidFuelRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<LiquidFuelRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LiquidFuelRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static LiquidFuelRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer) {
            FluidStack input = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)pBuffer);
            int totalEnergy = pBuffer.readInt();
            int burnTime = pBuffer.readInt();
            return new LiquidFuelRecipe(input, totalEnergy, burnTime);
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer, LiquidFuelRecipe pRecipe) {
            FluidStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.fuel);
            pBuffer.writeInt(pRecipe.totalEnergy);
            pBuffer.writeInt(pRecipe.burnTime);
        }
    }
}

