/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AAContainer
extends AbstractContainerMenu {
    public final int numSlots;
    public final Function<ItemStack, Boolean> VALIDATOR;

    protected AAContainer(@Nullable MenuType<?> menuType, int containerId, int numSlots, Function<ItemStack, Boolean> validator) {
        super(menuType, containerId);
        this.numSlots = numSlots;
        this.VALIDATOR = validator;
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        int inventoryEnd = this.numSlots + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.slots.get(index);
        if (theSlot.hasItem()) {
            ItemStack newStack = theSlot.getItem();
            ItemStack currentStack = newStack.copy();
            if (index >= this.numSlots ? (this.numSlots > 0 && this.VALIDATOR.apply(newStack) != false ? !this.moveItemStackTo(newStack, 0, this.numSlots, false) : (index <= inventoryEnd ? !this.moveItemStackTo(newStack, hotbarStart, hotbarEnd + 1, false) : index >= inventoryEnd + 1 && index < hotbarEnd + 1 && !this.moveItemStackTo(newStack, this.numSlots, inventoryEnd + 1, false))) : !this.moveItemStackTo(newStack, this.numSlots, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (newStack.isEmpty()) {
                theSlot.set(ItemStack.EMPTY);
            } else {
                theSlot.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            theSlot.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }
}

