/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.ICapabilityInvalidationListener;

public abstract class TileEntityPhantomface
extends TileEntityInventoryBase
implements IPhantomTile {
    public static final int RANGE = 16;
    public BlockPos boundPosition;
    public BlockPhantom.Type type;
    public int range;
    private int rangeBefore;
    private BlockPos boundPosBefore;
    private Block boundBlockBefore;
    private int lastStrength;
    private CapListener capListener = new CapListener(this);

    public TileEntityPhantomface(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 0);
    }

    public static int upgradeRange(int defaultRange, Level world, BlockPos pos) {
        Block block;
        int newRange = defaultRange;
        for (int i = 0; i < 3 && (block = world.getBlockState(pos.above(1 + i)).getBlock()) == ActuallyBlocks.PHANTOM_BOOSTER.get(); ++i) {
            newRange *= 2;
        }
        return newRange;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("Range", this.range);
            if (this.boundPosition != null) {
                compound.putInt("xOfTileStored", this.boundPosition.getX());
                compound.putInt("yOfTileStored", this.boundPosition.getY());
                compound.putInt("zOfTileStored", this.boundPosition.getZ());
            }
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            int x = compound.getInt("xOfTileStored");
            int y = compound.getInt("yOfTileStored");
            int z = compound.getInt("zOfTileStored");
            this.range = compound.getInt("Range");
            if (x != 0 || y != 0 || z != 0) {
                this.boundPosition = new BlockPos(x, y, z);
                this.setChanged();
            }
        }
    }

    @Override
    protected void serverTick() {
        int strength;
        super.serverTick();
        this.range = TileEntityPhantomface.upgradeRange(16, this.level, this.getBlockPos());
        if (!this.hasBoundPosition()) {
            this.boundPosition = null;
        }
        if (this.doesNeedUpdateSend()) {
            this.onUpdateSent();
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.capListener.disable();
                this.capListener = new CapListener(this);
                if (this.hasBoundPosition()) {
                    serverLevel.registerCapabilityListener(this.boundPosition, (ICapabilityInvalidationListener)this.capListener);
                }
            }
            this.invalidateCapabilities();
        }
        if (this.lastStrength != (strength = this.getComparatorStrength())) {
            this.lastStrength = strength;
            this.setChanged();
        }
    }

    @Override
    protected void clientTick() {
        super.clientTick();
        if (this.boundPosition != null) {
            this.renderParticles();
        }
    }

    protected boolean doesNeedUpdateSend() {
        return this.boundPosition != this.boundPosBefore || this.boundPosition != null && this.level.getBlockState(this.boundPosition).getBlock() != this.boundBlockBefore || this.rangeBefore != this.range;
    }

    protected void onUpdateSent() {
        this.rangeBefore = this.range;
        this.boundPosBefore = this.boundPosition;
        Block block = this.boundBlockBefore = this.boundPosition == null ? null : this.level.getBlockState(this.boundPosition).getBlock();
        if (this.boundPosition != null) {
            this.level.updateNeighborsAt(this.worldPosition, this.level.getBlockState(this.boundPosition).getBlock());
        }
        this.sendUpdate();
        this.setChanged();
    }

    @Override
    public boolean hasBoundPosition() {
        if (this.boundPosition != null) {
            if (this.level.getBlockEntity(this.boundPosition) instanceof IPhantomTile || this.getBlockPos().getX() == this.boundPosition.getX() && this.getBlockPos().getY() == this.boundPosition.getY() && this.getBlockPos().getZ() == this.boundPosition.getZ()) {
                this.boundPosition = null;
                return false;
            }
            return true;
        }
        return false;
    }

    public void renderParticles() {
        if (this.level.random.nextInt(2) == 0) {
            double d1 = (float)this.boundPosition.getY() + this.level.random.nextFloat();
            int i1 = this.level.random.nextInt(2) * 2 - 1;
            int j1 = this.level.random.nextInt(2) * 2 - 1;
            double d4 = ((double)this.level.random.nextFloat() - 0.5) * 0.125;
            double d2 = (double)this.boundPosition.getZ() + 0.5 + 0.25 * (double)j1;
            double d5 = this.level.random.nextFloat() * 1.0f * (float)j1;
            double d0 = (double)this.boundPosition.getX() + 0.5 + 0.25 * (double)i1;
            double d3 = this.level.random.nextFloat() * 1.0f * (float)i1;
            this.level.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        return this.hasBoundPosition() && this.boundPosition.distSqr((Vec3i)this.getBlockPos()) <= (double)(this.range * this.range);
    }

    @Override
    public BlockPos getBoundPosition() {
        return this.boundPosition;
    }

    @Override
    public void setBoundPosition(BlockPos pos) {
        this.boundPosition = pos;
    }

    public int getGuiID() {
        return -1;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public int getComparatorStrength() {
        BlockPos pos;
        BlockState state;
        if (this.isBoundThingInRange() && (state = this.level.getBlockState(pos = this.getBoundPosition())).hasAnalogOutputSignal()) {
            return state.getAnalogOutputSignal(this.level, pos);
        }
        return 0;
    }

    public static class CapListener
    implements ICapabilityInvalidationListener {
        private boolean valid = true;
        private final TileEntityPhantomface tile;

        public CapListener(TileEntityPhantomface tile) {
            this.tile = tile;
        }

        public void disable() {
            this.valid = false;
        }

        public boolean onInvalidate() {
            if (this.valid && !this.tile.isRemoved()) {
                this.tile.invalidateCapabilities();
                return true;
            }
            return false;
        }
    }
}

