/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.data;

import de.ellpeck.actuallyadditions.mod.data.WorldData;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public final class PlayerData {
    private static PlayerSave clientData = null;

    public static PlayerSave getDataFromPlayer(Player player) {
        PlayerSave save;
        if (!(player.getCommandSenderWorld() instanceof ServerLevel)) {
            if (clientData == null) {
                clientData = new PlayerSave(player.getUUID());
            }
            return clientData;
        }
        WorldData worldData = WorldData.get(player.getCommandSenderWorld());
        ConcurrentHashMap<UUID, PlayerSave> data = worldData.playerSaveData;
        UUID id = player.getUUID();
        if (data.containsKey(id) && (save = data.get(id)) != null && save.id != null && save.id.equals(id)) {
            return save;
        }
        save = new PlayerSave(id);
        data.put(id, save);
        worldData.setDirty();
        return save;
    }

    public static class PlayerSave {
        public UUID id;
        public boolean bookGottenAlready;
        public boolean hasBatWings;
        public boolean shouldDisableBatWings;
        public int batWingsFlyTime;

        public PlayerSave(UUID id) {
            this.id = id;
        }

        public void readFromNBT(CompoundTag compound, boolean savingToFile) {
            this.bookGottenAlready = compound.getBoolean("BookGotten");
            this.hasBatWings = compound.getBoolean("HasBatWings");
            this.batWingsFlyTime = compound.getInt("BatWingsFlyTime");
            if (!savingToFile) {
                this.shouldDisableBatWings = compound.getBoolean("ShouldDisableWings");
            }
        }

        public void writeToNBT(CompoundTag compound, boolean savingToFile) {
            compound.putBoolean("BookGotten", this.bookGottenAlready);
            compound.putBoolean("HasBatWings", this.hasBatWings);
            compound.putInt("BatWingsFlyTime", this.batWingsFlyTime);
            if (!savingToFile) {
                compound.putBoolean("ShouldDisableWings", this.shouldDisableBatWings);
            }
        }
    }
}

