/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.api.emojis.EmojiStore;
import net.itsthesky.disky.api.generator.DocBuilder;
import net.itsthesky.disky.api.modules.DiSkyModule;
import net.itsthesky.disky.api.modules.ModuleManager;
import net.itsthesky.disky.api.skript.ErrorHandler;
import net.itsthesky.disky.core.DiSkyCommand;
import net.itsthesky.disky.core.DiSkyMetrics;
import net.itsthesky.disky.core.UpdateCheckerTask;
import net.itsthesky.disky.core.Utils;
import net.itsthesky.disky.elements.structures.context.ContextCommandManager;
import net.itsthesky.disky.elements.structures.slash.SlashManager;
import net.itsthesky.disky.managers.BotManager;
import net.itsthesky.disky.managers.ConfigManager;
import net.itsthesky.disky.managers.WebhooksManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.skriptlang.skript.registration.SyntaxRegistry;

public final class DiSky
extends JavaPlugin {
    private static DiSky instance;
    private static SkriptAddon addonInstance;
    private static ErrorHandler errorHandler;
    private static BotManager botManager;
    private static boolean skImageInstalled;
    private static ModuleManager moduleManager;
    private static DocBuilder builder;
    private static WebhooksManager webhooksManager;

    public static DiSkyModule getModule(String moduleName) {
        return DiSky.getModuleManager().getModules().stream().filter(module -> module.getModuleInfo().name.equalsIgnoreCase(moduleName)).findAny().orElse(null);
    }

    public void onEnable() {
        instance = this;
        botManager = new BotManager(this);
        builder = new DocBuilder(this);
        webhooksManager = new WebhooksManager(this);
        errorHandler = botManager.errorHandler();
        skImageInstalled = this.getServer().getPluginManager().isPluginEnabled("SkImage2");
        this.getCommand("disky").setExecutor((CommandExecutor)new DiSkyCommand());
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!this.getServer().getPluginManager().isPluginEnabled("Skript")) {
            errorHandler.exception(null, new RuntimeException("Skript is not found, cannot start DiSky."));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!Skript.isAcceptRegistrations()) {
            errorHandler.exception(null, new RuntimeException("Skript found, but it doesn't accept registration. Cannot start DiSky."));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (Skript.getVersion().isSmallerThan(new Version("2.10.0"))) {
            this.getLogger().severe("This version of DiSky requires Skript 2.10.0 or higher.");
            this.getLogger().severe("The last version of DiSky supporting Skript 2.9.x is DiSky 4.20.0!");
            this.getLogger().severe("BY DOWNGRADING DISKY, YOU WILL **NOT** RECEIVE ANY SUPPORT!");
            this.getLogger().severe("Please update Skript to the latest version.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        UpdateCheckerTask checker = new UpdateCheckerTask(this);
        checker.runTaskAsynchronously((Plugin)this);
        ConfigManager.loadConfig(this);
        DiSkyMetrics.init(this);
        File emojisFile = new File(this.getDataFolder(), "emojis.json");
        if (!emojisFile.exists()) {
            this.getLogger().info("Saving emoji's file ...");
            try {
                InputStream stream = this.getResource("emojis.json");
                if (stream == null) {
                    this.getLogger().severe("Could not find emoji's file of the JAR, this should never happens :c");
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                    return;
                }
                Files.write(emojisFile.toPath(), Utils.readBytesFromStream(stream), new OpenOption[0]);
            }
            catch (IOException | RuntimeException e) {
                e.printStackTrace();
                this.getLogger().severe("An error occurred while saving emojis file! Emojis will not be available.");
            }
            this.getLogger().info("Success!");
        }
        this.getLogger().info("Loading emoji library ...");
        try {
            EmojiStore.loadLocal();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLogger().severe("An error occurred while loading emojis! They will not be available.");
        }
        this.getLogger().info("Success!");
        if (skImageInstalled) {
            this.getLogger().info("SkImage has been found! Enabling images syntax.");
        }
        addonInstance = Skript.registerAddon((JavaPlugin)this);
        moduleManager = new ModuleManager(new File(this.getDataFolder(), "modules"), this, addonInstance);
        try {
            addonInstance.loadClasses("net.itsthesky.disky.elements", new String[0]);
            moduleManager.loadModules();
        }
        catch (IOException e) {
            errorHandler.exception(null, e);
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        RestAction.setDefaultFailure(throwable -> DiSky.getErrorHandler().exception(null, (Throwable)throwable));
    }

    public static void debug(String s) {
        DiSky.getInstance().debugMessage(s);
    }

    private void debugMessage(String s) {
        if (ConfigManager.get("debug", false).booleanValue()) {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "DEBUG: " + String.valueOf(ChatColor.LIGHT_PURPLE) + s);
        }
    }

    public void onDisable() {
        SlashManager.shutdownAll();
        ContextCommandManager.shutdownAll();
        moduleManager.getModules().forEach(DiSkyModule::shutdown);
        botManager.shutdown();
    }

    public static boolean isSkImageInstalled() {
        return skImageInstalled;
    }

    public static DiSky getInstance() {
        return instance;
    }

    public static DocBuilder getDocBuilder() {
        return builder;
    }

    public static ErrorHandler getErrorHandler() {
        return errorHandler;
    }

    public static SkriptAddon getAddonInstance() {
        return addonInstance;
    }

    public static ModuleManager getModuleManager() {
        return moduleManager;
    }

    public static BotManager getManager() {
        return botManager;
    }

    public static WebhooksManager getWebhooksManager() {
        return webhooksManager;
    }

    public static void runtimeError(String description, Object ... data) {
        DiSky.getInstance().getLogger().severe(String.valueOf(ChatColor.DARK_RED) + "DiSky Runtime Warning: " + String.valueOf(ChatColor.RED) + description);
        if (data != null) {
            DiSky.getInstance().getLogger().severe(String.valueOf(ChatColor.RED) + "Provided data context:");
            for (int i = 0; i < data.length - 1; i += 2) {
                DiSky.getInstance().getLogger().severe(String.valueOf(ChatColor.GOLD) + "  - " + String.valueOf(ChatColor.YELLOW) + String.valueOf(data[i]) + String.valueOf(ChatColor.GRAY) + ": " + String.valueOf(ChatColor.WHITE) + String.valueOf(data[i + 1]));
            }
        }
    }

    public static SyntaxRegistry syntaxRegistry() {
        return DiSky.getAddonInstance().syntaxRegistry();
    }

    public static Version getVersion() {
        return new Version(DiSky.getInstance().getDescription().getVersion());
    }
}

