/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Section;
import net.itsthesky.disky.DiSky;
import org.skriptlang.skript.addon.SkriptAddon;
import org.skriptlang.skript.registration.DefaultSyntaxInfos;
import org.skriptlang.skript.registration.SyntaxInfo;
import org.skriptlang.skript.registration.SyntaxOrigin;
import org.skriptlang.skript.registration.SyntaxRegistry;

public final class DiSkyRegistry {
    public static <E extends Expression<T>, T> void registerExpression(Class<E> expressionType, Class<T> returnType, ExpressionType type, SyntaxOrigin origin, String ... patterns) throws IllegalArgumentException {
        ch.njol.skript.SkriptAddon addon = DiSky.getAddonInstance();
        addon.syntaxRegistry().register(SyntaxRegistry.EXPRESSION, (SyntaxInfo)((DefaultSyntaxInfos.Expression.Builder)((DefaultSyntaxInfos.Expression.Builder)((DefaultSyntaxInfos.Expression.Builder)DefaultSyntaxInfos.Expression.builder(expressionType, returnType).priority(type.priority())).origin(origin)).addPatterns(patterns)).build());
    }

    public static <E extends Expression<T>, T> void registerExpression(Class<E> expressionType, Class<T> returnType, ExpressionType type, String ... patterns) throws IllegalArgumentException {
        DiSkyRegistry.registerExpression(expressionType, returnType, type, SyntaxOrigin.of((SkriptAddon)DiSky.getAddonInstance()), patterns);
    }

    public static <E extends Condition> void registerCondition(Class<E> conditionClass, Condition.ConditionType type, SyntaxOrigin origin, String ... patterns) throws IllegalArgumentException {
        ch.njol.skript.SkriptAddon addon = DiSky.getAddonInstance();
        addon.syntaxRegistry().register(SyntaxRegistry.CONDITION, SyntaxInfo.builder(conditionClass).priority(type.priority()).origin(origin).addPatterns(patterns).build());
    }

    public static <E extends Effect> void registerEffect(Class<E> effectClass, SyntaxOrigin origin, String ... patterns) throws IllegalArgumentException {
        ch.njol.skript.SkriptAddon addon = DiSky.getAddonInstance();
        addon.syntaxRegistry().register(SyntaxRegistry.EFFECT, SyntaxInfo.builder(effectClass).origin(origin).addPatterns(patterns).build());
    }

    public static <E extends Effect> void registerEffect(Class<E> effectClass, String ... patterns) throws IllegalArgumentException {
        DiSkyRegistry.registerEffect(effectClass, SyntaxOrigin.of((SkriptAddon)DiSky.getAddonInstance()), patterns);
    }

    public static <E extends Section> void registerSection(Class<E> sectionClass, SyntaxOrigin origin, String ... patterns) throws IllegalArgumentException {
        ch.njol.skript.SkriptAddon addon = DiSky.getAddonInstance();
        addon.syntaxRegistry().register(SyntaxRegistry.SECTION, SyntaxInfo.builder(sectionClass).origin(origin).addPatterns(patterns).build());
    }

    public static <E extends Section> void registerSection(Class<E> sectionClass, String ... patterns) throws IllegalArgumentException {
        DiSkyRegistry.registerSection(sectionClass, SyntaxOrigin.of((SkriptAddon)DiSky.getAddonInstance()), patterns);
    }

    public static <E extends Condition> void registerCondition(Class<E> conditionClass, Condition.ConditionType type, String ... patterns) throws IllegalArgumentException {
        DiSkyRegistry.registerCondition(conditionClass, type, SyntaxOrigin.of((SkriptAddon)DiSky.getAddonInstance()), patterns);
    }

    public static boolean unregisterElement(SyntaxRegistry.Key syntaxKey, Class<?> element) {
        try {
            SyntaxRegistry reg = DiSky.getAddonInstance().syntaxRegistry();
            for (SyntaxInfo entry : reg.elements()) {
                if (!entry.type().equals(element)) continue;
                reg.unregister(syntaxKey, entry);
                return true;
            }
            DiSky.debug("The element " + element.getSimpleName() + " is not registered in the Skript registry.");
            return false;
        }
        catch (Exception e) {
            DiSky.debug("An error occurred while trying to unregister the element " + element.getSimpleName() + " from the Skript registry:");
            e.printStackTrace();
            return false;
        }
    }

    public static <T> void registerProperty(Class<? extends Expression<T>> expressionClass, Class<T> type, String property, String fromType) {
        DiSkyRegistry.registerExpression(expressionClass, type, ExpressionType.PROPERTY, PropertyExpression.getPatterns((String)property, (String)fromType));
    }

    public static void registerPropertyCondition(Class<? extends Condition> condition, String property, String type) {
        DiSkyRegistry.registerCondition(condition, Condition.ConditionType.PROPERTY, PropertyCondition.getPatterns((PropertyCondition.PropertyType)PropertyCondition.PropertyType.BE, (String)property, (String)type));
    }
}

