/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.datastruct;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.registrations.Classes;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.ReflectionUtils;
import net.itsthesky.disky.api.datastruct.DataStructureEntry;
import net.itsthesky.disky.api.datastruct.base.BasicDS;
import net.itsthesky.disky.api.datastruct.base.ChainDS;
import net.itsthesky.disky.api.datastruct.base.DataStruct;
import net.itsthesky.disky.api.skript.BetterExpressionEntryData;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;

public final class DataStructureFactory {
    public static DataStructureParseResult initDataStructure(@NotNull Class<? extends DataStruct> dataStructClass, @NotNull SectionNode node) {
        EntryValidator validator = DataStructureFactory.createValidator(dataStructClass);
        EntryContainer container = validator.validate(node);
        if (container == null) {
            return null;
        }
        Map<String, String> keysToFields = DataStructureFactory.mapKeysToFields(dataStructClass);
        DiSky.debug("=========== Starting parsing of data structure " + dataStructClass.getName() + " ===========");
        DataStructureFactory.logContainerInfo(container, validator);
        List<String> presentNodes = DataStructureFactory.collectPresentNodes(validator, container);
        Map<String, List<Expression<?>>> expressions = DataStructureFactory.parseExpressions(container, presentNodes);
        Map<String, List<DataStructureParseResult>> subStructures = DataStructureFactory.parseSubStructures(dataStructClass, container, keysToFields);
        String errorMessage = DataStructureFactory.preValidate(dataStructClass, presentNodes);
        if (errorMessage != null) {
            DiSkyRuntimeHandler.error(new IllegalStateException(errorMessage), (Node)node);
            return null;
        }
        return new DataStructureParseResult(node, validator, container, expressions, subStructures);
    }

    public static EntryValidator createValidator(@NotNull Class<?> structClass) {
        EntryValidator.EntryValidatorBuilder validator = EntryValidator.builder();
        DiSky.debug("=========== Starting validation of data structure " + structClass.getName() + " ===========");
        HashSet<String> plannedKeys = new HashSet<String>();
        for (Field field : structClass.getDeclaredFields()) {
            DataStructureEntry entry = field.getAnnotation(DataStructureEntry.class);
            if (entry == null) continue;
            DataStructureFactory.processFieldValidator(validator, field, entry, structClass);
            plannedKeys.add(entry.value());
        }
        validator.unexpectedNodeTester(node -> {
            String key = node.getKey().split(":")[0];
            if (plannedKeys.contains(key)) {
                return false;
            }
            Skript.error((String)("Unexpected node with key '" + key + "' in data structure " + structClass.getSimpleName()));
            return false;
        });
        DiSky.debug("=========== End of validation of data structure " + structClass.getName() + " ===========");
        return validator.build();
    }

    public static Object createDataStructure(@NotNull Class<?> structClass, @NotNull DataStructureParseResult parseResult, @NotNull Event event, @Nullable Object chainInstance) throws ReflectiveOperationException {
        DiSky.debug("################## Starting creation of data structure " + structClass.getName() + " ##################");
        Object instance = structClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        EntryContainer container = parseResult.container();
        Map<String, List<Node>> unhandledNodes = DataStructureFactory.groupUnhandledNodes(container);
        DataStructureFactory.processFields(structClass, instance, parseResult, event, unhandledNodes);
        if (!DataStructureFactory.validateFields((Node)parseResult.relatedNode(), structClass, instance)) {
            return null;
        }
        DiSky.debug("################## End of creation of data structure " + structClass.getName() + " ##################");
        return DataStructureFactory.finalizeInstance(instance, chainInstance);
    }

    private static boolean validateFields(@NotNull Node node, @NotNull Class<?> structClass, @NotNull Object instance) {
        for (Field field : structClass.getDeclaredFields()) {
            DataStructureEntry entry = field.getAnnotation(DataStructureEntry.class);
            if (entry == null) continue;
            String key = entry.value();
            Object value = ReflectionUtils.getFieldValue(field, instance);
            if (value != null || entry.optional()) continue;
            DiSkyRuntimeHandler.error(new IllegalStateException("Field '" + key + "' in data structure " + structClass.getSimpleName() + " is null/none/empty, but is required!"), node, false);
            return false;
        }
        return true;
    }

    private static Map<String, String> mapKeysToFields(@NotNull Class<?> dataStructClass) {
        HashMap<String, String> keysToFields = new HashMap<String, String>();
        for (Field field : dataStructClass.getDeclaredFields()) {
            DataStructureEntry entry = field.getAnnotation(DataStructureEntry.class);
            if (entry == null) continue;
            keysToFields.put(entry.value(), field.getName());
        }
        return keysToFields;
    }

    private static void processFieldValidator(EntryValidator.EntryValidatorBuilder validator, Field field, DataStructureEntry entry, Class<?> structClass) {
        String key = entry.value();
        Class<?> type = field.getType();
        Object defaultValue = DataStructureFactory.getDefaultValue(field, structClass);
        if (!DataStructureFactory.isList(type) || entry.subStructureType() == DataStruct.class) {
            String typeName = Classes.getExactClassName(type);
            validator.addEntryData(new BetterExpressionEntryData(key, SkriptUtils.convertToExpressions(defaultValue), entry.optional(), type));
            DiSky.debug("- Added entry data for key " + key + " with type " + typeName);
        } else {
            DiSky.debug("- Added sub-structure for key " + key);
        }
    }

    private static Object getDefaultValue(Field field, Class<?> structClass) {
        try {
            Object instance = structClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            DiSky.debug("Cannot get default value of field " + field.getName() + " in class " + structClass.getName() + "! Are you sure a public and empty constructor is present?");
            return null;
        }
    }

    private static void logContainerInfo(EntryContainer container, EntryValidator validator) {
        DiSky.debug("- Unhandled nodes (" + container.getUnhandledNodes().size() + "): " + String.valueOf(container.getUnhandledNodes().stream().map(Node::getKey).toList()));
        DiSky.debug("- Found entry data (" + validator.getEntryData().size() + "): " + String.valueOf(validator.getEntryData().stream().map(data -> data.getKey()).toList()));
    }

    private static List<String> collectPresentNodes(EntryValidator validator, EntryContainer container) {
        ArrayList<String> presentNodes = new ArrayList<String>();
        for (EntryData entryData : validator.getEntryData()) {
            if (!container.hasEntry(entryData.getKey())) continue;
            presentNodes.add(entryData.getKey().split(":")[0]);
        }
        for (Node node : container.getUnhandledNodes()) {
            presentNodes.add(node.getKey().split(":")[0]);
        }
        DiSky.debug("Present nodes: " + String.valueOf(presentNodes));
        return presentNodes;
    }

    private static Map<String, List<Expression<?>>> parseExpressions(EntryContainer container, List<String> presentNodes) {
        HashMap expressions = new HashMap();
        for (String nodeKey : presentNodes) {
            ArrayList exprs = (ArrayList)container.getOptional(nodeKey, List.class, true);
            if (exprs == null) {
                exprs = new ArrayList();
            }
            DiSky.debug("-> Adding expression for node " + nodeKey + " with " + exprs.size() + " expressions");
            expressions.put(nodeKey, exprs);
        }
        return expressions;
    }

    private static Map<String, List<DataStructureParseResult>> parseSubStructures(Class<?> dataStructClass, EntryContainer container, Map<String, String> keysToFields) {
        HashMap<String, List<DataStructureParseResult>> subStructures = new HashMap<String, List<DataStructureParseResult>>();
        DiSky.debug("-> Starting sub-structures handling ...");
        for (Node subNode : container.getUnhandledNodes()) {
            if (!(subNode instanceof SectionNode)) {
                DiSky.debug("-> Unhandled node is not a section node (" + subNode.getKey() + "), skipping ...");
                continue;
            }
            SectionNode subSectionNode = (SectionNode)subNode;
            DataStructureFactory.processSubStructure(dataStructClass, subNode, keysToFields, subStructures, subSectionNode);
        }
        return subStructures;
    }

    private static void processSubStructure(Class<?> dataStructClass, Node subNode, Map<String, String> keysToFields, Map<String, List<DataStructureParseResult>> subStructures, SectionNode subSectionNode) {
        String nodeKey = subNode.getKey().split(":")[0];
        DiSky.debug("Now processing sub-structure for key " + nodeKey + " ...");
        Field entryField = ReflectionUtils.getField(dataStructClass, keysToFields.get(nodeKey));
        if (entryField == null) {
            DiSky.debug("-> Cannot find field for key " + nodeKey + " in class " + dataStructClass.getName());
            return;
        }
        Class<? extends DataStruct> entryType = entryField.getDeclaredAnnotation(DataStructureEntry.class).subStructureType();
        DataStructureParseResult subResult = DataStructureFactory.initDataStructure(entryType, subSectionNode);
        if (subResult != null) {
            subStructures.computeIfAbsent(nodeKey, k -> new ArrayList()).add(subResult);
        } else {
            DiSky.debug("Cannot init sub-structure for key " + nodeKey + " in class " + dataStructClass.getName());
        }
        DiSky.debug("--> Adding sub-structure for key " + nodeKey + " with " + String.valueOf(subResult));
    }

    private static Map<String, List<Node>> groupUnhandledNodes(EntryContainer container) {
        HashMap<String, List<Node>> unhandledNodes = new HashMap<String, List<Node>>();
        for (Node node : container.getUnhandledNodes()) {
            unhandledNodes.computeIfAbsent(node.getKey().split(":")[0], k -> new ArrayList()).add(node);
        }
        return unhandledNodes;
    }

    private static void processFields(Class<?> structClass, Object instance, DataStructureParseResult parseResult, Event event, Map<String, List<Node>> unhandledNodes) throws IllegalAccessException {
        for (Field field : structClass.getDeclaredFields()) {
            DataStructureEntry entry = field.getAnnotation(DataStructureEntry.class);
            if (entry == null) continue;
            DataStructureFactory.processField(field, entry, instance, parseResult, event, unhandledNodes);
        }
    }

    private static void processField(Field field, DataStructureEntry entry, Object instance, DataStructureParseResult parseResult, Event event, Map<String, List<Node>> unhandledNodes) throws IllegalAccessException {
        String key = entry.value();
        Class<?> type = field.getType();
        boolean isList = DataStructureFactory.isList(type);
        boolean isDataStructs = entry.subStructureType() != DataStruct.class;
        field.setAccessible(true);
        if (isDataStructs) {
            DataStructureFactory.processDataStructField(field, entry, instance, key, unhandledNodes, parseResult, event);
        } else {
            DataStructureFactory.processSimpleField(field, instance, key, isList, parseResult, event);
        }
    }

    private static void processDataStructField(Field field, DataStructureEntry entry, Object instance, String key, Map<String, List<Node>> unhandledNodes, DataStructureParseResult parseResult, Event event) throws IllegalAccessException {
        List<Node> subNodes = unhandledNodes.get(key);
        if (subNodes == null) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < subNodes.size(); ++i) {
            Node subNode = subNodes.get(i);
            Class<? extends DataStruct> targetDataStructureType = entry.subStructureType();
            String nodeKey = subNode.getKey().split(":")[0];
            List<DataStructureParseResult> subResultList = parseResult.subStructures().get(nodeKey);
            if (subResultList == null || subResultList.isEmpty()) {
                DiSky.debug("Cannot find sub-structure for key " + nodeKey + " in class " + instance.getClass().getName());
                continue;
            }
            DiSky.debug("Creating sub-structure for key " + key + " with " + subResultList.size() + " sub-structures ...");
            DataStructureParseResult subResultItem = subResultList.get(i);
            try {
                Object subInstance = DataStructureFactory.createDataStructure(targetDataStructureType, subResultItem, event, null);
                if (subInstance == null) continue;
                list.add(subInstance);
                continue;
            }
            catch (ReflectiveOperationException e) {
                DiSky.debug("Failed to create sub-structure: " + e.getMessage());
            }
        }
        field.set(instance, list);
    }

    private static void processSimpleField(Field field, Object instance, String key, boolean isList, DataStructureParseResult parseResult, Event event) throws IllegalAccessException {
        List expressions = parseResult.expressions().getOrDefault(key, new ArrayList());
        if (!isList && expressions.size() == 1) {
            Expression expr = (Expression)expressions.get(0);
            if (expr != null) {
                field.set(instance, expr.getSingle(event));
            }
        } else if (isList) {
            ArrayList<Object> parsedList = new ArrayList<Object>();
            for (Expression expr : expressions) {
                Object value;
                if (expr == null || (value = expr.getSingle(event)) == null) continue;
                parsedList.add(value);
            }
            field.set(instance, parsedList);
        }
    }

    private static boolean isList(Class<?> type) {
        return List.class.isAssignableFrom(type) || type.isArray();
    }

    private static Object finalizeInstance(Object instance, @Nullable Object chainInstance) {
        if (instance instanceof BasicDS) {
            return ((BasicDS)instance).build();
        }
        if (instance instanceof ChainDS) {
            if (chainInstance == null) {
                throw new IllegalArgumentException("Cannot edit a chain data structure without a chain instance!");
            }
            return ((ChainDS)instance).edit(chainInstance);
        }
        throw new IllegalArgumentException("The data structure class " + instance.getClass().getName() + " must implement either BasicDS or ChainDS interface!");
    }

    @Nullable
    public static <F, T extends DataStruct<F>> String preValidate(@NotNull Class<T> structClass, @NotNull List<String> presentNodes) {
        try {
            DataStruct instance = (DataStruct)structClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return instance.preValidate(presentNodes);
        }
        catch (ReflectiveOperationException e) {
            return "Failed to create instance for validation: " + e.getMessage();
        }
    }

    public record DataStructureParseResult(@NotNull SectionNode relatedNode, @NotNull EntryValidator validator, @NotNull EntryContainer container, @NotNull Map<String, List<Expression<?>>> expressions, @NotNull Map<String, List<DataStructureParseResult>> subStructures) {
    }
}

