/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.emojis;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.emojis.Action;
import net.itsthesky.disky.api.emojis.ActionSupplier;
import org.jetbrains.annotations.Nullable;

public class ActionImpl<T>
implements Action<T> {
    private static int threadNum = 0;
    private static final ExecutorService executor = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> {
        Thread thread = new Thread(r);
        thread.setName("Queued action thread #" + threadNum++);
        return thread;
    });
    private final ActionSupplier<T> supplier;

    public ActionImpl(ActionSupplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void queue(@Nullable Consumer<T> onSuccess, @Nullable Consumer<Throwable> onThrow) {
        executor.submit(() -> {
            try {
                T result = this.complete();
                if (onSuccess != null) {
                    onSuccess.accept(result);
                }
            }
            catch (Throwable e) {
                if (onThrow != null) {
                    onThrow.accept(e);
                }
                DiSky.getErrorHandler().exception(null, e);
            }
        });
    }

    @Override
    public <R> Action<R> flatMap(Function<T, R> flatmap) {
        return new ActionImpl<Object>(() -> flatmap.apply(this.complete()));
    }

    @Override
    public T complete() {
        try {
            return this.supplier.get();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

