/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.emojis;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.emojis.Emoji;
import net.itsthesky.disky.api.emojis.EmojiStore;

public class Emojis {
    private static final EmojiStore store;
    private static final Set<Emoji> emojiView;

    public static Set<Emoji> getEmojis() {
        return emojiView;
    }

    public static Emoji ofUnicode(String unicode) {
        return UnicodeHolder.unicodeMap.get(unicode);
    }

    public static Emoji ofShortcode(String shortcode) {
        if (shortcode.charAt(0) == ':' && shortcode.charAt(shortcode.length() - 1) == ':') {
            return ShortcodeHolder.shortcodeMap.get(shortcode.substring(1, shortcode.length() - 1));
        }
        return ShortcodeHolder.shortcodeMap.get(shortcode);
    }

    static {
        try {
            store = EmojiStore.loadLocal();
            emojiView = Collections.unmodifiableSet(store.getEmojis());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load emojis", e);
        }
    }

    private static class UnicodeHolder {
        private static final Map<String, Emoji> unicodeMap = new HashMap<String, Emoji>();

        private UnicodeHolder() {
        }

        static {
            for (Emoji emoji : store.getEmojis()) {
                Emoji old = unicodeMap.put(emoji.unicode(), emoji);
                if (old == null) continue;
                DiSky.debug("Duplicate unicode: " + emoji.unicode() + " in https://emojipedia.org/" + old.subpage() + " and https://emojipedia.org/" + emoji.subpage() + ", might not be grave");
            }
            DiSky.debug("Loaded unicode map");
        }
    }

    private static class ShortcodeHolder {
        private static final Map<String, Emoji> shortcodeMap = new HashMap<String, Emoji>();

        private ShortcodeHolder() {
        }

        static {
            for (Emoji emoji : store.getEmojis()) {
                for (String shortcode : emoji.shortcodes()) {
                    Emoji old = shortcodeMap.put(shortcode, emoji);
                    if (old == null) continue;
                    DiSky.debug("Duplicate shortcode: " + shortcode + " in https://emojipedia.org/" + old.subpage() + " and https://emojipedia.org/" + emoji.subpage() + ", might not be grave");
                }
            }
            DiSky.debug("Loaded shortcode map");
        }
    }
}

