/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.events;

import ch.njol.skript.config.Node;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.dv8tion.jda.api.audit.ActionType;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.api.events.guild.GuildAuditLogEntryCreateEvent;
import net.itsthesky.disky.DiSky;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventListener<T> {
    public boolean enabled = true;
    private final Class<T> clazz;
    private final BiConsumer<T, GuildAuditLogEntryCreateEvent> consumer;
    private final Predicate<T> checker;
    @Nullable
    private final String specificBotName;
    private final boolean isWaitingLogEvent;
    @Nullable
    private final ActionType logType;
    private final Predicate<GuildAuditLogEntryCreateEvent> logChecker;
    private final Node attachedNode;
    @Nullable
    private T lastEvent;

    public EventListener(Class<T> paramClass, BiConsumer<T, GuildAuditLogEntryCreateEvent> consumer, Predicate<T> checker, Predicate<GuildAuditLogEntryCreateEvent> logChecker, @Nullable ActionType actionType, @Nullable String specificBotName, Node attachedNode) {
        this.clazz = paramClass;
        this.consumer = consumer;
        this.checker = checker;
        this.logChecker = logChecker;
        this.specificBotName = specificBotName;
        this.isWaitingLogEvent = actionType != null;
        this.logType = actionType;
        this.attachedNode = attachedNode;
    }

    public void onGuildAuditLogEntryCreate(GuildAuditLogEntryCreateEvent event) {
        DiSky.debug("received log event " + String.valueOf((Object)event.getEntry().getType()) + " by DiSky.");
        if (this.isWaitingLogEvent && event.getEntry().getType() == this.logType) {
            DiSky.debug("Log event " + String.valueOf((Object)event.getEntry().getType()) + " received by DiSky. Is there last event? " + (this.lastEvent != null) + ".");
            if (this.lastEvent != null) {
                if (this.logChecker.test(event)) {
                    this.consumer.accept(this.lastEvent, event);
                    this.lastEvent = null;
                }
            } else {
                DiSky.getInstance().getLogger().severe("The last event is null, but the log event is waiting for it! (ActionType: " + String.valueOf((Object)event.getEntry().getType()) + ", Event: " + String.valueOf(event) + ")");
            }
        }
    }

    public void onGenericEvent(@NotNull GenericEvent event) {
        if (this.enabled && this.clazz.isInstance(event)) {
            DiSky.debug("Event " + event.getClass().getSimpleName() + " received by DiSky. Is it valid? " + this.checker.test(event) + "." + this.hash());
            if (!this.checker.test(event)) {
                return;
            }
            DiSky.debug("- Event is valid, executing consumer (is waiting for log event: " + this.isWaitingLogEvent + ")");
            if (this.isWaitingLogEvent) {
                this.lastEvent = event;
            } else {
                this.consumer.accept(event, null);
            }
        }
    }

    public String hash() {
        return " [class hash: " + this.hashCode() + "]";
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public Node getAttachedNode() {
        return this.attachedNode;
    }

    @Nullable
    public String getSpecificBotName() {
        return this.specificBotName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BiConsumer<T, GuildAuditLogEntryCreateEvent> getConsumer() {
        return this.consumer;
    }

    public Predicate<T> getChecker() {
        return this.checker;
    }

    public boolean isWaitingLogEvent() {
        return this.isWaitingLogEvent;
    }

    @Nullable
    public ActionType getLogType() {
        return this.logType;
    }

    public Predicate<GuildAuditLogEntryCreateEvent> getLogChecker() {
        return this.logChecker;
    }

    @Nullable
    public T getLastEvent() {
        return this.lastEvent;
    }
}

