/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.generator;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.registrations.Classes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.generator.EventValuesGetter;
import net.itsthesky.disky.api.generator.Module;
import net.itsthesky.disky.api.modules.DiSkyModule;
import net.itsthesky.disky.elements.effects.RetrieveEventValue;
import org.bukkit.event.Cancellable;
import org.jetbrains.annotations.Nullable;

public class DocBuilder {
    private final DiSky instance;
    private final Gson gson;

    public DocBuilder(DiSky instance) {
        this.instance = instance;
        this.gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    public void generate(boolean includeTypesInEventValues, @Nullable String specificModule) {
        this.getInstance().getLogger().info("Generating documentation...");
        ArrayList<SimpleDocElement> effects = new ArrayList<SimpleDocElement>();
        for (Object doc : Skript.getEffects()) {
            if (!this.isFromDiSky(doc)) continue;
            effects.add(new SimpleDocElement((SyntaxElementInfo<?>)doc));
        }
        ArrayList<SimpleDocElement> conditions = new ArrayList<SimpleDocElement>();
        for (Object doc : Skript.getConditions()) {
            if (!this.isFromDiSky(doc)) continue;
            conditions.add(new SimpleDocElement((SyntaxElementInfo<?>)doc));
        }
        ArrayList<SimpleDocElement> sections = new ArrayList<SimpleDocElement>();
        for (Object doc : Skript.getSections()) {
            if (!this.isFromDiSky(doc)) continue;
            sections.add(new SimpleDocElement((SyntaxElementInfo<?>)doc));
        }
        ArrayList<EventDocElement> events = new ArrayList<EventDocElement>();
        for (Object doc : Skript.getEvents()) {
            if (!this.isFromDiSky(doc)) continue;
            events.add(new EventDocElement((SkriptEventInfo<?>)doc, includeTypesInEventValues));
        }
        ArrayList<TypeDocElement> types = new ArrayList<TypeDocElement>();
        for (ClassInfo classInfo : Classes.getClassInfos()) {
            if (!this.isFromDiSky(classInfo)) continue;
            types.add(new TypeDocElement(classInfo));
        }
        ArrayList<ExpressionDocElement> expressions = new ArrayList<ExpressionDocElement>();
        Iterator it = Skript.getExpressions();
        while (it.hasNext()) {
            ExpressionInfo doc = (ExpressionInfo)it.next();
            if (!this.isFromDiSky(doc)) continue;
            expressions.add(new ExpressionDocElement(doc));
        }
        if (specificModule != null) {
            effects.removeIf(element -> !specificModule.equals(element.getModule()));
            conditions.removeIf(element -> !specificModule.equals(element.getModule()));
            sections.removeIf(element -> !specificModule.equals(element.getModule()));
            events.removeIf(element -> !specificModule.equals(element.getRequiredPlugins()[0]));
            expressions.removeIf(element -> !specificModule.equals(element.getModule()));
        }
        DocDocument doc = new DocDocument(effects, conditions, sections, types, events, expressions);
        String json = this.gson.toJson(doc);
        try {
            Object fileName = specificModule == null ? "doc.json" : specificModule + ".json";
            Files.write(new File(this.getInstance().getDataFolder(), (String)fileName).toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.getInstance().getLogger().severe("Could not write documentation to file!");
            e.printStackTrace();
        }
        this.getInstance().getLogger().info("Successfully generated documentation!");
    }

    public DiSky getInstance() {
        return this.instance;
    }

    public Gson getGson() {
        return this.gson;
    }

    private boolean isFromDiSky(Object element) {
        SkriptAddon addon;
        if (element instanceof SkriptEventInfo) {
            addon = DocBuilder.getAddon((SkriptEventInfo)element);
        } else if (element instanceof SyntaxElementInfo) {
            addon = DocBuilder.getAddon((SyntaxElementInfo)element);
        } else if (element instanceof ClassInfo) {
            addon = DocBuilder.getAddon((ClassInfo)element);
        } else {
            return false;
        }
        if (addon == null) {
            Class<?> clazz = this.getElementClass(element);
            if (clazz == null) {
                return false;
            }
            for (DiSkyModule module : DiSky.getModuleManager().getModules()) {
                String modulePackage = module.getClass().getPackage().getName();
                String elementPackage = clazz.getPackage().getName();
                if (!elementPackage.contains(modulePackage)) continue;
                return true;
            }
        }
        return addon != null && addon == DiSky.getAddonInstance();
    }

    public static boolean isFromModule(SyntaxElementInfo<?> info, DiSkyModule module) {
        String modulePackage = module.getClass().getPackage().getName();
        String elementPackage = info.getElementClass().getPackage().getName();
        return elementPackage.contains(modulePackage);
    }

    public static boolean isFromModule(ClassInfo<?> info, DiSkyModule module) {
        String modulePackage = module.getClass().getPackage().getName();
        String elementPackage = info.getC().getPackage().getName();
        return elementPackage.contains(modulePackage);
    }

    private Class<?> getElementClass(Object element) {
        if (element instanceof SkriptEventInfo) {
            return ((SkriptEventInfo)element).getElementClass();
        }
        if (element instanceof SyntaxElementInfo) {
            return ((SyntaxElementInfo)element).getElementClass();
        }
        if (element instanceof ClassInfo) {
            return ((ClassInfo)element).getC();
        }
        return null;
    }

    @Nullable
    public static SkriptAddon getAddon(SkriptEventInfo<?> eventInfo) {
        return DocBuilder.getAddon(eventInfo.originClassPath);
    }

    @Nullable
    public static SkriptAddon getAddon(ClassInfo<?> classInfo) {
        if (classInfo.getParser() != null) {
            return DocBuilder.getAddon(classInfo.getParser().getClass().getName());
        }
        if (classInfo.getSerializer() != null) {
            return DocBuilder.getAddon(classInfo.getSerializer().getClass().getName());
        }
        if (classInfo.getChanger() != null) {
            return DocBuilder.getAddon(classInfo.getChanger().getClass().getName());
        }
        return null;
    }

    @Nullable
    public static SkriptAddon getAddon(SyntaxElementInfo<?> elementInfo) {
        return DocBuilder.getAddon(elementInfo.getElementClass().getName());
    }

    @Nullable
    public static SkriptAddon getAddon(String clazzName) {
        if (clazzName.startsWith("ch.njol.skript")) {
            return Skript.getAddonInstance();
        }
        for (SkriptAddon addon : Skript.getAddons()) {
            if (!clazzName.startsWith(addon.plugin.getClass().getPackage().getName())) continue;
            return addon;
        }
        return null;
    }

    private static String getAnnotationOr(SyntaxElementInfo<?> elementInfo, Class<? extends Annotation> annotationClass, String defaultValue) {
        Class clazz = elementInfo.getElementClass();
        if (!clazz.isAnnotationPresent(annotationClass)) {
            return defaultValue;
        }
        Annotation annotation = clazz.getAnnotation(annotationClass);
        try {
            return (String)annotationClass.getDeclaredMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return defaultValue;
        }
    }

    private static String parseClassInfo(Class<?> clazz) {
        ClassInfo classInfo = Classes.getExactClassInfo(clazz);
        return classInfo == null ? null : classInfo.getCodeName();
    }

    private static String[] getAnnotationOrs(SyntaxElementInfo<?> elementInfo, Class<? extends Annotation> annotationClass, String[] defaultValue) {
        Class clazz = elementInfo.getElementClass();
        if (!clazz.isAnnotationPresent(annotationClass)) {
            return defaultValue;
        }
        Annotation annotation = clazz.getAnnotation(annotationClass);
        try {
            return (String[])annotationClass.getDeclaredMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return defaultValue;
        }
    }

    private static boolean parseCancellable(SkriptEventInfo<?> info) {
        boolean cancellable = true;
        for (Class clazz : info.events) {
            if (Cancellable.class.isAssignableFrom(clazz)) continue;
            cancellable = false;
            break;
        }
        return cancellable;
    }

    private static String[] parseValues(SkriptEventInfo<?> info, boolean includeTimes) {
        HashSet<CallSite> eventValues = new HashSet<CallSite>();
        Class[][] values = EventValuesGetter.getEventValues(info.events);
        int time = -1;
        Class[][] classArray = values;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class[] c;
            for (Class clazz : c = classArray[i]) {
                String codeName = Classes.getExactClassName((Class)clazz);
                if (codeName == null) continue;
                eventValues.add((CallSite)((Object)("event-" + codeName + (includeTimes ? (time == 1 ? " (new)" : (time == -1 ? " (past)" : "")) : ""))));
            }
            ++time;
        }
        return eventValues.toArray(new String[0]);
    }

    public static class SimpleDocElement {
        @Nullable
        private final String id;
        @Nullable
        private final String name;
        @Nullable
        private final String since;
        @Nullable
        private final String[] description;
        @Nullable
        private final String[] patterns;
        @Nullable
        private final String[] examples;
        @Nullable
        private final String[] requiredPlugins;
        @Nullable
        private final String module;

        public SimpleDocElement(SyntaxElementInfo<?> info) {
            this.id = DocBuilder.getAnnotationOr(info, DocumentationId.class, info.getElementClass().getSimpleName());
            this.name = DocBuilder.getAnnotationOr(info, Name.class, null);
            this.description = DocBuilder.getAnnotationOrs(info, Description.class, null);
            this.patterns = info.getPatterns();
            this.examples = DocBuilder.getAnnotationOrs(info, Examples.class, null);
            this.since = DocBuilder.getAnnotationOr(info, Since.class, null);
            this.requiredPlugins = DocBuilder.getAnnotationOrs(info, RequiredPlugins.class, null);
            this.module = DocBuilder.getAnnotationOr(info, Module.class, null);
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public String[] getDescription() {
            return this.description;
        }

        public String[] getPatterns() {
            return this.patterns;
        }

        public String[] getExamples() {
            return this.examples;
        }

        @Nullable
        public String getSince() {
            return this.since;
        }

        public String[] getRequiredPlugins() {
            return this.requiredPlugins;
        }

        @Nullable
        public String getModule() {
            return this.module;
        }
    }

    public static class EventDocElement {
        @Nullable
        private final String id;
        @Nullable
        private final String name;
        @Nullable
        private final String since;
        @Nullable
        private final String[] description;
        @Nullable
        private final String[] patterns;
        @Nullable
        private final String[] examples;
        @Nullable
        private final String[] requiredPlugins;
        @Nullable
        private final String[] eventValues;
        @Nullable
        private final String[] retrieveValues;
        private final boolean cancellable;

        public EventDocElement(SkriptEventInfo<?> info, boolean inculdeTimes) {
            this.id = info.getId();
            this.name = info.getName();
            this.description = info.getDescription();
            this.patterns = info.getPatterns();
            this.examples = info.getExamples();
            this.since = info.getSince();
            this.requiredPlugins = info.getRequiredPlugins();
            this.eventValues = DocBuilder.parseValues(info, inculdeTimes);
            this.cancellable = DocBuilder.parseCancellable(info);
            this.retrieveValues = (String[])((List)RetrieveEventValue.VALUES.getOrDefault(info.events[0], new ArrayList())).stream().map(RetrieveEventValue.RetrieveValueInfo::getCodeName).toArray(String[]::new);
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public String[] getDescription() {
            return this.description;
        }

        public String[] getPatterns() {
            return this.patterns;
        }

        public String[] getExamples() {
            return this.examples;
        }

        @Nullable
        public String getSince() {
            return this.since;
        }

        public String[] getRequiredPlugins() {
            return this.requiredPlugins;
        }

        public String[] getEventValues() {
            return this.eventValues;
        }

        public String[] getRetrieveValues() {
            return this.retrieveValues;
        }

        public boolean isCancellable() {
            return this.cancellable;
        }
    }

    public static class TypeDocElement {
        @Nullable
        private final String id;
        @Nullable
        private final String name;
        @Nullable
        private final String since;
        @Nullable
        private final String codeName;
        @Nullable
        private final String[] description;
        @Nullable
        private final String[] examples;

        public TypeDocElement(ClassInfo<?> classInfo) {
            this.id = classInfo.getDocumentationID();
            this.name = classInfo.getDocName();
            this.since = classInfo.getSince();
            this.codeName = classInfo.getCodeName();
            this.description = classInfo.getDescription();
            this.examples = classInfo.getExamples();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getSince() {
            return this.since;
        }

        public String getCodeName() {
            return this.codeName;
        }

        public String[] getDescription() {
            return this.description;
        }

        public String[] getExamples() {
            return this.examples;
        }
    }

    public static class ExpressionDocElement
    extends SimpleDocElement {
        private final String returnType;

        public ExpressionDocElement(ExpressionInfo<?, ?> info) {
            super((SyntaxElementInfo<?>)info);
            this.returnType = DocBuilder.parseClassInfo(info.getReturnType());
        }

        public String getReturnType() {
            return this.returnType;
        }
    }

    public static class DocDocument {
        private final EventDocElement[] events;
        private final TypeDocElement[] types;
        private final SimpleDocElement[] conditions;
        private final SimpleDocElement[] effects;
        private final SimpleDocElement[] sections;
        private final SimpleDocElement[] expressions;

        public DocDocument(List<SimpleDocElement> effects, List<SimpleDocElement> conditions, List<SimpleDocElement> sections, List<TypeDocElement> types, List<EventDocElement> events, List<ExpressionDocElement> expressions) {
            this.effects = effects.toArray(new SimpleDocElement[0]);
            this.conditions = conditions.toArray(new SimpleDocElement[0]);
            this.sections = sections.toArray(new SimpleDocElement[0]);
            this.events = events.toArray(new EventDocElement[0]);
            this.expressions = expressions.toArray(new SimpleDocElement[0]);
            this.types = types.toArray(new TypeDocElement[0]);
        }

        public EventDocElement[] getEvents() {
            return this.events;
        }

        public SimpleDocElement[] getConditions() {
            return this.conditions;
        }

        public SimpleDocElement[] getEffects() {
            return this.effects;
        }

        public SimpleDocElement[] getSections() {
            return this.sections;
        }

        public SimpleDocElement[] getExpressions() {
            return this.expressions;
        }

        public TypeDocElement[] getTypes() {
            return this.types;
        }
    }
}

