/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.ParseLogHandler;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryData;

public class BetterExpressionEntryData<T>
extends EntryData<List<Expression<? extends T>>> {
    private static final Message M_IS = new Message("is");
    private final Class<T> returnType;
    private final int flags;

    public BetterExpressionEntryData(String key, @Nullable List<Expression<? extends T>> defaultValue, boolean optional, Class<T> returnType, int flags) {
        super(key, defaultValue, optional);
        this.returnType = returnType;
        this.flags = flags;
    }

    public BetterExpressionEntryData(String key, @Nullable List<Expression<? extends T>> defaultValue, boolean optional, Class<T> returnType) {
        this(key, defaultValue, optional, returnType, 3);
    }

    @Nullable
    public List<Expression<? extends T>> getValue(@NotNull Node node) {
        if (node instanceof SectionNode) {
            SectionNode sectionNode = (SectionNode)node;
            ArrayList<Expression<T>> expressions = new ArrayList<Expression<T>>();
            for (Node subNode : sectionNode) {
                String value = subNode.getKey();
                Expression<T> expression = this.parseExpression(value);
                if (expression == null) continue;
                expressions.add(expression);
            }
            return expressions;
        }
        if (node instanceof SimpleNode) {
            SimpleNode simpleNode = (SimpleNode)node;
            String key = simpleNode.getKey();
            if (key == null) {
                return null;
            }
            String value = ScriptLoader.replaceOptions((String)key).substring(this.getKey().length() + ": ".length());
            Expression<T> expression = this.parseExpression(value);
            if (expression != null) {
                return List.of(expression);
            }
            return null;
        }
        return null;
    }

    public void preValidate(Node node) {
        if (node instanceof SectionNode) {
            SectionNode sectionNode = (SectionNode)node;
            for (Node subNode : sectionNode) {
                String value = subNode.getKey();
                this.parseExpression(value);
            }
        } else if (node instanceof SimpleNode) {
            SimpleNode simpleNode = (SimpleNode)node;
            String key = simpleNode.getKey();
            if (key == null) {
                return;
            }
            String value = ScriptLoader.replaceOptions((String)key).substring(this.getKey().length() + ": ".length());
            this.parseExpression(value);
        }
    }

    private Expression<? extends T> parseExpression(String value) {
        Expression expression;
        try (ParseLogHandler log = new ParseLogHandler().start();){
            expression = new SkriptParser(value, this.flags, ParseContext.DEFAULT).parseExpression(new Class[]{this.returnType});
            if (expression == null) {
                log.printError("'" + value + "' " + String.valueOf(M_IS) + " " + SkriptParser.notOfType((Class[])new Class[]{this.returnType}), ErrorQuality.NOT_AN_EXPRESSION);
            }
        }
        return expression;
    }

    public boolean canCreateWith(@NotNull Node node) {
        if (node instanceof SectionNode) {
            String key = node.getKey();
            if (key == null) {
                return false;
            }
            key = ScriptLoader.replaceOptions((String)key);
            return this.getKey().equalsIgnoreCase(key);
        }
        if (node instanceof SimpleNode) {
            String key = node.getKey();
            if (key == null) {
                return false;
            }
            key = ScriptLoader.replaceOptions((String)key);
            return key.startsWith(this.getKey() + ": ");
        }
        return false;
    }
}

