/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.skript.reflects;

import ch.njol.skript.lang.ExpressionType;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatchers;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.DiSkyRegistry;
import net.itsthesky.disky.api.skript.reflects.MultipleReflectGetterExpression;
import net.itsthesky.disky.api.skript.reflects.ReflectClassFactory;
import net.itsthesky.disky.api.skript.reflects.ReflectGetterExpression;
import org.bukkit.event.Event;

public class ReflectEventExpressionFactory {
    private static final AtomicInteger COUNT = new AtomicInteger(1);

    public static <T, E extends Event> void registerEventExpression(String pattern, Class<E> eventClass, Class<T> expressionClass, Function<E, T> converter) {
        ReflectEventExpressionFactory.registerSingleEventExpression(pattern, eventClass, expressionClass, converter);
    }

    public static <T, E extends Event> void registerSingleEventExpression(String pattern, Class<E> eventClass, Class<T> expressionClass, Function<E, T> converter) {
        try {
            Class elementClass = new ByteBuddy().redefine(ReflectGetterExpression.class).name("net.itsthesky.disky.elements.reflects.ReflectGetterExpression_" + COUNT.incrementAndGet()).method(ElementMatchers.named("convert")).intercept(MethodDelegation.to(new ReflectClassFactory.SingleConvertMethodInterceptor<E, T>(converter))).method(ElementMatchers.named("getValue")).intercept(MethodDelegation.to(new ReflectClassFactory.PropertyNameMethodInterceptor(ReflectEventExpressionFactory.stripPattern(pattern)))).method(ElementMatchers.named("getEvent")).intercept(MethodDelegation.to(new ReflectClassFactory.ClassResultMethodInterceptor(eventClass))).method(ElementMatchers.named("getReturnType")).intercept(MethodDelegation.to(new ReflectClassFactory.ClassResultMethodInterceptor(expressionClass))).make().load(ReflectGetterExpression.class.getClassLoader()).getLoaded();
            DiSkyRegistry.registerExpression(elementClass, expressionClass, ExpressionType.SIMPLE, pattern);
            DiSky.debug("Registered the event expression " + pattern + " with the class " + elementClass.getName());
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot register the event expression " + pattern, ex);
        }
    }

    public static <T, E extends Event> void registerListEventExpression(String pattern, Class<E> eventClass, Class<T> expressionClass, Function<E, T[]> converter) {
        try {
            Class elementClass = new ByteBuddy().redefine(MultipleReflectGetterExpression.class).name("net.itsthesky.disky.elements.reflects.MultipleReflectGetterExpression_" + COUNT.incrementAndGet()).method(ElementMatchers.named("gets")).intercept(MethodDelegation.to(new ReflectClassFactory.MultipleConvertMethodInterceptor(converter))).method(ElementMatchers.named("getValue")).intercept(MethodDelegation.to(new ReflectClassFactory.PropertyNameMethodInterceptor(ReflectEventExpressionFactory.stripPattern(pattern)))).method(ElementMatchers.named("getEvent")).intercept(MethodDelegation.to(new ReflectClassFactory.ClassResultMethodInterceptor(eventClass))).method(ElementMatchers.named("getReturnType")).intercept(MethodDelegation.to(new ReflectClassFactory.ClassResultMethodInterceptor(expressionClass))).make().load(MultipleReflectGetterExpression.class.getClassLoader()).getLoaded();
            DiSkyRegistry.registerExpression(elementClass, expressionClass, ExpressionType.SIMPLE, pattern);
            DiSky.debug("Registered the event expression " + pattern + " with the class " + elementClass.getName());
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot register the event expression " + pattern, ex);
        }
    }

    private static String stripPattern(String pattern) {
        return pattern.replace("(", "").replace(")", "").replace("[", "").replace("]", "").replace("|", "");
    }
}

