/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.skript.reflects.state;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatchers;
import net.itsthesky.disky.api.DiSkyRegistry;
import net.itsthesky.disky.api.skript.INodeHolder;
import net.itsthesky.disky.api.skript.reflects.state.DiSkyStateCondition;
import net.itsthesky.disky.api.skript.reflects.state.DiSkyStateProperty;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import net.itsthesky.disky.managers.ConfigManager;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public final class SkriptStateRegistry {
    private static final AtomicInteger COUNT = new AtomicInteger(0);

    public static <T> void register(Class<T> typeClass, String typeName, String stateName, Function<T, Boolean> getter, StateSetter<T> setter) {
        Class conditionClass = new ByteBuddy().redefine(DiSkyStateCondition.class).name("net.itsthesky.disky.api.skript.reflects.state.CondState_" + COUNT.incrementAndGet()).method(ElementMatchers.named("check")).intercept(MethodDelegation.to(new CheckMethod<T>(getter))).method(ElementMatchers.named("getPropertyName")).intercept(MethodDelegation.to(new PropertyNameMethodInterceptor(stateName + " state"))).make().load(typeClass.getClassLoader()).getLoaded();
        DiSkyRegistry.registerPropertyCondition(conditionClass, stateName, typeName);
        Class propertyClass = new ByteBuddy().redefine(DiSkyStateProperty.class).name("net.itsthesky.disky.api.skript.reflects.state.PropState_" + COUNT.incrementAndGet()).method(ElementMatchers.named("convert")).intercept(MethodDelegation.to(new CheckMethod<T>(getter))).method(ElementMatchers.named("getPropertyName")).intercept(MethodDelegation.to(new PropertyNameMethodInterceptor(stateName + " state"))).method(ElementMatchers.named("change0")).intercept(MethodDelegation.to(new ChangeMethod<T>(setter))).make().load(typeClass.getClassLoader()).getLoaded();
        DiSkyRegistry.registerProperty(propertyClass, Boolean.class, stateName + " state", typeName);
    }

    public static class CheckMethod<T> {
        private final Function<T, Boolean> getter;

        public CheckMethod(Function<T, Boolean> getter) {
            this.getter = getter;
        }

        @RuntimeType
        public Object intercept(@This Object element, @AllArguments Object[] allArguments) {
            try {
                return this.getter.apply(allArguments[0]);
            }
            catch (Exception ex) {
                if (ConfigManager.get("debug", false).booleanValue()) {
                    ex.printStackTrace();
                }
                DiSkyRuntimeHandler.error(ex, ((INodeHolder)element).getNode());
                return false;
            }
        }
    }

    public static class PropertyNameMethodInterceptor {
        private final String stateName;

        public PropertyNameMethodInterceptor(String stateName) {
            this.stateName = stateName;
        }

        @RuntimeType
        public Object intercept(@AllArguments Object[] allArguments) {
            return this.stateName;
        }
    }

    public static class ChangeMethod<T> {
        private final StateSetter<T> setter;

        public ChangeMethod(StateSetter<T> setter) {
            this.setter = setter;
        }

        @RuntimeType
        public void intercept(@This Object expr, @AllArguments Object[] allArguments) {
            Event e = (Event)allArguments[0];
            Object[] delta = (Object[])allArguments[1];
            Changer.ChangeMode mode = (Changer.ChangeMode)allArguments[2];
            boolean async = (Boolean)allArguments[3];
            SimplePropertyExpression property = (SimplePropertyExpression)expr;
            try {
                @Nullable Boolean value = mode == Changer.ChangeMode.RESET ? null : Boolean.valueOf((Boolean)delta[0]);
                ArrayList<Object> entities = new ArrayList<Object>();
                for (Object raw : property.getExpr().getArray(e)) {
                    entities.add(raw);
                }
                for (Object e2 : entities) {
                    this.setter.set(e2, async, value);
                }
            }
            catch (Exception ex) {
                if (ConfigManager.get("debug", false).booleanValue()) {
                    ex.printStackTrace();
                }
                DiSkyRuntimeHandler.error(ex, ((INodeHolder)property).getNode());
            }
        }
    }

    public static interface StateSetter<T> {
        public void set(T var1, boolean var2, @Nullable Boolean var3);
    }
}

