/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.core;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Timespan;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.events.Event;
import net.itsthesky.disky.BotApplication;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.events.SimpleDiSkyEvent;
import net.itsthesky.disky.core.BotOptions;
import net.itsthesky.disky.elements.structures.context.ContextCommandManager;
import net.itsthesky.disky.elements.structures.slash.BotReadyWaiter;
import net.itsthesky.disky.elements.structures.slash.SlashManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Bot {
    private final long startedTime;
    private final String name;
    private final JDA instance;
    @Nullable
    private final BotApplication application;
    private final boolean forceReload;
    private final BotOptions options;
    private final SlashManager slashManager;
    private final ContextCommandManager contextManager;

    public Bot(String name, JDA instance, BotOptions options, @Nullable BotApplication application, boolean forceReload) {
        this.name = name;
        this.application = application;
        this.instance = instance;
        this.forceReload = forceReload;
        this.startedTime = System.currentTimeMillis();
        this.options = options;
        this.slashManager = SlashManager.getManager(this);
        this.contextManager = ContextCommandManager.getManager(this);
        BotReadyWaiter.onBotLoaded(this);
    }

    public String getName() {
        return this.name;
    }

    public boolean isForceReload() {
        return this.forceReload;
    }

    public JDA getInstance() {
        return this.instance;
    }

    @Nullable
    public BotApplication getApplication() {
        return this.application;
    }

    public <T> T findSimilarEntity(T original) {
        if (original instanceof Guild) {
            return (T)this.getInstance().getGuildById(((Guild)original).getId());
        }
        if (original instanceof User) {
            return (T)this.getInstance().getUserById(((User)original).getId());
        }
        if (original instanceof Role) {
            return (T)this.getInstance().getRoleById(((Role)original).getId());
        }
        return original;
    }

    public <C extends Channel> C findMessageChannel(C original) {
        return (C)this.instance.getChannelById(original.getClass(), original.getId());
    }

    public boolean coreIsEquals(JDA core) {
        return this.getInstance().getSelfUser().getId().equals(core.getSelfUser().getId());
    }

    public Timespan getUptime() {
        return new Timespan(System.currentTimeMillis() - this.startedTime);
    }

    public void shutdown(boolean force) {
        if (force) {
            this.getInstance().shutdownNow();
        } else {
            this.getInstance().shutdown();
        }
        DiSky.getManager().removeBot(this);
    }

    public String getDiscordName() {
        return this.getInstance().getSelfUser().getEffectiveName();
    }

    public BotOptions getOptions() {
        return this.options;
    }

    @Nullable
    public static Bot any() {
        return DiSky.getManager().findAny();
    }

    @NotNull
    public static Bot fromEvent(org.bukkit.event.Event event) {
        if (event instanceof SimpleDiSkyEvent) {
            return Bot.byJDA(((Event)((SimpleDiSkyEvent)event).getJDAEvent()).getJDA());
        }
        return Bot.any();
    }

    @NotNull
    public static Bot fromContext(@Nullable Expression<Bot> expr, org.bukkit.event.Event event) {
        Bot first = expr == null ? null : (Bot)expr.getSingle(event);
        return first == null ? Bot.fromEvent(event) : first;
    }

    @Nullable
    public static Bot byJDA(JDA instance) {
        return DiSky.getManager().fromJDA(instance);
    }

    public SlashManager getSlashManager() {
        return this.slashManager;
    }

    public ContextCommandManager getContextManager() {
        return this.contextManager;
    }
}

