/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.core;

import java.util.WeakHashMap;
import net.dv8tion.jda.api.audit.ActionType;
import net.dv8tion.jda.api.events.guild.GuildAuditLogEntryCreateEvent;
import net.dv8tion.jda.api.events.guild.member.GuildMemberRemoveEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.events.members.MemberBanEvent;
import net.itsthesky.disky.elements.events.members.MemberKickEvent;

public class MemberRemoveEventListener
extends ListenerAdapter {
    private final WeakHashMap<Long, MemberKickEvent.BukkitMemberKickEvent> WaitingKicks = new WeakHashMap();
    private final WeakHashMap<Long, MemberBanEvent.BukkitMemberBanEvent> WaitingBans = new WeakHashMap();

    @Override
    public void onGuildMemberRemove(GuildMemberRemoveEvent event) {
        this.WaitingKicks.put(event.getGuild().getIdLong(), new MemberKickEvent.BukkitMemberKickEvent(event.getUser(), event.getGuild(), event.getJDA()));
        this.WaitingBans.put(event.getGuild().getIdLong(), new MemberBanEvent.BukkitMemberBanEvent(event.getUser(), event.getGuild(), event.getJDA()));
    }

    @Override
    public void onGuildAuditLogEntryCreate(GuildAuditLogEntryCreateEvent event) {
        if (event.getEntry().getType() == ActionType.KICK && this.WaitingKicks.containsKey(event.getGuild().getIdLong())) {
            MemberKickEvent.BukkitMemberKickEvent e = this.WaitingKicks.remove(event.getGuild().getIdLong());
            e.author = event.getGuild().getMemberById(event.getEntry().getUserIdLong());
            SkriptUtils.dispatchEvent(e);
        } else if (event.getEntry().getType() == ActionType.BAN && this.WaitingBans.containsKey(event.getGuild().getIdLong())) {
            MemberBanEvent.BukkitMemberBanEvent e = this.WaitingBans.remove(event.getGuild().getIdLong());
            e.author = event.getGuild().getMemberById(event.getEntry().getUserIdLong());
            SkriptUtils.dispatchEvent(e);
        }
    }
}

