/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.core;

import ch.njol.skript.lang.Trigger;
import java.util.HashMap;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.elements.events.rework.ReactionEvents;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactionListener
extends ListenerAdapter {
    public static final HashMap<Long, ReactionInfo> waiters = new HashMap();

    @Override
    public void onMessageReactionAdd(@NotNull MessageReactionAddEvent event) {
        ReactionInfo info = waiters.getOrDefault(event.getMessageIdLong(), null);
        if (info == null) {
            return;
        }
        Emote reactedEmote = Emote.fromUnion(event.getEmoji());
        if (!reactedEmote.isSimilar(info.getEmote())) {
            return;
        }
        if (!info.canUserExecute(event.getUserIdLong())) {
            return;
        }
        if (info.getSelfID().equals(event.getUserIdLong())) {
            return;
        }
        Event e = ReactionEvents.REACTION_ADD.createBukkitInstance(event);
        if (info.isAlreadyFired()) {
            waiters.remove(event.getMessageIdLong());
        } else {
            info.execute(e);
        }
    }

    public static class ReactionInfo {
        private boolean alreadyFired = false;
        private final boolean oneTime;
        private final Emote emote;
        private final Long messageId;
        @NotNull
        private final Long selfID;
        @Nullable
        private final Long userId;
        @Nullable
        private final Trigger trigger;

        public ReactionInfo(boolean oneTime, Emote emote, Long messageId, @NotNull Long selfID, @Nullable User user, @Nullable Trigger trigger) {
            this.oneTime = oneTime;
            this.emote = emote;
            this.messageId = messageId;
            this.selfID = selfID;
            this.userId = user == null ? null : Long.valueOf(user.getIdLong());
            this.trigger = trigger;
        }

        public Emote getEmote() {
            return this.emote;
        }

        public Long getMessageId() {
            return this.messageId;
        }

        public void setAlreadyFired(boolean alreadyFired) {
            this.alreadyFired = alreadyFired;
        }

        public boolean isAlreadyFired() {
            return this.alreadyFired;
        }

        public boolean isOneTime() {
            return this.oneTime;
        }

        @Nullable
        public Long getUserId() {
            return this.userId;
        }

        @NotNull
        public Long getSelfID() {
            return this.selfID;
        }

        public void execute(Event event) {
            if (this.isOneTime()) {
                this.setAlreadyFired(true);
            }
            if (this.getTrigger() != null) {
                this.getTrigger().execute(event);
            }
        }

        @Nullable
        public Trigger getTrigger() {
            return this.trigger;
        }

        public boolean canUserExecute(long userId) {
            if (this.getUserId() == null) {
                return true;
            }
            return this.getUserId() == userId;
        }
    }
}

