/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.core;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.log.HandlerList;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.ColorRGB;
import ch.njol.skript.util.Date;
import ch.njol.util.Kleenean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URL;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.audit.AuditLogEntry;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.message.GenericMessageEvent;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.ReflectionUtils;
import net.itsthesky.disky.api.events.SimpleDiSkyEvent;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.Utils;
import net.itsthesky.disky.elements.effects.RetrieveEventValue;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.Converter;
import org.skriptlang.skript.lang.entry.EntryValidator;

public final class SkriptUtils {
    @Deprecated
    public static <T> T verifyVar(Expression<T> expression, org.bukkit.event.Event e, T defaultValue) {
        return EasyElement.parseSingle(expression, e, defaultValue);
    }

    public static void sync(Runnable runnable2) {
        Bukkit.getScheduler().runTask((Plugin)DiSky.getInstance(), runnable2);
    }

    public static void stopLog(RetainingLogHandler logger) {
        LogHandler l;
        logger.stop();
        HandlerList handler = ParserInstance.get().getHandlers();
        if (handler == null) {
            return;
        }
        Iterator it = handler.iterator();
        ArrayList<LogHandler> toStop = new ArrayList<LogHandler>();
        while (it.hasNext() && (l = (LogHandler)it.next()) instanceof ParseLogHandler) {
            toStop.add(l);
        }
        toStop.forEach(LogHandler::stop);
        SkriptLogger.logAll((Collection)logger.getLog());
    }

    public static void nukeSectionNode(SectionNode sectionNode) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : sectionNode) {
            nodes.add(node);
        }
        for (Node n : nodes) {
            sectionNode.remove(n);
        }
    }

    public static <T> Expression<T> defaultToEventValue(Expression expr, final Class<T> clazz) {
        if (expr != null) {
            return expr;
        }
        Class[] events = ParserInstance.get().getCurrentEvents();
        for (Class e : events == null ? new Class[]{} : events) {
            final Converter getter = EventValues.getEventValueConverter((Class)e, clazz, (int)0);
            if (getter == null) continue;
            return new SimpleExpression<T>(){

                protected T @NotNull [] get(@NotNull org.bukkit.event.Event e) {
                    Object value = getter.convert((Object)e);
                    if (value == null) {
                        return null;
                    }
                    Object[] arr = (Object[])Array.newInstance(clazz, 1);
                    arr[0] = value;
                    return arr;
                }

                public boolean isSingle() {
                    return true;
                }

                @NotNull
                public Class<? extends T> getReturnType() {
                    return clazz;
                }

                public boolean isDefault() {
                    return true;
                }

                @NotNull
                public String toString(org.bukkit.event.Event e, boolean debug) {
                    return "defaulted event value expression";
                }

                public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
                    return true;
                }
            };
        }
        return null;
    }

    public static void async(Runnable runnable2) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DiSky.getInstance(), runnable2);
    }

    public static <B extends SimpleDiSkyEvent<? extends GenericMessageEvent>> void registerAuthorValue(Class<B> clazz) {
        SkriptUtils.registerAuthorValue(clazz, event -> ((GenericMessageEvent)event.getJDAEvent()).getGuild());
    }

    public static <B extends SimpleDiSkyEvent> void registerAuthorValue(Class<B> bukkitClass, Function<B, Guild> function) {
        SkriptUtils.registerRestValue("author", bukkitClass, event -> ((Guild)function.apply(event)).retrieveAuditLogs(), logs -> ((AuditLogEntry)logs.get(0)).getUser());
    }

    public static <B extends SimpleDiSkyEvent, T, S> void registerRestValue(String codeName, Class<B> bukkitClass, Function<B, RestAction<S>> function, Function<S, T> converter) {
        List current = RetrieveEventValue.VALUES.getOrDefault(bukkitClass, new ArrayList());
        current.add(new RetrieveEventValue.RetrieveValueInfo<B, S, S>(bukkitClass, codeName, function, converter));
        RetrieveEventValue.VALUES.put(bukkitClass, current);
    }

    public static void registerRawRestValue(String codeName, Class<? extends SimpleDiSkyEvent> bukkitClass, Function function, Function converter) {
        List current = RetrieveEventValue.VALUES.getOrDefault(bukkitClass, new ArrayList());
        current.add(new RetrieveEventValue.RetrieveValueInfo(bukkitClass, codeName, function, converter));
        RetrieveEventValue.VALUES.put(bukkitClass, current);
    }

    public static <B extends SimpleDiSkyEvent, T> void registerRestValue(String codeName, Class<B> bukkitClass, Function<B, RestAction<T>> function) {
        SkriptUtils.registerRestValue(codeName, bukkitClass, function, entity -> entity);
    }

    public static <B extends org.bukkit.event.Event, T> void registerValue(Class<B> bukkitClass, Class<T> entityClass, final Function<B, T> function, int time) {
        if (entityClass.isArray()) {
            Logger.getLogger("DiSky").severe("Class " + ReflectionUtils.getCurrentClass().getName() + " still use the single value registration while providing an array value.");
        }
        EventValues.registerEventValue(bukkitClass, entityClass, (Converter)new Converter<B, T>(){

            @Nullable
            public T convert(B arg) {
                try {
                    return function.apply(arg);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }, (int)time);
    }

    public static <B extends org.bukkit.event.Event, T> void registerValue(Class<B> bukkitClass, Class<T> entityClass, Function<B, T> function) {
        SkriptUtils.registerValue(bukkitClass, entityClass, function, 0);
        if (entityClass.equals(GuildChannel.class)) {
            SkriptUtils.registerValue(bukkitClass, Channel.class, b -> (Channel)function.apply(b));
        }
    }

    public static <E extends Event, B extends SimpleDiSkyEvent<E>> void registerBotValue(Class<B> bukkitClass) {
        SkriptUtils.registerValue(bukkitClass, Bot.class, e -> {
            JDA jda = ((Event)e.getJDAEvent()).getJDA();
            return DiSky.getManager().fromJDA(jda);
        });
    }

    public static void createRegisteringSpace(Runnable code) {
        if (Skript.isAcceptRegistrations()) {
            code.run();
        } else {
            try {
                Field field = Skript.class.getDeclaredField("acceptRegistrations");
                field.setAccessible(true);
                field.set(null, true);
                code.run();
                field.setAccessible(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Color convert(java.awt.Color color) {
        if (color == null) {
            return null;
        }
        return new ColorRGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static java.awt.Color convert(Color color) {
        if (color == null) {
            return null;
        }
        return new java.awt.Color(color.asBukkitColor().getRed(), color.asBukkitColor().getGreen(), color.asBukkitColor().getBlue());
    }

    @SafeVarargs
    public static Class<? extends org.bukkit.event.Event>[] addEventClasses(Class<? extends org.bukkit.event.Event> ... classes) {
        ArrayList<Class> current = new ArrayList<Class>(Arrays.asList(ParserInstance.get().getCurrentEvents()));
        current.addAll(Arrays.asList(classes));
        return current.toArray(new Class[0]);
    }

    @SafeVarargs
    public static List<TriggerItem> loadCode(SectionNode sectionNode, Class<? extends org.bukkit.event.Event> ... classes) {
        if (classes.length > 0) {
            ParserInstance.get().setCurrentEvent("custom section node", (Class[])classes);
        }
        return ScriptLoader.loadItems((SectionNode)sectionNode);
    }

    public static OffsetDateTime convertDate(Date date) {
        long ms = date.getTime();
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(ms), ZoneId.systemDefault());
    }

    public static void error(Node node, String message2) {
        DiSkyRuntimeHandler.error(new Exception(message2), node);
        Node previous = ParserInstance.get().getNode();
        ParserInstance.get().setNode(node);
        Skript.error((String)message2);
        ParserInstance.get().setNode(previous);
    }

    public static void warning(Node node, String message2) {
        Node previous = ParserInstance.get().getNode();
        ParserInstance.get().setNode(node);
        Skript.warning((String)message2);
        ParserInstance.get().setNode(previous);
    }

    public static Date convertDateTime(@Nullable OffsetDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return new Date(dateTime.toInstant().toEpochMilli());
    }

    public static void dispatchEvent(org.bukkit.event.Event e) {
        SkriptUtils.sync(() -> Bukkit.getPluginManager().callEvent(e));
    }

    public static EntryValidator custom() {
        return EntryValidator.builder().unexpectedNodeTester(node -> false).build();
    }

    public static boolean validateSnowflake(@Nullable String input, @Nullable Node node) {
        @Nullable String errorMess = null;
        if (input == null) {
            errorMess = "The provided ID is null!";
        } else if (!input.matches("\\d{17,20}")) {
            errorMess = "The provided ID is not a valid snowflake!";
        }
        if (errorMess == null) {
            return true;
        }
        String message2 = "Unable to validate the snowflake ID '" + input + "': " + errorMess;
        DiSkyRuntimeHandler.error(new IllegalArgumentException(message2), node);
        return false;
    }

    public static Icon parseIcon(String input) {
        if (input == null) {
            return null;
        }
        if (Utils.isURL(input)) {
            try {
                return Icon.from(new URL(input).openStream());
            }
            catch (IOException ex) {
                DiSky.getErrorHandler().exception(null, ex);
                return null;
            }
        }
        File iconFile = new File(input);
        if (iconFile == null || !iconFile.exists()) {
            return null;
        }
        try {
            return Icon.from(new FileInputStream(iconFile));
        }
        catch (IOException ex) {
            DiSky.getErrorHandler().exception(null, ex);
            return null;
        }
    }

    @Nullable
    public static List<Expression<?>> convertToExpressions(Object data) {
        if (data == null) {
            return null;
        }
        ArrayList expressions = new ArrayList();
        if (data.getClass().isArray() || data instanceof List) {
            List<Object> asList2 = data.getClass().isArray() ? Arrays.asList((Object[])data) : (List<Object>)data;
            for (Object obj : asList2) {
                expressions.add((Expression<?>)new SimpleLiteral(obj, false));
            }
        } else {
            expressions.add((Expression<?>)new SimpleLiteral(data, false));
        }
        return expressions;
    }
}

