/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.regex.MatchResult;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.SpecificBotEffect;
import net.itsthesky.disky.api.skript.WaiterEffect;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Execute X Using Bot")
@Description(value={"This effect is for utilities purpose.", "It will wrap the actual effect from DiSky and execute it using the specified bot.", "The syntax MUST come from DiSky, and at least ONE bot MUST be loaded (if the specified one is wrong / not loaded)"})
public class BaseBotEffect
extends WaiterEffect<Object> {
    private Expression<Bot> exprBot;
    private SpecificBotEffect<Object> effect;

    @Override
    public boolean initEffect(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.exprBot = expressions[0];
        String rawEffect = ((MatchResult)parseResult.regexes.get(0)).group();
        Effect unparsedEffect = Effect.parse((String)rawEffect, (String)("Can't understand this effect: " + rawEffect));
        if (!(unparsedEffect instanceof SpecificBotEffect)) {
            return false;
        }
        this.effect = (SpecificBotEffect)unparsedEffect;
        return true;
    }

    @Override
    public void runEffect(Event e) {
        @NotNull Bot bot = BaseBotEffect.parseSingle(this.exprBot, e, DiSky.getManager().findAny());
        if (bot == null) {
            DiSky.getErrorHandler().exception(e, new RuntimeException("No bot is currently loaded on the server. You cannot use any DiSky syntaxes without least one loaded."));
            this.restart();
            return;
        }
        this.effect.setNext(this.getNext());
        this.effect.runEffect(e, bot);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "execute " + this.effect.toString(e, debug) + " using bot " + this.exprBot.toString(e, debug);
    }

    static {
        Skript.registerEffect(BaseBotEffect.class, (String[])new String[]{"execute (with|using) [the] %bot% <.+>", "execute <.+> (with|using) [the] %bot%"});
    }
}

