/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.commands;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.Utils;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.commands.Argument;
import net.itsthesky.disky.elements.commands.CommandData;
import net.itsthesky.disky.elements.commands.CommandEvent;
import net.itsthesky.disky.elements.commands.CommandObject;
import net.itsthesky.disky.elements.commands.CommandRegistry;
import org.bukkit.event.Event;

public class CommandFactory {
    private static final CommandFactory INSTANCE = new CommandFactory();
    private final Method PARSE_I;
    private final Pattern commandPattern = Pattern.compile("(?i)^(on )?discord command (\\S+)(\\s+(.+))?$");
    private final Pattern argumentPattern = Pattern.compile("<\\s*(?:(.+?)\\s*:\\s*)?(.+?)\\s*(?:=\\s*([^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?))?\\s*>");
    private final Pattern escape = Pattern.compile("[" + Pattern.quote("(|)<>%\\") + "]");
    private final String listPattern = "\\s*,\\s*|\\s+(and|or|, )\\s+";
    public HashMap<CommandData, CommandObject> commandMap = new HashMap();
    public static List<Argument<?>> currentArguments;

    private CommandFactory() {
        Method _PARSE_I = null;
        try {
            _PARSE_I = SkriptParser.class.getDeclaredMethod("parse_i", String.class);
            _PARSE_I.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            Skript.error((String)"Skript's 'parse_i' method could not be resolved.");
        }
        this.PARSE_I = _PARSE_I;
    }

    public static CommandFactory getInstance() {
        return INSTANCE;
    }

    private String escape(String s) {
        return this.escape.matcher(s).replaceAll("\\\\$0");
    }

    public boolean parseArguments(String args2, CommandObject command, Event event) {
        SkriptParser parser = new SkriptParser(args2, 2, ParseContext.COMMAND);
        SkriptParser.ParseResult res = null;
        try {
            res = (SkriptParser.ParseResult)this.PARSE_I.invoke((Object)parser, command.getPattern());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        List<Argument<?>> arguments = command.getArguments();
        if (res == null) {
            return false;
        }
        assert (arguments.size() == res.exprs.length);
        for (int i = 0; i < res.exprs.length; ++i) {
            if (res.exprs[i] == null) {
                arguments.get(i).setToDefault(event);
                continue;
            }
            arguments.get(i).set(event, res.exprs[i].getArray(event));
        }
        return true;
    }

    public ArrayList<ChannelType> parsePlaces(String[] places) {
        ArrayList<ChannelType> types = new ArrayList<ChannelType>();
        for (String place : places) {
            if (net.itsthesky.disky.core.Utils.equalsAnyIgnoreCase(place, "server", "guild")) {
                types.addAll(Arrays.asList(ChannelType.TEXT, ChannelType.NEWS));
                continue;
            }
            if (net.itsthesky.disky.core.Utils.equalsAnyIgnoreCase(place, "dm", "pm", "direct message", "private message")) {
                types.add(ChannelType.PRIVATE);
                continue;
            }
            if (net.itsthesky.disky.core.Utils.equalsAnyIgnoreCase(place, "thread", "threads")) {
                types.addAll(Arrays.asList(ChannelType.GUILD_PUBLIC_THREAD, ChannelType.GUILD_PRIVATE_THREAD));
                continue;
            }
            if (net.itsthesky.disky.core.Utils.equalsAnyIgnoreCase(place, "voice")) {
                types.add(ChannelType.VOICE);
                continue;
            }
            Skript.error((String)("'executable in' should be any of ['guild', 'dm', 'voice', 'threads'], but found '" + place + "'"));
            return null;
        }
        return types;
    }

    public CommandObject add(SectionNode node) {
        String command = node.getKey();
        if (command == null) {
            return null;
        }
        Matcher matcher = this.commandPattern.matcher(command = ScriptLoader.replaceOptions((String)command));
        if (!matcher.matches()) {
            return null;
        }
        int level = 0;
        for (int i = 0; i < command.length(); ++i) {
            if (command.charAt(i) == '[') {
                ++level;
                continue;
            }
            if (command.charAt(i) != ']') continue;
            if (level == 0) {
                Skript.error((String)"Invalid placement of [optional brackets]");
                return null;
            }
            --level;
        }
        if (level > 0) {
            Skript.error((String)"Invalid amount of [optional brackets]");
            return null;
        }
        command = matcher.group(2);
        String arguments = matcher.group(4);
        if (arguments == null) {
            arguments = "";
        }
        StringBuilder pattern = new StringBuilder();
        currentArguments = new ArrayList();
        ArrayList currentArguments = CommandFactory.currentArguments;
        Matcher m = this.argumentPattern.matcher(arguments);
        int lastEnd = 0;
        int optionals = 0;
        int i = 0;
        while (m.find()) {
            pattern.append(this.escape(arguments.substring(lastEnd, m.start())));
            optionals += StringUtils.count((String)arguments, (char)'[', (int)lastEnd, (int)m.start());
            optionals -= StringUtils.count((String)arguments, (char)']', (int)lastEnd, (int)m.start());
            lastEnd = m.end();
            ClassInfo c = Classes.getClassInfoFromUserInput((String)m.group(2));
            NonNullPair p = Utils.getEnglishPlural((String)m.group(2));
            if (c == null) {
                Skript.error((String)("Unknown type '" + m.group(2) + "'"));
                return null;
            }
            Parser parser = c.getParser();
            if (parser == null || !parser.canParse(ParseContext.COMMAND)) {
                Skript.error((String)("Can't use " + String.valueOf(c) + " as argument of a command"));
                return null;
            }
            Argument arg = Argument.newInstance(m.group(1), c, m.group(3), i, (Boolean)p.getSecond() == false, optionals > 0);
            if (arg == null) {
                return null;
            }
            currentArguments.add(arg);
            if (arg.isOptional() && optionals == 0) {
                pattern.append('[');
                ++optionals;
            }
            pattern.append("%" + (arg.isOptional() ? "-" : "") + Utils.toEnglishPlural((String)c.getCodeName(), (boolean)((Boolean)p.getSecond())) + "%");
            ++i;
        }
        pattern.append(this.escape(arguments.substring(lastEnd)));
        optionals += StringUtils.count((String)arguments, (char)'[', (int)lastEnd);
        optionals -= StringUtils.count((String)arguments, (char)']', (int)lastEnd);
        for (i = 0; i < optionals; ++i) {
            pattern.append(']');
        }
        node.convertToEntries(0);
        if (!CommandRegistry.commandStructure.validate((Node)node)) {
            return null;
        }
        if (!(node.get("trigger") instanceof SectionNode)) {
            return null;
        }
        SectionNode trigger = (SectionNode)node.get("trigger");
        Expression<String> description = this.parseExpression(ScriptLoader.replaceOptions((String)node.get("description", "")));
        String permMessage = ScriptLoader.replaceOptions((String)node.get("permission message", ""));
        Expression<String> usage = this.parseExpression(ScriptLoader.replaceOptions((String)node.get("usage", "")));
        String category = ScriptLoader.replaceOptions((String)node.get("category", ""));
        Timespan cooldownGuild = Timespan.parse((String)ScriptLoader.replaceOptions((String)node.get("guild cooldown", "0 second")));
        if (cooldownGuild == null) {
            Skript.error((String)("Cannot parse a non-timespan cooldown for the discord command. Input: '" + ScriptLoader.replaceOptions((String)node.get("guild cooldown", "")) + "'"));
            return null;
        }
        String cooldownMessage = ScriptLoader.replaceOptions((String)node.get("cooldown message", ""));
        String permList = ScriptLoader.replaceOptions((String)node.get("permissions", ""));
        ArrayList<String> perms = permList.isEmpty() ? new ArrayList() : Arrays.asList(permList.split("\\s*,\\s*|\\s+(and|or|, )\\s+"));
        String aliasesString = ScriptLoader.replaceOptions((String)node.get("aliases", ""));
        List<String> aliases = aliasesString.isEmpty() ? null : Arrays.asList(aliasesString.split("\\s*,\\s*|\\s+(and|or|, )\\s+"));
        ArrayList<Expression<String>> prefixes = new ArrayList<Expression<String>>();
        String rawPrefixes = ScriptLoader.replaceOptions((String)node.get("prefixes", ""));
        if (rawPrefixes.isEmpty()) {
            if (command.length() == 1) {
                prefixes.add((Expression<String>)new SimpleLiteral((Object)"", false));
            } else {
                prefixes.add((Expression<String>)new SimpleLiteral((Object)String.valueOf(command.charAt(0)), false));
                command = command.substring(1);
            }
        } else {
            for (String prefix : rawPrefixes.split("\\s*,\\s*|\\s+(and|or|, )\\s+")) {
                if (prefix.startsWith("\"") && prefix.endsWith("\"")) {
                    prefix = prefix.substring(1, prefix.length() - 1);
                }
                VariableString prefixExpr = VariableString.newInstance((String)prefix, (StringMode)StringMode.MESSAGE);
                try {
                    if (prefixExpr.isSimple()) {
                        prefixExpr = new SimpleLiteral((Object)prefix, false);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                prefixes.add((Expression<String>)prefixExpr);
            }
        }
        String roleString = ScriptLoader.replaceOptions((String)node.get("roles", ""));
        List<String> roles = roleString.isEmpty() ? null : Arrays.asList(roleString.split("\\s*,\\s*|\\s+(and|or|, )\\s+"));
        String botString = ScriptLoader.replaceOptions((String)node.get("bots", ""));
        List<String> bots = botString.isEmpty() ? null : Arrays.asList(botString.split("\\s*,\\s*|\\s+(and|or|, )\\s+"));
        ArrayList<ChannelType> places = this.parsePlaces(ScriptLoader.replaceOptions((String)node.get("executable in", "guild, dm")).split("\\s*,\\s*|\\s+(and|or|, )\\s+"));
        if (places == null) {
            return null;
        }
        CommandFactory.currentArguments = currentArguments;
        CommandObject commandObject = new CommandObject(command, pattern.toString(), currentArguments, prefixes, aliases, description, usage, roles, places, bots, SkriptUtils.loadCode(trigger, CommandEvent.class), perms, permMessage, category, cooldownGuild, cooldownMessage);
        this.commandMap.put(new CommandData(command, commandObject), commandObject);
        return commandObject;
    }

    private Expression<String> parseExpression(String text) {
        if (text.startsWith("\"") && text.endsWith("\"")) {
            text = text.substring(1, text.length() - 1);
        }
        VariableString expr = VariableString.newInstance((String)text, (StringMode)StringMode.MESSAGE);
        try {
            if (expr.isSimple()) {
                expr = new SimpleLiteral((Object)text, false);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return expr;
    }

    public boolean remove(String name) {
        for (CommandData commandData : this.commandMap.keySet()) {
            CommandObject commandObject = commandData.getCommand();
            if (!commandObject.getName().equalsIgnoreCase(name)) continue;
            this.commandMap.remove(commandData);
            return true;
        }
        return false;
    }

    public Collection<CommandData> getCommands() {
        return this.commandMap.keySet();
    }
}

