/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.commands;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.Timespan;
import java.util.ArrayList;
import java.util.List;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.core.Utils;
import net.itsthesky.disky.elements.commands.Argument;
import net.itsthesky.disky.elements.commands.CommandEvent;
import net.itsthesky.disky.elements.commands.CommandFactory;
import org.bukkit.event.Event;

public class CommandObject {
    private final String name;
    private final List<String> aliases;
    private final List<String> roles;
    private final List<String> perms;
    private final List<ChannelType> executableIn;
    private final List<Expression<String>> prefixes;
    private final Expression<String> description;
    private final Expression<String> usage;
    private final String category;
    private final String pattern;
    private final String permMessage;
    private final Timespan cooldownGuild;
    private final String cooldownMessage;
    private final List<TriggerItem> items;
    private final List<String> bots;
    private final List<Argument<?>> arguments;

    public CommandObject(String name, String pattern, List<Argument<?>> arguments, List<Expression<String>> prefixes, List<String> aliases, Expression<String> description, Expression<String> usage, List<String> roles, List<ChannelType> executableIn, List<String> bots, List<TriggerItem> items, List<String> perms, String permMessage, String category, Timespan cooldownGuild, String cooldownMessage) {
        this.name = name;
        if (aliases != null) {
            aliases.removeIf(alias -> alias.equalsIgnoreCase(name));
        }
        this.cooldownGuild = cooldownGuild;
        this.cooldownMessage = cooldownMessage;
        this.aliases = aliases;
        this.roles = roles;
        this.executableIn = executableIn;
        this.description = description;
        this.usage = usage;
        this.pattern = pattern;
        this.prefixes = prefixes;
        this.bots = bots;
        this.perms = perms;
        this.arguments = arguments;
        this.permMessage = permMessage;
        this.category = category;
        this.items = items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean execute(CommandEvent event) {
        ParseLogHandler log;
        block14: {
            block13: {
                block12: {
                    block11: {
                        log = SkriptLogger.startParseLogHandler();
                        boolean ok = CommandFactory.getInstance().parseArguments(event.getArguments(), this, event);
                        if (ok) break block11;
                        boolean bl = false;
                        log.stop();
                        return bl;
                    }
                    if (this.getExecutableIn().contains((Object)event.getMessageChannel().getType())) break block12;
                    boolean bl = false;
                    log.stop();
                    return bl;
                }
                if (this.getRoles() == null || event.getMember() == null || !event.getMember().getRoles().stream().noneMatch(r -> this.getRoles().contains(r.getName()))) break block13;
                boolean bl = false;
                log.stop();
                return bl;
            }
            if (this.bots == null || this.bots.contains(DiSky.getManager().fromJDA(event.getBot()).getName())) break block14;
            boolean bl = false;
            log.stop();
            return bl;
        }
        try {
            block16: {
                break block16;
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            List<Permission> permissions = Utils.parseEnum(Permission.class, this.perms);
            if (event.getGuild() != null && !event.getMember().hasPermission(permissions)) {
                if (this.permMessage != null) {
                    event.getMessageChannel().sendMessage(this.permMessage).queue();
                }
                boolean bl = false;
                return bl;
            }
            SkriptUtils.sync(() -> {
                if (this.items.isEmpty()) {
                    return;
                }
                TriggerItem.walk((TriggerItem)this.items.get(0), (Event)event);
            });
        }
        finally {
            log.stop();
        }
        return true;
    }

    public List<Argument<?>> getArguments() {
        return this.arguments;
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<Expression<String>> getPrefixes() {
        return this.prefixes;
    }

    public Expression<String> getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public String getPermMessage() {
        return this.permMessage;
    }

    public Expression<String> getUsage() {
        return this.usage;
    }

    public List<String> getUsableAliases() {
        ArrayList<String> usableAliases = new ArrayList<String>();
        usableAliases.add(this.getName());
        if (this.getAliases() != null) {
            usableAliases.addAll(this.getAliases());
        }
        return usableAliases;
    }

    public List<ChannelType> getExecutableIn() {
        return this.executableIn;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getPerms() {
        return this.perms;
    }
}

