/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.commands.values;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.itsthesky.disky.elements.commands.CommandEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Used Alias")
@Description(value={"Return the used alias in a discord command trigger section.", "It can only be used here, and will throw an error if not."})
@Examples(value={"set {_alias} to the used alias"})
public class UsedAlias
extends SimpleExpression<String> {
    protected String @NotNull [] get(@NotNull Event e) {
        return new String[]{((CommandEvent)e).getUsedAlias()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the used alias";
    }

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(CommandEvent.class)) {
            Skript.error((String)"The used alias can only used in a discord command trigger section.");
            return false;
        }
        return true;
    }

    static {
        Skript.registerExpression(UsedAlias.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] use[d]( |-)alias[es]"});
    }
}

