/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.commands;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.itsthesky.disky.api.skript.SpecificBotEffect;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Manage Command Permissions")
@Description(value={"This effect allows you to manage the permissions of slash commands, with the following rules:", " - By default, the command is marked as ENABLED, and anyone can see & use it.", " - You can DISABLE completely the command (first pattern), only admins will be able to use it.", " - Or you can ENABLE the commands for specific PERMISSIONS (second pattern)."})
@Examples(value={"disable command{_cmd1} # disable the command for everyone, except the admins.", "enable command {_cmd2} for manage server # enable the command only for the users who have the 'manage server' permission."})
public class EffEnableDisableCommand
extends SpecificBotEffect {
    private Expression<SlashCommandData> exprCommand;
    private Expression<Permission> exprPermissions;
    private boolean isDisable;

    @Override
    public void runEffect(@NotNull Event e, @NotNull Bot bot) {
        SlashCommandData commandData = EffEnableDisableCommand.parseSingle(this.exprCommand, e, null);
        Permission[] permissions = EffEnableDisableCommand.parseList(this.exprPermissions, e, new Permission[0]);
        if (commandData == null || !this.isDisable && permissions.length == 0) {
            this.restart();
            return;
        }
        if (this.isDisable) {
            commandData.setDefaultPermissions(DefaultMemberPermissions.DISABLED);
        } else {
            commandData.setDefaultPermissions(DefaultMemberPermissions.enabledFor(permissions));
        }
        this.restart();
    }

    @Override
    public boolean initEffect(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.isDisable = i == 0;
        this.exprCommand = expressions[0];
        if (!this.isDisable) {
            this.exprPermissions = expressions[1];
        }
        return true;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return this.isDisable ? "disable the command " + this.exprCommand.toString(e, debug) : "enable the command " + this.exprCommand.toString(e, debug) + " for the permissions " + this.exprPermissions.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffEnableDisableCommand.class, (String[])new String[]{"disable [the] [command] %slashcommand%", "enable [the] [command] %slashcommands% (for|to) [the] [permissions] %permissions%"});
    }
}

