/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.commands;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.requests.restaction.CommandListUpdateAction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.WaiterEffect;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.Debug;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffUpdateCommand
extends WaiterEffect {
    private boolean isGlobal;
    private Expression<SlashCommandData> exprCommands;
    private Expression<Object> exprEntity;

    public boolean initEffect(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.exprCommands = expressions[0];
        this.exprEntity = expressions[1];
        this.isGlobal = (parseResult.mark & 1) != 0;
        return true;
    }

    @Override
    public void runEffect(Event e) {
        CommandData[] commands = EffUpdateCommand.parseList(this.exprCommands, e, new SlashCommandData[0]);
        Object entity = EffUpdateCommand.parseSingle(this.exprEntity, e, null);
        if (commands.length == 0) {
            Debug.debug((Object)this, Debug.Type.EMPTY_LIST, "No commands found.");
            this.restart();
            return;
        }
        if (EffUpdateCommand.anyNull((Object)this, entity)) {
            this.restart();
            return;
        }
        if (this.isGlobal && !(entity instanceof Bot)) {
            Debug.debug((Object)this, Debug.Type.INCOMPATIBLE_TYPE, "The entity must be a bot to update commands globally!");
            this.restart();
            return;
        }
        if (!this.isGlobal && !(entity instanceof Guild)) {
            Debug.debug((Object)this, Debug.Type.INCOMPATIBLE_TYPE, "The entity must be a guild to update commands locally!");
            this.restart();
            return;
        }
        CommandListUpdateAction updateAction = this.isGlobal ? ((Bot)entity).getInstance().updateCommands() : ((Guild)entity).updateCommands();
        updateAction.addCommands(commands).queue(x$0 -> this.restart(x$0), ex -> {
            this.restart();
            DiSky.getErrorHandler().exception(e, (Throwable)ex);
        });
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "update commands " + this.exprCommands.toString(e, debug) + " in " + this.exprEntity.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffUpdateCommand.class, (String[])new String[]{"(update|register) [the] [command[s]] %slashcommands% [(1\u00a6globally|2\u00a6locally)] in [the] [(bot|guild)] %bot/guild%"});
    }
}

