/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.commands;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import java.util.ArrayList;
import java.util.Arrays;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Sub-command Groups")
@Description(value={"Represent every sub-slash-command groups a slash command have.", "You can add sub-slash-commands to a group, then add this group into the base slash command."})
public class ExprCommandGroup
extends MultiplyPropertyExpression<SlashCommandData, SubcommandGroupData> {
    @Override
    @NotNull
    public Class<? extends SubcommandGroupData> getReturnType() {
        return SubcommandGroupData.class;
    }

    public void change(@NotNull Event e, @NotNull Object[] delta, @NotNull Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        SlashCommandData command = EasyElement.parseSingle(this.getExpr(), e, null);
        SubcommandGroupData[] datas = (SubcommandGroupData[])delta;
        if (EasyElement.anyNull((Object)this, command, datas)) {
            return;
        }
        ArrayList<SubcommandGroupData> news = new ArrayList<SubcommandGroupData>(Arrays.asList(datas));
        ArrayList<SubcommandGroupData> current = new ArrayList<SubcommandGroupData>(command.getSubcommandGroups());
        switch (mode) {
            case ADD: {
                current.addAll(news);
                break;
            }
            case SET: {
                current.clear();
                current.addAll(news);
                break;
            }
            case RESET: 
            case REMOVE_ALL: {
                current.clear();
            }
        }
        try {
            command.addSubcommandGroups(current);
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(e, ex);
        }
    }

    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (EasyElement.isChangerMode(mode)) {
            return new Class[]{SubcommandGroupData[].class, SubcommandGroupData.class};
        }
        return new Class[0];
    }

    @Override
    protected String getPropertyName() {
        return "groups";
    }

    protected SubcommandGroupData[] convert(SlashCommandData data) {
        return data.getSubcommandGroups().toArray(new SubcommandGroupData[0]);
    }

    static {
        ExprCommandGroup.register(ExprCommandGroup.class, SubcommandGroupData.class, "sub[[( |-)]command[s]] group[s]", "slashcommand");
    }
}

