/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.commands;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="New Message Command")
@Description(value={"Create a new message command, to be updated on discord later.", "This will create a context command of MESSAGE type.", "Once created, you can execute it by right-clicking on a message, then going in 'Applications' -> <your message command name>"})
@Examples(value={"new message command named \"Warn Message\""})
public class ExprNewMessageCommand
extends SimpleExpression<CommandData> {
    private Expression<String> exprName;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        return true;
    }

    protected CommandData @NotNull [] get(@NotNull Event e) {
        String name = EasyElement.parseSingle(this.exprName, e, null);
        if (EasyElement.anyNull((Object)this, name)) {
            return new CommandData[0];
        }
        return new CommandData[]{Commands.message(name)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends CommandData> getReturnType() {
        return CommandData.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "new message command named " + this.exprName.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprNewMessageCommand.class, CommandData.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] message[( |-)]command [with] [(the name|named)] %string%"});
    }
}

