/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.commands;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="New Option Choice")
@Description(value={"Create a new slash command option choice with an unique name and a string or number value.", "Choices are only available for STRING, NUMBER and INTEGER slash command option type.", "Of course, the provided value type must be compatible with the option type (you cannot add string choice to a NUMBER option)."})
@Examples(value={"add new choice named \"Example choice\" with value 100 to choices of {_option} # it's a NUMBER option"})
public class ExprNewOptionChoice
extends SimpleExpression<Command.Choice> {
    private Expression<String> exprName;
    private Expression<Object> exprValue;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        this.exprValue = exprs[1];
        return true;
    }

    protected Command.Choice @NotNull [] get(@NotNull Event e) {
        Object value;
        String name = EasyElement.parseSingle(this.exprName, e, null);
        if (EasyElement.anyNull((Object)this, name, value = EasyElement.parseSingle(this.exprValue, e, null))) {
            return new Command.Choice[0];
        }
        Command.Choice choice = value instanceof String ? new Command.Choice(name, value) : (((Number)value).doubleValue() % 1.0 == 0.0 ? new Command.Choice(name, ((Number)value).intValue()) : new Command.Choice(name, ((Number)value).doubleValue()));
        return new Command.Choice[]{choice};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Command.Choice> getReturnType() {
        return Command.Choice.class;
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "new choice named " + this.exprName.toString(e, debug) + " with value " + this.exprValue.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprNewOptionChoice.class, Command.Choice.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] new [option] choice [(named|with name)] %string% with [the] value %string/number%"});
    }
}

