/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.commands;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExprNewSlashOption
extends SimpleExpression<OptionData> {
    private Expression<OptionType> exprType;
    private Expression<String> exprName;
    private Expression<String> exprDesc;
    private boolean required;
    private boolean autoComplete;
    private boolean member;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprType = exprs[0];
        this.exprName = exprs[1];
        this.exprDesc = exprs[2];
        this.member = parseResult.hasTag("member");
        this.required = parseResult.hasTag("required");
        this.autoComplete = parseResult.hasTag("auto");
        return true;
    }

    protected OptionData @NotNull [] get(@NotNull Event e) {
        OptionType type = EasyElement.parseSingle(this.exprType, e, null);
        String name = EasyElement.parseSingle(this.exprName, e, null);
        String desc = EasyElement.parseSingle(this.exprDesc, e, null);
        if (EasyElement.anyNull((Object)this, name, desc)) {
            return new OptionData[0];
        }
        if (this.member) {
            return new OptionData[]{new OptionData(OptionType.USER, name, desc, this.required, this.autoComplete)};
        }
        if (type == null) {
            return new OptionData[0];
        }
        return new OptionData[]{new OptionData(type, name, desc, this.required, this.autoComplete)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends OptionData> getReturnType() {
        return OptionData.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "new " + this.exprType.toString(e, debug) + " option named " + this.exprName.toString(e, debug) + " with description " + this.exprDesc.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprNewSlashOption.class, OptionData.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] [slash[( |-)]command] [(:required)] [(:auto[( |-)]complete)] (%-optiontype%|:member) option [(named|with name)] %string% with [the] desc[ription] %string%"});
    }
}

