/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.Component;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.selections.SelectMenu;
import net.dv8tion.jda.api.interactions.components.text.TextInput;

public class ComponentRow {
    private SelectMenu menu;
    private TextInput input;
    private final List<Button> buttons;

    public ComponentRow(SelectMenu menu, TextInput input, List<Button> buttons) {
        this.menu = menu;
        this.input = input;
        this.buttons = buttons;
    }

    public ComponentRow() {
        this.menu = null;
        this.input = null;
        this.buttons = new ArrayList<Button>();
    }

    public ComponentRow(List<Object> components) {
        this();
        for (Object component : components) {
            if (component instanceof SelectMenu) {
                SelectMenu menu = (SelectMenu)component;
                this.setMenu(menu);
                continue;
            }
            if (component instanceof Button) {
                Button button = (Button)component;
                this.add(button);
                continue;
            }
            if (component instanceof TextInput) {
                TextInput input = (TextInput)component;
                this.setInput(input);
                continue;
            }
            if (component instanceof SelectMenu.Builder) {
                SelectMenu.Builder menuBuilder = (SelectMenu.Builder)component;
                this.setMenu((SelectMenu)menuBuilder.build());
                continue;
            }
            if (!(component instanceof TextInput.Builder)) continue;
            TextInput.Builder inputBuilder = (TextInput.Builder)component;
            this.setInput(inputBuilder.build());
        }
    }

    public TextInput getInput() {
        return this.input;
    }

    public void setInput(TextInput input) {
        this.input = input;
    }

    public List<ItemComponent> asComponents() {
        if (this.getMenu() != null) {
            return Collections.singletonList(this.getMenu());
        }
        if (this.getInput() != null) {
            return Collections.singletonList(this.getInput());
        }
        return new ArrayList<ItemComponent>(this.getButtons());
    }

    public void setMenu(SelectMenu menu) {
        this.menu = menu;
    }

    public void add(Button button) {
        this.buttons.add(button);
    }

    public SelectMenu getMenu() {
        return this.menu;
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public ActionRow asActionRow() {
        return ActionRow.of(this.asComponents());
    }

    public void addAll(List<Component> components) {
        for (Component component : components) {
            if (component instanceof SelectMenu) {
                this.setMenu((SelectMenu)component);
                continue;
            }
            if (component instanceof Button) {
                this.add((Button)component);
                continue;
            }
            if (!(component instanceof TextInput)) continue;
            this.setInput((TextInput)component);
        }
    }

    public boolean isEmpty() {
        return this.menu == null && this.input == null && this.buttons.isEmpty();
    }
}

