/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.create;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.SkuSnowflake;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="New Button")
@Description(value={"Create a new button with an ID and some optional options. It can be either enabled or disabled, and either link or action. If the button is a link-type, then the ID will be the URL that the user will be redirect to."})
@Examples(value={"set {_btn} to new enabled danger button with id \"button-id\" named \"Hello world :p\""})
public class ExprNewButton
extends SimpleExpression<Button> {
    private Node node;
    private boolean isPremium;
    private Expression<String> exprSkuId;
    private Expression<String> exprIdOrURL;
    private Expression<ButtonStyle> exprStyle;
    private Expression<String> exprContent;
    private Expression<Emote> exprEmoji;
    private boolean isEnabled;
    private boolean isLink;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.isPremium = matchedPattern == 1;
        this.isEnabled = !parseResult.expr.contains("new disabled");
        this.node = this.getParser().getNode();
        if (this.isPremium) {
            this.exprSkuId = exprs[0];
            return true;
        }
        this.exprStyle = exprs[0];
        this.exprIdOrURL = exprs[1];
        this.exprContent = exprs[2];
        this.exprEmoji = exprs[3];
        this.isLink = parseResult.expr.contains("new link") || parseResult.expr.contains("link button");
        return true;
    }

    protected Button @NotNull [] get(@NotNull Event e) {
        Button button;
        Emote emoji;
        ButtonStyle style;
        if (this.isPremium) {
            String skuId = (String)this.exprSkuId.getSingle(e);
            if (!DiSkyRuntimeHandler.checkSet(this.node, skuId, this.exprSkuId)) {
                return new Button[0];
            }
            if (!DiSkyRuntimeHandler.checkSnowflake(this.node, skuId)) {
                return new Button[0];
            }
            return new Button[]{Button.premium(SkuSnowflake.fromId(skuId)).withDisabled(!this.isEnabled)};
        }
        String idOrURL = (String)this.exprIdOrURL.getSingle(e);
        if (!DiSkyRuntimeHandler.checkSet(this.node, new Object[]{idOrURL, this.exprIdOrURL, style = (ButtonStyle)((Object)this.exprStyle.getSingle(e)), this.exprStyle})) {
            return new Button[0];
        }
        String content = this.exprContent == null ? null : (String)this.exprContent.getSingle(e);
        Emote emote = emoji = this.exprEmoji == null ? null : (Emote)this.exprEmoji.getSingle(e);
        if (emoji == null && content == null) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("You need to specify a content OR an emoji for the button!"), this.node, false);
            return new Button[0];
        }
        if (this.isLink) {
            style = ButtonStyle.LINK;
        }
        Button button2 = button = content == null ? Button.of(style, idOrURL, "") : Button.of(style, idOrURL, content);
        if (emoji != null && content != null) {
            button = Button.of(style, idOrURL, content).withEmoji(emoji.getEmoji());
        }
        if (!this.isEnabled) {
            button = button.asDisabled();
        }
        return new Button[]{button};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Button> getReturnType() {
        return Button.class;
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        if (this.isPremium) {
            return "new premium button with sku id " + this.exprSkuId.toString(e, debug);
        }
        return "new " + (this.isEnabled ? "enabled" : "disabled") + " " + this.exprStyle.toString(e, debug) + " button with id " + this.exprIdOrURL.toString(e, debug) + (String)(this.exprContent == null ? "" : " named " + this.exprContent.toString(e, debug)) + (String)(this.exprEmoji == null ? "" : " with emoji " + this.exprEmoji.toString(e, debug));
    }

    static {
        Skript.registerExpression(ExprNewButton.class, Button.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a] new [(enabled|disabled)] %buttonstyle% [link] button [with (id|url)] %string% [(named|with label) %-string%][,] [with [emoji] %-emote%]", "[a] new [disabled] premium button (with|using) sku [id] %string%"});
    }
}

